//1.1 SDK interface definitions.
//==========================================================================================
typedef long __stdcall _oakBegin(char *pFileName,char *pOwnerPw,char *pUserPw);
typedef long __stdcall _oakEnd(long nHandle);
typedef long __stdcall _oakExport(long nHandle,long nPageNo);
typedef long __stdcall _oakSetup(long  nHandle, //Conversion object's handle.
                                       long  nIndex,  //Property tag,refer to the following property definitions.
                                       char *pValue,  //A String value of the property,(or)
                                       long  nValue,  //An integer value of the property.
                                       long  nOther); //Only valid for progress call-back.
typedef long __stdcall _oakGetPageTotal(long  nHandle, //Conversion object's handle.
                                       long &nValue); //An integer value of the property
//==========================================================================================

//1.2 Definitions of converter's properties 
//==========================================================================================
//read/write properties
const long oak_PROP_OUTDIR       = 1;  //Destination directory.
const long oak_PROP_PREFIX       = 2;  //The prefix of the name of result image file.
const long oak_PROP_PAGEZOOM     = 3;  //Zoom scale of the source pdf page.
const long oak_PROP_BGCOLOR      = 4;  //Image background color.
const long oak_PROP_IMAGETYPE    = 5;  //Result image format.
const long oak_PROP_BITCOUNT     = 6;  //Color bits per pixel.
const long oak_PROP_XDPI         = 7;  //Horizontal resolution.
const long oak_PROP_YDPI         = 8;  //Vertical resolution.
const long oak_PROP_QUALITY      = 9;  //JPEG compression quality.
const long oak_PROP_COMPRESSION  = 10; //TIFF compression mode.
const long oak_PROP_MULTIPAGES   = 11; //Multipages TIFF file.
const long oak_PROP_GRAYSCALE    = 12; //Grayscale image.
const long oak_PROP_XDIMENSIONS  = 13; //The width of the result image in pixel
const long oak_PROP_YDIMENSIONS  = 14; //The height of the result image in pixel

//read only properties
const long oak_PROP_PAGECOUNT  = 20; //The total pages of source pdf file.
const long oak_PROP_PAGEHEIGHT = 21; //Height of the current page of source pdf file.
const long oak_PROP_PAGEWIDTH  = 22; //Width of the current page of source pdf file.

//write only properties
const long oak_PROP_PROGRESSFUNC = 40; //Address of the progress call-back function.
//==========================================================================================

//1.3 TIFF tag definitions.
//==========================================================================================
const long oak_TIFF_COMPRESSION_NONE     = 0;  //No compression.
const long oak_TIFF_COMPRESSION_LZW      = 1;  //1,4,8,24bits(default 4,8,24bits)
const long oak_TIFF_COMPRESSION_JPEG     = 2;  //Grayscale 8bits,24bits
const long oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
const long oak_TIFF_COMPRESSION_CCITTG4  = 4;  //1bit(default 1bit)
const long oak_TIFF_COMPRESSION_CCITTG3  = 5;  //1bit
const long oak_TIFF_COMPRESSION_RLE      = 6;  //1bit
//==========================================================================================

//1.4 Image type definitions
//=======================================================================================
const long oak_IMAGE_BMP  = 1;   //BMP
const long oak_IMAGE_EMF  = 2;   //EMF
const long oak_IMAGE_WMF  = 3;   //WMF
const long oak_IMAGE_JPG  = 4;   //JPG
const long oak_IMAGE_PNG  = 5;   //PNG
const long oak_IMAGE_GIF  = 6;   //GIF
const long oak_IMAGE_TIF  = 7;   //TIF
const long oak_IMAGE_PCX  = 8;   //PCX

const long oak_IMAGE_JPEG = 4;   //JPEG
const long oak_IMAGE_TIFF = 7;   //TIFF
//=======================================================================================

//1.5 Return code definitions.
//==========================================================================================
const long RTN_OK = 1;           //Successful operation.
const long ERR_UNKNOWN = -99;    //Unknown system error.

const long ERR_OVER_MAXTHREADS    = -1;  //Over the limit amount of threads
const long ERR_FILE_UNEXIST       = -2;  //Source PDF file unexist.
const long ERR_FILE_DAMAGED       = -3;  //Source PDF file is damaged.
const long ERR_FILE_RESTRICTED    = -4;  //Source PDF file is restricted.

const long ERR_INVALID_PAGE    = -5;   //The PDF page is invalid.
const long ERR_CONVERT_FAILURE = -8;   //Conversion failure.
const long ERR_INVALID_STREAM  = -9;   //Invalid memory stream address.
const long ERR_INVALID_HANDLE  = -10;  //The handle of conversion object is invalid.
//==========================================================================================
