unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, oak_define;

type

  TMainForm = class(TForm)
    btnDemo1: TButton;
    btnDemo2: TButton;
    m_ProgressBar: TProgressBar;
    procedure btnDemo1Click(Sender: TObject);
    procedure btnDemo2Click(Sender: TObject);
  private
    { Private declarations }

    //SDK interface definitions.
    //For more,please refer to "oak_define.pas"
    //---------------------------------------------------------------------------
    m_hDll: HMODULE;
    oakBegin: _oakBegin;
    oakEnd: _oakEnd;
    oakExport: _oakExport;
    oakSetup: _oakSetup;
    oakGetPageTotal: _oakGetPageTotal;

    function LoadDLL():BOOL;  //Load dynamic link library "pdf2tiff.dll"!
    function FreeDLL():BOOL;  //free dynamic link library "pdf2tiff.dll"!
    //----------------------------------------------------------------------------

  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

//Load dynamic link library---pdf2tiff.dll!
function TMainForm.LoadDLL():BOOL;
var
   sDllFile: PAnsiChar;
   pFunc: FARPROC;
label
   ERR_FLAG;
begin
   sDllFile := 'pdf2tiff.dll';
   m_hDll := LoadLibrary(sDllFile);
   if m_hDll = 0 then
   begin
      Result := FALSE;
      exit;
   end;

	 pFunc := GetProcAddress(m_hDll, 'oakBegin');
	 if pFunc = nil then goto ERR_FLAG;
   oakBegin := pFunc;

	 pFunc := GetProcAddress(m_hDll, 'oakEnd');
	 if pFunc = nil then goto ERR_FLAG;
   oakEnd := pFunc;

	 pFunc := GetProcAddress(m_hDll, 'oakExport');
	 if pFunc = nil then goto ERR_FLAG;
   oakExport := pFunc;

	 pFunc := GetProcAddress(m_hDll, 'oakSetup');
	 if pFunc = nil then goto ERR_FLAG;
   oakSetup := pFunc;

	 pFunc := GetProcAddress(m_hDll, 'oakGetPageTotal');
	 if pFunc = nil then goto ERR_FLAG;
   oakGetPageTotal := pFunc;

   Result := TRUE;
   exit;

ERR_FLAG:
   Result := FALSE;
end;

//Free dynamic link library---pdf2tiff.dll!
function TMainForm.FreeDLL():BOOL;
begin
	if m_hDll <> 0  then
  begin
     FreeLibrary(m_hDll);
     m_hDll := 0;
  end;
	Result := TRUE;
end;

//The progress's call-back function.
//To set conversion progress.
procedure GGetProgress(nOther:Longint;iProgress:Longint);cdecl;
var
   this: TMainForm;
begin
   this := TMainForm(nOther);
   this.m_ProgressBar.Position := iProgress;
   this.m_ProgressBar.Refresh;
end;

//Demo1 - Convert all pdf pages.
procedure TMainForm.btnDemo1Click(Sender: TObject);
var
   sPdfFile: PAnsiChar;
   nHandle: Longint;

begin
   sPdfFile := 'oak.pdf';

   if LoadDLL() = FALSE then
   begin
      ShowMessage('Loading pdf2tiff.dll failure!');
      exit;
   end;

   //Open pdf file and creating a converter.
   nHandle := oakBegin(sPdfFile,nil,nil);
   case nHandle of
     ERR_OVER_MAXTHREADS: begin ShowMessage('Over the limit amount of threads,please waiting!'); FreeDLL(); exit; end;
     ERR_FILE_UNEXIST: begin ShowMessage('Source pdf file unexist!'); FreeDLL(); exit; end;
     ERR_FILE_DAMAGED: begin ShowMessage('Source pdf file damaged!'); FreeDLL(); exit; end;
     ERR_FILE_RESTRICTED: begin ShowMessage('Source pdf file restricted!'); FreeDLL(); exit; end;
   end;

   //Setting the converter's propertys.
   //For more,please refer to "oak_define.pas".
   oakSetup(nHandle,oak_PROP_OUTDIR,'./output1',0,0);//output directory
   oakSetup(nHandle,oak_PROP_PREFIX,'myimg',0,0);//prefix of image file name

   oakSetup(nHandle,oak_PROP_XDPI,nil,120,0);//horizontal dpi
   oakSetup(nHandle,oak_PROP_YDPI,nil,120,0);//vertical dpi

   //Setting the progress's call-back function.
   //The last parameter will be used at call-back function as a parameter value.
	 oakSetup(nHandle,oak_PROP_PROGRESSFUNC,nil,Longint(@GGetProgress),Longint(self));

	 //To convert the pdf file.
	 oakExport(nHandle,0);

   //Close pdf file and destory the converter.
   oakEnd(nHandle);

   ShowMessage('Conversion successful');

   FreeDLL();
end;

//Demo2 - Convert appointed pdf pages.
procedure TMainForm.btnDemo2Click(Sender: TObject);
var
   sPdfFile: PAnsiChar;
   m_Pages: array[0..4] of Longint;
   nHandle: Longint;
   iPageCount,iPos: Longint;

begin
   sPdfFile := 'oak.pdf';
   m_Pages[0] := 7;
   m_Pages[1] := 7;
   m_Pages[2] := 19;
   m_Pages[3] := 15;
   m_Pages[4] := 2;

   if LoadDLL() = FALSE then
   begin
      ShowMessage('Loading pdf2tiff.dll failure!');
      exit;
   end;

   //Open pdf file and creating a converter.
   nHandle := oakBegin(sPdfFile,nil,nil);
   case nHandle of
     ERR_OVER_MAXTHREADS: begin ShowMessage('Over the limit amount of threads,please waiting!'); FreeDLL(); exit; end;
     ERR_FILE_UNEXIST: begin ShowMessage('Source pdf file unexist!'); FreeDLL(); exit; end;
     ERR_FILE_DAMAGED: begin ShowMessage('Source pdf file damaged!'); FreeDLL(); exit; end;
     ERR_FILE_RESTRICTED: begin ShowMessage('Source pdf file restricted!'); FreeDLL(); exit; end;
   end;

   //Setting the converter's propertys.
   //For more,please refer to header file---oak_define.pas.
   oakSetup(nHandle,oak_PROP_OUTDIR,'./output2',0,0);//output directory

   oakSetup(nHandle,oak_PROP_BITCOUNT,nil,24,0);//color bits
   oakSetup(nHandle,oak_PROP_XDPI,nil,150,0);//horizontal dpi
   oakSetup(nHandle,oak_PROP_YDPI,nil,150,0);//vertical dpi
   oakSetup(nHandle,oak_PROP_COMPRESSION,nil,oak_TIFF_COMPRESSION_LZW,0);//tiff compression mode
   oakSetup(nHandle,oak_PROP_MULTIPAGES,nil,1,0);//multipages tiff.

   //To convert the appointed pages of the pdf file.
   iPageCount := 5;
   for iPos := 0 to iPageCount-1 do
   begin
       oakExport(nHandle,m_Pages[iPos]);

		   //Setting conversion's progress.
       m_ProgressBar.Position := Round((iPos+1)*1.0/iPageCount*100);
   end;

   //Close pdf file and destory the converter.
   oakEnd(nHandle);

   ShowMessage('Conversion successful');

   FreeDLL();
end;


end.
