Public Class MainForm
    '1.1 SDK interface definitions.
    Private Declare Function oakBegin Lib "pdf2tiff.dll" (ByVal lpFileName As String, ByVal lpOwnerPw As String, ByVal lpUserPw As String) As Integer
    Private Declare Function oakEnd Lib "pdf2tiff.dll" (ByVal nHandle As Integer) As Integer
    Private Declare Function oakExport Lib "pdf2tiff.dll" (ByVal nHandle As Integer, ByVal nPageNo As Integer) As Integer
    Private Declare Function oakSetup Lib "pdf2tiff.dll" (ByVal nHandle As Integer, ByVal nIndex As Integer, ByVal lpValue As String, ByVal nValue As Integer, ByVal nOther As Integer) As Integer
    Private Declare Function oakGetPageTotal Lib "pdf2tiff.dll" (ByVal nHandle As Integer, ByRef nValue As Integer) As Integer

    '1.2 Definitions of converter's properties
    '==========================================================================================
    'read/write properties
    Const oak_PROP_OUTDIR = 1         'Destination directory.
    Const oak_PROP_PREFIX = 2         'The prefix of the name of result image file.
    Const oak_PROP_PAGEZOOM = 3       'Zoom scale of the source pdf page.
    Const oak_PROP_BGCOLOR = 4        'Image background color.
    Const oak_PROP_IMAGETYPE = 5      'Result image format.
    Const oak_PROP_BITCOUNT = 6       'Color bits per pixel.
    Const oak_PROP_XDPI = 7           'Horizontal resolution.
    Const oak_PROP_YDPI = 8           'Vertical resolution.
    Const oak_PROP_QUALITY = 9        'JPEG compression quality.
    Const oak_PROP_COMPRESSION = 10   'TIFF compression mode.
    Const oak_PROP_MULTIPAGES = 11    'Multipages TIFF file.
    Const oak_PROP_GRAYSCALE = 12     'Grayscale image.
    Const oak_PROP_XDIMENSIONS = 13   'The width of the result image in pixel
    Const oak_PROP_YDIMENSIONS = 14   'The height of the result image in pixel

    'read only properties
    Const oak_PROP_PAGECOUNT = 20     'The total pages of source pdf file.
    Const oak_PROP_PAGEHEIGHT = 21    'Height of the current page of source pdf file.
    Const oak_PROP_PAGEWIDTH = 22     'Width of the current page of source pdf file.
    '==========================================================================================

    '1.3 TIFF tag's definitions.
    '==========================================================================================
    Const oak_TIFF_COMPRESSION_NONE = 0      'No compression.
    Const oak_TIFF_COMPRESSION_LZW = 1       '1,4,8,24bits(default 4,8,24bits)
    Const oak_TIFF_COMPRESSION_JPEG = 2      'Grayscale 8bits,24bits
    Const oak_TIFF_COMPRESSION_PACKBITS = 3  '4,8,24bits
    Const oak_TIFF_COMPRESSION_CCITTG4 = 4   '1bit(default 1bit)
    Const oak_TIFF_COMPRESSION_CCITTG3 = 5   '1bit
    Const oak_TIFF_COMPRESSION_RLE = 6       '1bit
    '==========================================================================================


    '1.4 Image type's definitions
    '=======================================================================================
    Const oak_IMAGE_BMP = 1    'BMP
    Const oak_IMAGE_EMF = 2    'EMF
    Const oak_IMAGE_WMF = 3    'WMF
    Const oak_IMAGE_JPG = 4    'JPG
    Const oak_IMAGE_PNG = 5    'PNG
    Const oak_IMAGE_GIF = 6    'GIF
    Const oak_IMAGE_TIF = 7    'TIF
    Const oak_IMAGE_PCX = 8    'PCX

    Const oak_IMAGE_JPEG = 4   'JPEG
    Const oak_IMAGE_TIFF = 7   'TIFF
    '=======================================================================================

    '1.5 Return code's definitions.
    '==========================================================================================
    Const RTN_OK = 1           'Successful operation.
    Const ERR_UNKNOWN = -99    'Unknown system error.

    Const ERR_OVER_MAXTHREADS = -1     'Over the limit amount of threads
    Const ERR_FILE_UNEXIST = -2        'Source PDF file unexist.
    Const ERR_FILE_DAMAGED = -3        'Source PDF file is damaged.
    Const ERR_FILE_RESTRICTED = -4     'Source PDF file is restricted.

    Const ERR_INVALID_PAGE = -5      'The PDF page is invalid.
    Const ERR_CONVERT_FAILURE = -8   'Conversion failure.
    Const ERR_INVALID_STREAM = -9    'Invalid memory stream address.
    Const ERR_INVALID_HANDLE = -10   'The handle of conversion object is invalid.
    '==========================================================================================


    '1.6 Windows API definitions.
    '==========================================================================================
    Private Const OFS_MAXPATHNAME = 128

    Private Declare Function GetCurrentProcess Lib "kernel32" () As Integer
    Private Declare Function ReadProcessMemory Lib "kernel32" (ByVal hProcess As Integer, ByVal lpBaseAddress As Integer, ByVal lpBuffer() As Byte, ByVal nSize As Integer, ByRef lpNumberOfBytesWritten As Integer) As Integer

    'Demo1 - Convert all pdf pages.
    Private Sub btnDemo1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDemo1.Click
        Dim nHandle As Integer
        Dim iPageNo, iPageAmount As Integer


        'Open pdf file and creating a converter.
        nHandle = oakBegin("oak.pdf", "", "")
        Select Case nHandle
            Case ERR_OVER_MAXTHREADS
                MsgBox("Over the limit amount of threads,please waiting!")
                Exit Sub
            Case ERR_FILE_UNEXIST
                MsgBox("Source pdf file unexist!")
                Exit Sub
            Case ERR_FILE_DAMAGED
                MsgBox("Source pdf file damaged!")
                Exit Sub
            Case ERR_FILE_RESTRICTED
                MsgBox("Source pdf file restricted!")
                Exit Sub
        End Select

        'Setting the converter's propertys.
        'For more, please refer to above definitions.
        oakSetup(nHandle, oak_PROP_OUTDIR, "./output1", 0, 0)  'output directory
        oakSetup(nHandle, oak_PROP_PREFIX, "myimg", 0, 0)    'prefix of image file name

        oakSetup(nHandle, oak_PROP_XDPI, "", 120, 0)  'horizontal dpi
        oakSetup(nHandle, oak_PROP_YDPI, "", 120, 0)  'vertical dpi

        'Get the amount of the source pdf pages
        oakGetPageTotal(nHandle, iPageAmount)

        'To convert the pdf file.
        For iPageNo = 1 To iPageAmount
            oakExport(nHandle, iPageNo)

            'Setting conversion's progress.
            m_ProgressBar.Value = Math.Round((iPageNo * 1.0#) / iPageAmount * 100)
        Next

        'Close pdf file and destory the converter.
        oakEnd(nHandle)

        MsgBox("Conversion successful")
    End Sub

    'Demo2 - Convert appointed pdf pages.
    Private Sub btnDemo2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDemo2.Click
        Dim nHandle As Integer
        Dim iPageCount, iPos As Integer
        Dim m_Pages(5) As Integer
        m_Pages(0) = 7
        m_Pages(1) = 7
        m_Pages(2) = 19
        m_Pages(3) = 15
        m_Pages(4) = 2


        'Open pdf file and creating a converter.
        nHandle = oakBegin("oak.pdf", "", "")
        Select Case nHandle
            Case ERR_OVER_MAXTHREADS
                MsgBox("Over the limit amount of threads,please waiting!")
                Exit Sub
            Case ERR_FILE_UNEXIST
                MsgBox("Source pdf file unexist!")
                Exit Sub
            Case ERR_FILE_DAMAGED
                MsgBox("Source pdf file damaged!")
                Exit Sub
            Case ERR_FILE_RESTRICTED
                MsgBox("Source pdf file restricted!")
                Exit Sub
        End Select

        'Setting the converter's propertys.
        'For more, please refer to above definitions.
        oakSetup(nHandle, oak_PROP_OUTDIR, "./output2", 0, 0)  'output directory

        oakSetup(nHandle, oak_PROP_BITCOUNT, "", 24, 0) 'color bits
        oakSetup(nHandle, oak_PROP_XDPI, "", 120, 0)  'horizontal dpi
        oakSetup(nHandle, oak_PROP_YDPI, "", 120, 0)  'vertical dpi
        oakSetup(nHandle, oak_PROP_COMPRESSION, "", oak_TIFF_COMPRESSION_LZW, 0)  'tiff compression mode
        oakSetup(nHandle, oak_PROP_MULTIPAGES, "", True, 0)   'vertical dpi

        'To convert the pdf file.
        iPageCount = UBound(m_Pages)
        For iPos = 0 To iPageCount - 1
            oakExport(nHandle, m_Pages(iPos))

            'Setting conversion's progress.
            m_ProgressBar.Value = Math.Round(((iPos + 1) * 1.0#) / iPageCount * 100)
        Next

        'Close pdf file and destory the converter.
        oakEnd(nHandle)

        MsgBox("Conversion successful")
    End Sub



    Private Sub MainForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class
