VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Begin VB.Form MainForm 
   Caption         =   "Oakdoc"
   ClientHeight    =   2205
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5565
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2205
   ScaleWidth      =   5565
   StartUpPosition =   3  'ȱʡ
   Begin VB.CommandButton btnDemo2 
      Caption         =   "Two"
      Height          =   375
      Left            =   3720
      TabIndex        =   2
      Top             =   600
      Width           =   1095
   End
   Begin ComctlLib.ProgressBar m_ProgressBar 
      Align           =   2  'Align Bottom
      Height          =   420
      Left            =   0
      TabIndex        =   1
      Top             =   1785
      Width           =   5565
      _ExtentX        =   9816
      _ExtentY        =   741
      _Version        =   327682
      Appearance      =   1
   End
   Begin VB.CommandButton btnDemo1 
      Caption         =   "One"
      Default         =   -1  'True
      Height          =   375
      Index           =   0
      Left            =   480
      TabIndex        =   0
      Top             =   600
      Width           =   1095
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'1.1 SDK interface definitions.
Private Declare Function oakBegin Lib "pdf2tiff.dll" (ByVal lpFileName As String, ByVal lpOwnerPw As String, ByVal lpUserPw As String) As Long
Private Declare Function oakEnd Lib "pdf2tiff.dll" (ByVal nHandle As Long) As Long
Private Declare Function oakExport Lib "pdf2tiff.dll" (ByVal nHandle As Long, ByVal nPageNo As Long) As Long
Private Declare Function oakSetup Lib "pdf2tiff.dll" (ByVal nHandle As Long, ByVal nIndex As Long, ByVal lpValue As String, ByVal nValue As Long, ByVal nOther As Long) As Long
Private Declare Function oakGetPageTotal Lib "pdf2tiff.dll" (ByVal nHandle As Long, ByRef nValue As Long) As Long


'1.2 Definitions of converter's properties
'==========================================================================================
'read/write properties
 Const oak_PROP_OUTDIR = 1         'Destination directory.
 Const oak_PROP_PREFIX = 2         'The prefix of the name of result image file.
 Const oak_PROP_PAGEZOOM = 3       'Zoom scale of the source pdf page.
 Const oak_PROP_BGCOLOR = 4        'Image background color.
 Const oak_PROP_IMAGETYPE = 5      'Result image format.
 Const oak_PROP_BITCOUNT = 6       'Color bits per pixel.
 Const oak_PROP_XDPI = 7           'Horizontal resolution.
 Const oak_PROP_YDPI = 8           'Vertical resolution.
 Const oak_PROP_QUALITY = 9        'JPEG compression quality.
 Const oak_PROP_COMPRESSION = 10   'TIFF compression mode.
 Const oak_PROP_MULTIPAGES = 11    'Multipages TIFF file.
 Const oak_PROP_GRAYSCALE = 12     'Grayscale image.
 Const oak_PROP_XDIMENSIONS = 13   'The width of the result image in pixel
 Const oak_PROP_YDIMENSIONS = 14   'The height of the result image in pixel
    
'read only properties
 Const oak_PROP_PAGECOUNT = 20     'The total pages of source pdf file.
 Const oak_PROP_PAGEHEIGHT = 21    'Height of the current page of source pdf file.
 Const oak_PROP_PAGEWIDTH = 22     'Width of the current page of source pdf file.
'==========================================================================================

'1.3 TIFF tag's definitions.
'==========================================================================================
 Const oak_TIFF_COMPRESSION_NONE = 0      'No compression.
 Const oak_TIFF_COMPRESSION_LZW = 1       '1,4,8,24bits(default 4,8,24bits)
 Const oak_TIFF_COMPRESSION_JPEG = 2      'Grayscale 8bits,24bits
 Const oak_TIFF_COMPRESSION_PACKBITS = 3  '4,8,24bits
 Const oak_TIFF_COMPRESSION_CCITTG4 = 4   '1bit(default 1bit)
 Const oak_TIFF_COMPRESSION_CCITTG3 = 5   '1bit
 Const oak_TIFF_COMPRESSION_RLE = 6       '1bit
'==========================================================================================


'1.4 Image type's definitions
'=======================================================================================
 Const oak_IMAGE_BMP = 1    'BMP
 Const oak_IMAGE_EMF = 2    'EMF
 Const oak_IMAGE_WMF = 3    'WMF
 Const oak_IMAGE_JPG = 4    'JPG
 Const oak_IMAGE_PNG = 5    'PNG
 Const oak_IMAGE_GIF = 6    'GIF
 Const oak_IMAGE_TIF = 7    'TIF
 Const oak_IMAGE_PCX = 8    'PCX
 Const oak_IMAGE_JPEG = 4   'JPEG
 Const oak_IMAGE_TIFF = 7   'TIFF
'=======================================================================================

'1.5 Return code's definitions.
'==========================================================================================
 Const RTN_OK = 1           'Successful operation.
 Const ERR_UNKNOWN = -99    'Unknown system error.
 Const ERR_OVER_MAXTHREADS = -1     'Over the limit amount of threads
 Const ERR_FILE_UNEXIST = -2        'Source PDF file unexist.
 Const ERR_FILE_DAMAGED = -3        'Source PDF file is damaged.
 Const ERR_FILE_RESTRICTED = -4     'Source PDF file is restricted.
'==========================================================================================


'1.6 Windows API definitions.
'==========================================================================================
 Private Const OFS_MAXPATHNAME = 128
 
 Private Type SECURITY_ATTRIBUTES
         nLength As Long
         lpSecurityDescriptor As Long
         bInheritHandle As Long
 End Type

 Private Declare Function GetTickCount Lib "kernel32" () As Long
 Private Declare Function MessageBox Lib "user32" Alias "MessageBoxA" (ByVal hwnd As Long, ByVal lpText As String, ByVal lpCaption As String, ByVal wType As Long) As Long
 Private Declare Function CreateDirectory Lib "kernel32" Alias "CreateDirectoryA" (ByVal lpPathName As String, lpSecurityAttributes As SECURITY_ATTRIBUTES) As Long
 Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)


'==========================================================================================


'Demo1 - Convert all pdf pages.
Private Sub btnDemo1_Click(Index As Integer)
   Dim nHandle As Long
   Dim iPageNo, iPageAmount As Long
   
   
   'Open pdf file and creating a converter.
   nHandle = oakBegin("oak.pdf", "", "")
   Select Case nHandle
     Case ERR_OVER_MAXTHREADS
       MessageBox this, "Over the limit amount of threads,please waiting!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_UNEXIST
       MessageBox this, "Source pdf file unexist!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_DAMAGED
       MessageBox this, "Source pdf file damaged!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_RESTRICTED
       MessageBox this, "Source pdf file restricted!", "Demo", MB_OK
       Exit Sub
   End Select
   
   'Setting the converter's propertys.
   'For more, please refer to above definitions.
   oakSetup nHandle, oak_PROP_OUTDIR, "./output1", 0, 0   'output directory
   oakSetup nHandle, oak_PROP_PREFIX, "myimg", 0, 0     'prefix of image file name

   oakSetup nHandle, oak_PROP_XDPI, "", 120, 0   'horizontal dpi
   oakSetup nHandle, oak_PROP_YDPI, "", 120, 0   'vertical dpi
   
   'Get the amount of the source pdf pages
   oakGetPageTotal nHandle, iPageAmount
   
   'To convert the pdf file.
   For iPageNo = 1 To iPageAmount
       oakExport nHandle, iPageNo
       
       'Setting conversion's progress.
       m_ProgressBar.Value = Round((iPageNo * 1#) / iPageAmount * 100)
   Next
   
   'Close pdf file and destory the converter.
   oakEnd (nHandle)
   
   MessageBox this, "Conversion successful.", "demo", MB_OK
End Sub

'Demo2 - Convert appointed pdf pages.
Private Sub btnDemo2_Click()
   Dim nHandle As Long
   Dim m_Pages
   m_Pages = Array(7, 7, 19, 15, 2, 0)
   
   
   'Open pdf file and creating a converter.
   nHandle = oakBegin("oak.pdf", "", "")
   Select Case nHandle
     Case ERR_OVER_MAXTHREADS
       MessageBox this, "Over the limit amount of threads,please waiting!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_UNEXIST
       MessageBox this, "Source pdf file unexist!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_DAMAGED
       MessageBox this, "Source pdf file damaged!", "Demo", MB_OK
       Exit Sub
     Case ERR_FILE_RESTRICTED
       MessageBox this, "Source pdf file restricted!", "Demo", MB_OK
       Exit Sub
   End Select
   
   'Setting the converter's propertys.
   'For more, please refer to above definitions.
   oakSetup nHandle, oak_PROP_OUTDIR, "./output2", 0, 0   'output directory

   oakSetup nHandle, oak_PROP_BITCOUNT, "", 24, 0  'color bits
   oakSetup nHandle, oak_PROP_XDPI, "", 120, 0   'horizontal dpi
   oakSetup nHandle, oak_PROP_YDPI, "", 120, 0   'vertical dpi
   oakSetup nHandle, oak_PROP_COMPRESSION, "", oak_TIFF_COMPRESSION_LZW, 0   'tiff compression mode
   oakSetup nHandle, oak_PROP_MULTIPAGES, "", True, 0    'vertical dpi
   
   'To convert the pdf file.
   iPageCount = UBound(m_Pages)
   For iPos = 0 To iPageCount - 1
       oakExport nHandle, m_Pages(iPos)
       
       'Setting conversion's progress.
       m_ProgressBar.Value = Round(((iPos + 1) * 1#) / iPageCount * 100)
   Next
   
   'Close pdf file and destory the converter.
   oakEnd (nHandle)
   

   MessageBox this, "Conversion successful.", "demo ", MB_OK
End Sub



