// pdf2tiff_demoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "pdf2image_demo.h"
#include "pdf2image_demoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPdf2image_demoDlg dialog

CPdf2image_demoDlg::CPdf2image_demoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPdf2image_demoDlg::IDD, pParent)
{
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPdf2image_demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPdf2image_demoDlg)
	DDX_Control(pDX, IDC_PROGRESS, m_Progress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPdf2image_demoDlg, CDialog)
	//{{AFX_MSG_MAP(CPdf2image_demoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_DEMO1, OnButtonDemo1)
	ON_BN_CLICKED(IDC_BUTTON_DEMO2, OnButtonDemo2)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPdf2image_demoDlg message handlers

BOOL CPdf2image_demoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_Progress.SetPos(0);
	m_Progress.Invalidate();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPdf2image_demoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPdf2image_demoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPdf2image_demoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//The progress's call-back function.
//To set conversion progress.
void GGetProgress(long nOther,long iProgress)
{
    CPdf2image_demoDlg *pThis = (CPdf2image_demoDlg *)nOther;
	pThis->m_Progress.SetPos(iProgress);
}

//Demo1 - Convert all the pdf pages.
void CPdf2image_demoDlg::OnButtonDemo1() 
{
	// TODO: Add your control notification handler code here
	char sPdfFile[] = "oak.pdf";
	long nHandle;

	//Loading dynamic link library---pdf2tiff.dll.
	if( LoadDLL() == FALSE ){
		MessageBox("Loading pdf2tiff.dll failure!","pdf2tiff",MB_OK);
		return;
	}


	//Open pdf file and creating a converter.
	nHandle = oakBegin(sPdfFile,NULL,NULL);
	switch( nHandle ){
	case ERR_OVER_MAXTHREADS: {
		MessageBox("Over the limit amount of threads,please waiting!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_UNEXIST: {
		MessageBox("Source pdf file unexist!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_DAMAGED: {
		MessageBox("Source pdf file damaged!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_RESTRICTED: {
		MessageBox("Source pdf file restricted!","demo",MB_OK);
		FreeDLL(); return;
	}}

	//Setting the converter's proerties.
	//For more,please refer to "oak_define.h".
	oakSetup(nHandle,oak_PROP_OUTDIR,"./output1",0,0);//output directory
	oakSetup(nHandle,oak_PROP_PREFIX,"myimg",0,0);//prefix of image file's name

	oakSetup(nHandle,oak_PROP_XDPI,NULL,120,0);//horizontal dpi
	oakSetup(nHandle,oak_PROP_YDPI,NULL,120,0);//vertical dpi

	//Setting the progress's call-back function.
	//The last parameter will be used to call-back function as a parameter value.
	oakSetup(nHandle,oak_PROP_PROGRESSFUNC,NULL,(long)GGetProgress,(long)this);

	//To convert the pdf file.
	oakExport(nHandle,0);

	//Close pdf file and destory the converter.
	oakEnd(nHandle);

	char sMessage[256];
	sprintf(sMessage,"Conversion successful!");
	MessageBox(sMessage,"demo",MB_OK);

	FreeDLL();
}

//Demo2 - Convert appointed pdf pages.
void CPdf2image_demoDlg::OnButtonDemo2() 
{
	// TODO: Add your control notification handler code here
	char sPdfFile[] = "oak.pdf";
	long m_Pages[] = {7,7,19,15,2};
	long nHandle;

	//Loading dynamic link library---pdf2tiff.dll.
	if( LoadDLL() == FALSE ){
		MessageBox("Loading pdf2tiff.dll failure!","pdf2tiff",MB_OK);
		return;
	}


	//Open pdf file and creating a converter.
	nHandle = oakBegin(sPdfFile,NULL,NULL);
	switch( nHandle ){
	case ERR_OVER_MAXTHREADS: {
		MessageBox("Over the limit amount of threads,please waiting!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_UNEXIST: {
		MessageBox("Source pdf file unexist!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_DAMAGED: {
		MessageBox("Source pdf file damaged!","demo",MB_OK);
		FreeDLL(); return;
	}
	case ERR_FILE_RESTRICTED: {
		MessageBox("Source pdf file restricted!","demo",MB_OK);
		FreeDLL(); return;
	}}

	//Setting the converter's proerties.
	//For more, please refer to "oak_define.h".
	oakSetup(nHandle,oak_PROP_OUTDIR,"./output2",0,0);//output directory

	oakSetup(nHandle,oak_PROP_BITCOUNT,NULL,24,0);//color bits per pixel
	oakSetup(nHandle,oak_PROP_XDPI,NULL,150,0);//horizontal dpi
	oakSetup(nHandle,oak_PROP_YDPI,NULL,150,0);//vertical dpi
	oakSetup(nHandle,oak_PROP_COMPRESSION,NULL,oak_TIFF_COMPRESSION_LZW,0);//tiff compression mode
	oakSetup(nHandle,oak_PROP_MULTIPAGES,NULL,TRUE,0);//multipages tiff

	//To convert the appointed pages of the pdf file.
	int iPageCount = sizeof(m_Pages)/sizeof(long);
	for(int iPos = 0; iPos < iPageCount; iPos++){
		oakExport(nHandle,m_Pages[iPos]);

		//Setting conversion's progress.
		m_Progress.SetPos((long)((iPos+1)*1.0/iPageCount*100));
	}

	//Close pdf file and destory the converter.
	oakEnd(nHandle);

	char sMessage[256];
	sprintf(sMessage,"Conversion successful!");
	MessageBox(sMessage,"demo",MB_OK);

	FreeDLL();
}



//Load dynamic link library---pdf2tiff.dll!
BOOL CPdf2image_demoDlg::LoadDLL(){
	char sDllFile[]="pdf2tiff.dll";

	m_hDll = LoadLibrary(sDllFile);
	if( m_hDll == NULL ) return FALSE;

	oakBegin = (_oakBegin *)GetProcAddress(m_hDll, "oakBegin");
	if( oakBegin == NULL ) goto ERR_FLAG;

	oakEnd = (_oakEnd *)GetProcAddress(m_hDll, "oakEnd");
	if( oakEnd == NULL ) goto ERR_FLAG;

	oakExport = (_oakExport *)GetProcAddress(m_hDll, "oakExport");
	if( oakExport == NULL ) goto ERR_FLAG;

	oakSetup = (_oakSetup *)GetProcAddress(m_hDll, "oakSetup");
	if( oakSetup == NULL ) goto ERR_FLAG;

	oakGetPageTotal = (_oakGetPageTotal *)GetProcAddress(m_hDll, "oakGetPageTotal");
	if( oakGetPageTotal == NULL ) goto ERR_FLAG;

	return TRUE;
ERR_FLAG:
	FreeDLL();
	return FALSE;
}

//Free dynamic link library---pdf2tiff.dll!
BOOL CPdf2image_demoDlg::FreeDLL(){
	if( m_hDll ){
        FreeLibrary(m_hDll);
        m_hDll = NULL;

		oakBegin = NULL;
		oakEnd = NULL;
		oakExport = NULL;
		oakSetup = NULL;
		oakGetPageTotal = NULL;
	}
	return TRUE;
}