
unit oak_define2;

interface
uses
  Windows;

const
//1.1 TIFF compression tag's definitions.
//==========================================================================================
    oak_TIFF_COMPRESSION_NONE     = 0;  //No compression.
    oak_TIFF_COMPRESSION_LZW      = 1;  //1,4,8,24bits(default 4,8,24bits)
    oak_TIFF_COMPRESSION_JPEG     = 2;  //Grayscale 8bits,24bits
    oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
    oak_TIFF_COMPRESSION_CCITTG4  = 4;  //1bit(default 1bit)
    oak_TIFF_COMPRESSION_CCITTG3  = 5;  //1bit
    oak_TIFF_COMPRESSION_RLE      = 6;  //1bit
//==========================================================================================

//1.2 Image type's definitions
//=======================================================================================
    oak_IMAGE_BMP  = 1;   //BMP
    oak_IMAGE_EMF  = 2;   //EMF
    oak_IMAGE_WMF  = 3;   //WMF
    oak_IMAGE_JPG  = 4;   //JPG
    oak_IMAGE_PNG  = 5;   //PNG
    oak_IMAGE_GIF  = 6;   //GIF
    oak_IMAGE_TIF  = 7;   //TIF
    oak_IMAGE_PCX  = 8;   //PCX
    
    oak_IMAGE_JPEG = 4;   //JPEG
    oak_IMAGE_TIFF = 7;   //TIFF
//=======================================================================================

//1.3 Return code definitions.
//==========================================================================================
    RTN_OK = 1;           //Successful operation.
    ERR_UNKNOWN = -99;    //Unknown system error.
    
    ERR_OVER_MAXTHREADS    = -1;  //Over the limit amount of threads
    ERR_FILE_UNEXIST       = -2;  //Source PDF file unexist.
    ERR_FILE_DAMAGED       = -3;  //Source PDF file is damaged.
    ERR_FILE_RESTRICTED    = -4;  //Source PDF file is restricted.
    
    ERR_INVALID_PAGE    = -5;   //The PDF page is invalid.
    ERR_CONVERT_FAILURE = -8;   //Conversion failure.
    ERR_INVALID_STREAM  = -9;   //Invalid memory stream address.
    ERR_INVALID_HANDLE  = -10;  //Invalid converter's handle.
//==========================================================================================

implementation

end.
