unit oak_define;

interface
uses
  Windows;

type
//1.1 SDK interface definitions.
//==========================================================================================
    _oakBegin = function(pFileName:PChar; pOwnerPw:PChar; pUserPw:PChar):Longint; stdcall;
    _oakEnd = function(nHandle:Longint):Longint; stdcall;
    _oakExport = function(nHandle:Longint; nPageNo:Longint):Longint; stdcall;
    _oakSetup = function(nHandle:Longint; //Conversion object's handle.
                               nIndex:Longint;  //Property tag,refer to the following property definitions.
                               pValue:PChar;    //A String value of the property,(or)
                               nValue:Longint;  //An integer value of the property.
                               nOther:Longint):Longint; stdcall; //Only valid for progress call-back.
    _oakGetPageTotal = function(nHandle:Longint; //Conversion object's handle.
                               var nValue:Longint):Longint; stdcall;  //An integer value of the property.
//==========================================================================================


const
//1.2 Definitions of converter's properties
//==========================================================================================
    //read/write properties
    oak_PROP_OUTDIR       = 1;  //Destination directory.
    oak_PROP_PREFIX       = 2;  //The prefix of the name of result image file.
    oak_PROP_PAGEZOOM     = 3;  //Zoom scale of the source pdf page.
    oak_PROP_BGCOLOR      = 4;  //Image background color.
    oak_PROP_IMAGETYPE    = 5;  //Result image format.
    oak_PROP_BITCOUNT     = 6;  //Color bits per pixel.
    oak_PROP_XDPI         = 7;  //Horizontal resolution.
    oak_PROP_YDPI         = 8;  //Vertical resolution.
    oak_PROP_QUALITY      = 9;  //JPEG compression quality.
    oak_PROP_COMPRESSION  = 10; //TIFF compression mode.
    oak_PROP_MULTIPAGES   = 11; //Multipages TIFF file.
    oak_PROP_GRAYSCALE    = 12; //Grayscale image.
    oak_PROP_XDIMENSIONS  = 13; //The width of the result image in pixel
    oak_PROP_YDIMENSIONS  = 14; //The height of the result image in pixel
    
    //read only properties
    oak_PROP_PAGECOUNT  = 20; //The total pages of source pdf file.
    oak_PROP_PAGEHEIGHT = 21; //Height of the current page of source pdf file.
    oak_PROP_PAGEWIDTH  = 22; //Width of the current page of source pdf file.

    //write only properties
    oak_PROP_PROGRESSFUNC = 40; //Address of the progress call-back function.
//==========================================================================================

//1.3 TIFF tag's definitions.
//==========================================================================================
    oak_TIFF_COMPRESSION_NONE     = 0;  //No compression.
    oak_TIFF_COMPRESSION_LZW      = 1;  //1,4,8,24bits(default 4,8,24bits)
    oak_TIFF_COMPRESSION_JPEG     = 2;  //Grayscale 8bits,24bits
    oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
    oak_TIFF_COMPRESSION_CCITTG4  = 4;  //1bit(default 1bit)
    oak_TIFF_COMPRESSION_CCITTG3  = 5;  //1bit
    oak_TIFF_COMPRESSION_RLE      = 6;  //1bit
//==========================================================================================

//1.4 Image type's definitions
//=======================================================================================
    oak_IMAGE_BMP  = 1;   //BMP
    oak_IMAGE_EMF  = 2;   //EMF
    oak_IMAGE_WMF  = 3;   //WMF
    oak_IMAGE_JPG  = 4;   //JPG
    oak_IMAGE_PNG  = 5;   //PNG
    oak_IMAGE_GIF  = 6;   //GIF
    oak_IMAGE_TIF  = 7;   //TIF
    oak_IMAGE_PCX  = 8;   //PCX
    
    oak_IMAGE_JPEG = 4;   //JPEG
    oak_IMAGE_TIFF = 7;   //TIFF
//=======================================================================================

//1.5 Return code definitions.
//==========================================================================================
    RTN_OK = 1;           //Successful operation.
    ERR_UNKNOWN = -99;    //Unknown system error.
    
    ERR_OVER_MAXTHREADS    = -1;  //Over the limit amount of threads
    ERR_FILE_UNEXIST       = -2;  //Source PDF file unexist.
    ERR_FILE_DAMAGED       = -3;  //Source PDF file is damaged.
    ERR_FILE_RESTRICTED    = -4;  //Source PDF file is restricted.
    
    ERR_INVALID_PAGE    = -5;   //The PDF page is invalid.
    ERR_CONVERT_FAILURE = -8;   //Conversion failure.
    ERR_INVALID_STREAM  = -9;   //Invalid memory stream address.
    ERR_INVALID_HANDLE  = -10;  //Invalid converter's handle.
//==========================================================================================

implementation

end.
