/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.dialogs;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import ooslideshow.OOSlideshowApp;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class ExportSlideshowDialog
extends JDialog {
    private File target;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public ExportSlideshowDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initialize();
    }

    public void initialize() {
        this.target = null;
        JFileChooser fc = new JFileChooser();
        File defaultDir = fc.getCurrentDirectory();
        this.jTextField1.setText(defaultDir.getAbsolutePath());
        this.centerWindowOnScreen();
    }

    public void centerWindowOnScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.requestFocus();
    }

    public void selectDir() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int rv = fc.showOpenDialog(this);
        if (rv == 0) {
            this.jTextField1.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void okAction() {
        String dir = this.jTextField1.getText();
        String name = this.jTextField2.getText();
        if (dir == null || dir.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Invalid output directory", "Error", 0);
            return;
        }
        if (name == null || name.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Invalid slideshow name", "Error", 0);
            return;
        }
        File output = new File(dir + File.separator + name);
        if (!output.exists()) {
            output.mkdirs();
            this.target = new File(output + File.separator + name);
            this.setVisible(false);
            return;
        }
        if (output.isDirectory()) {
            int answer = JOptionPane.showConfirmDialog(this, "The directory\n" + output.getAbsolutePath() + "\n already exists!\nWould you like to proceed (some of its contents may be overwritten) ?", "Directory exists!", 0);
            if (answer != 0) return;
            this.target = new File(output + File.separator + name);
            this.setVisible(false);
            return;
        }
        JOptionPane.showMessageDialog(this, "A file named\n" + output.getAbsolutePath() + "\n already exists! Please select another name or directory.", "Error", 0);
    }

    public File showExportDialog() {
        this.setVisible(true);
        return this.target;
    }

    public void cancelAction() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setName("Form");
        this.setResizable(false);
        ResourceMap resourceMap = Application.getInstance(OOSlideshowApp.class).getContext().getResourceMap(ExportSlideshowDialog.class);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jTextField1.setName("jTextField1");
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportSlideshowDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jTextField2.setText(resourceMap.getString("jTextField2.text", new Object[0]));
        this.jTextField2.setName("jTextField2");
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportSlideshowDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportSlideshowDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jSeparator1.setName("jSeparator1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jTextField1, -1, 394, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 25, -2)).addComponent(this.jLabel1).addComponent(this.jLabel2))).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jTextField2, -1, 425, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 437, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(310, Short.MAX_VALUE).addComponent(this.jButton3, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 66, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.selectDir();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.cancelAction();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.okAction();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ExportSlideshowDialog dialog = new ExportSlideshowDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

