/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.imageutils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ResizeImage {
    public ImageIcon scaleImage(BufferedImage source, int size, Color bgColor) {
        BufferedImage resized = this.resize(source, size, RenderingHints.VALUE_INTERPOLATION_BICUBIC, bgColor);
        return new ImageIcon(resized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage resize(BufferedImage source, int destSize, Object interpolation, Color bgColor) {
        double xScale;
        if (source == null) {
            throw new NullPointerException("source image is null!!!");
        }
        if (destSize <= 0) {
            throw new IllegalArgumentException("invalid destination dimensions!!!");
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        double yScale = 1.0;
        if (sourceWidth >= sourceHeight) {
            yScale = xScale = (double)destSize / (double)sourceWidth;
        } else {
            xScale = yScale = (double)destSize / (double)sourceHeight;
        }
        int w = (int)(xScale * (double)sourceWidth);
        int h = (int)(yScale * (double)sourceHeight);
        GraphicsConfiguration gc = this.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(destSize, destSize, source.getColorModel().getTransparency());
        Graphics2D g2d = null;
        try {
            g2d = result.createGraphics();
            g2d.setBackground(bgColor);
            g2d.clearRect(0, 0, destSize, destSize);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
            AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
            g2d.translate((destSize - w) / 2, (destSize - h) / 2);
            g2d.drawRenderedImage(source, at);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return result;
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }
}

