/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.presets;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import ooslideshow.presets.OutputPreset;

public class OutputPresetManager {
    private Vector<OutputPreset> presets = new Vector();

    public void addPreset(OutputPreset newPreset) {
        this.presets.add(newPreset);
    }

    public void addPreset(String Title, String OutputExtension, String VideoCodec, String AudioCodec, String VideoCodecCommand, String AudioCodecCommand) {
        OutputPreset newPreset = new OutputPreset(Title, OutputExtension, VideoCodec, AudioCodec, VideoCodecCommand, AudioCodecCommand);
        this.presets.add(newPreset);
    }

    public OutputPreset[] getPresets() {
        OutputPreset[] result = new OutputPreset[this.presets.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.presets.get(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePresetsToXMLFile(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            XMLEncoder xenc = new XMLEncoder(fos);
            try {
                for (int i = 0; i < this.presets.size(); ++i) {
                    OutputPreset p = this.presets.get(i);
                    xenc.writeObject(p);
                    xenc.flush();
                }
            }
            finally {
                xenc.flush();
                xenc.close();
            }
            fos.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPresetsFromXMLFile(URL url) {
        try {
            InputStream fis = url.openStream();
            XMLDecoder xdec = new XMLDecoder(fis);
            try {
                while (true) {
                    OutputPreset p = (OutputPreset)xdec.readObject();
                    this.presets.add(p);
                }
            }
            catch (ArrayIndexOutOfBoundsException aiooe) {
                xdec.close();
            }
            catch (Exception e) {
                try {
                    System.err.println(e.toString());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    xdec.close();
                }
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPresetsFromXMLFile(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            XMLDecoder xdec = new XMLDecoder(fis);
            try {
                while (true) {
                    OutputPreset p = (OutputPreset)xdec.readObject();
                    this.presets.add(p);
                }
            }
            catch (ArrayIndexOutOfBoundsException aiooe) {
                xdec.close();
            }
            catch (Exception e) {
                try {
                    System.err.println(e.toString());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    xdec.close();
                }
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void main(String[] args) {
        OutputPresetManager opm = new OutputPresetManager();
        opm.addPreset("MPEG-4", "mp4", "mpeg4", "MPEG-1 audio layer 3 (MP3)", "-ovc lavc -lavcopts vcodec=mpeg4:mbd=2:trell", "-oac mp3lame -lameopts cbr:br=128");
        opm.addPreset("Flash Video", "flv", "Sorenson H.263 ", "MPEG-1 audio layer 3 (MP3)", "-ovc lavc -lavcopts vcodec=flv:mbd=2:trell", "-oac mp3lame -lameopts cbr:br=128");
        try {
            URL appDir = ClassLoader.getSystemResource("ooslideshow/resources");
            String s = appDir.getFile() + File.separator + "outputPresets.xml";
            String outputPath = URLDecoder.decode(s, "UTF-8");
            opm.savePresetsToXMLFile(outputPath);
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee.toString());
        }
    }
}

