/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.presets;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import ooslideshow.presets.SizePreset;

public class SizePresetManager {
    private Vector<SizePreset> presets = new Vector();

    public void addPreset(int width, int height, String title) {
        SizePreset newPreset = new SizePreset(width, height, title);
        this.presets.add(newPreset);
    }

    public SizePreset[] getPresets() {
        SizePreset[] result = new SizePreset[this.presets.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.presets.get(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePresetsToXMLFile(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            XMLEncoder xenc = new XMLEncoder(fos);
            try {
                for (int i = 0; i < this.presets.size(); ++i) {
                    SizePreset p = this.presets.get(i);
                    xenc.writeObject(p);
                    xenc.flush();
                }
            }
            finally {
                xenc.flush();
                xenc.close();
            }
            fos.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPresetsFromXMLFile(URL url) {
        try {
            InputStream fis = url.openStream();
            XMLDecoder xdec = new XMLDecoder(fis);
            try {
                while (true) {
                    SizePreset p = (SizePreset)xdec.readObject();
                    this.presets.add(p);
                }
            }
            catch (ArrayIndexOutOfBoundsException aiooe) {
                xdec.close();
            }
            catch (Exception e) {
                try {
                    System.err.println(e.toString());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    xdec.close();
                }
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPresetsFromXMLFile(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            XMLDecoder xdec = new XMLDecoder(fis);
            try {
                while (true) {
                    SizePreset p = (SizePreset)xdec.readObject();
                    this.presets.add(p);
                }
            }
            catch (ArrayIndexOutOfBoundsException aiooe) {
                xdec.close();
            }
            catch (Exception e) {
                try {
                    System.err.println(e.toString());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    xdec.close();
                }
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void main(String[] args) {
        SizePresetManager spm = new SizePresetManager();
        spm.addPreset(-1, -1, "Custom");
        spm.addPreset(320, 240, "320x240");
        spm.addPreset(640, 480, "640x480");
        spm.addPreset(800, 600, "800x600");
        spm.addPreset(320, 240, "Youtube(4:3)");
        try {
            URL appDir = ClassLoader.getSystemResource("ooslideshow/resources");
            String s = appDir.getFile() + File.separator + "presets.xml";
            String outputPath = URLDecoder.decode(s, "UTF-8");
            spm.savePresetsToXMLFile(outputPath);
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee.toString());
        }
    }
}

