/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slidegenerator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageResizer {
    public String resizeImage(String Filename, String outputDir, String outputName, int targetWidth, int targetHeight, resizePolicy ResizePolicy, Color bgColor) {
        File outputDirectory = new File(outputDir);
        File original = new File(Filename);
        if (!outputDirectory.isDirectory()) {
            return null;
        }
        String outputFilename = outputDir + File.separator + outputName + ".jpg";
        BufferedImage src = null;
        try {
            src = ImageIO.read(original);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
        if (src == null) {
            return null;
        }
        BufferedImage output = null;
        output = ResizePolicy == resizePolicy.SCALE ? this.scaleImage(src, targetWidth, targetHeight, bgColor) : (ResizePolicy == resizePolicy.STRETCH ? this.stretchImage(src, targetWidth, targetHeight, bgColor) : this.centerCropImage(src, targetWidth, targetHeight, bgColor));
        try {
            ImageIO.write((RenderedImage)output, "jpg", new File(outputFilename));
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
        return outputFilename;
    }

    private String stripExtension(String src) {
        int index = src.lastIndexOf(".");
        if (index > 0) {
            return src.substring(0, index);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage scaleImage(BufferedImage source, int destWidth, int destHeight, Color bgColor) {
        double xScale;
        if (source == null) {
            throw new NullPointerException("source image is null!!!");
        }
        if (destWidth <= 0 && destHeight <= 0) {
            throw new IllegalArgumentException("invalid destination dimensions!!!");
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        double yScale = 1.0;
        if (sourceWidth >= sourceHeight) {
            yScale = xScale = (double)destWidth / (double)sourceWidth;
        } else {
            xScale = yScale = (double)destHeight / (double)sourceHeight;
        }
        int w = (int)(xScale * (double)sourceWidth);
        int h = (int)(yScale * (double)sourceHeight);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage result = new BufferedImage(destWidth, destHeight, 1);
        Graphics2D g2d = null;
        try {
            g2d = result.createGraphics();
            g2d.setBackground(bgColor);
            g2d.clearRect(0, 0, destWidth, destHeight);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
            g2d.translate((destWidth - w) / 2, (destHeight - h) / 2);
            g2d.drawRenderedImage(source, at);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage stretchImage(BufferedImage source, int destWidth, int destHeight, Color bgColor) {
        if (source == null) {
            throw new NullPointerException("source image is null!!!");
        }
        if (destWidth <= 0 && destHeight <= 0) {
            throw new IllegalArgumentException("invalid destination dimensions!!!");
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        double yScale = 1.0;
        double xScale = (double)destWidth / (double)sourceWidth;
        yScale = (double)destHeight / (double)sourceHeight;
        int w = (int)(xScale * (double)sourceWidth);
        int h = (int)(yScale * (double)sourceHeight);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage result = new BufferedImage(destWidth, destHeight, 1);
        Graphics2D g2d = null;
        try {
            g2d = result.createGraphics();
            g2d.setBackground(bgColor);
            g2d.clearRect(0, 0, destWidth, destHeight);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
            g2d.translate((destWidth - w) / 2, (destHeight - h) / 2);
            g2d.drawRenderedImage(source, at);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage centerCropImage(BufferedImage source, int destWidth, int destHeight, Color bgColor) {
        if (source == null) {
            throw new NullPointerException("source image is null!!!");
        }
        if (destWidth <= 0 && destHeight <= 0) {
            throw new IllegalArgumentException("invalid destination dimensions!!!");
        }
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        BufferedImage result = new BufferedImage(destWidth, destHeight, 1);
        Graphics2D g2d = null;
        try {
            g2d = result.createGraphics();
            g2d.setBackground(bgColor);
            g2d.clearRect(0, 0, destWidth, destHeight);
            int newX = (destWidth - sourceWidth) / 2;
            int newY = (destHeight - sourceHeight) / 2;
            g2d.translate(newX, newY);
            g2d.drawRenderedImage(source, null);
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum resizePolicy {
        CENTER_CROP,
        SCALE,
        STRETCH;

    }
}

