/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slidegenerator;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import ooslideshow.fileutils.Copier;
import ooslideshow.presets.OutputPreset;
import ooslideshow.slidegenerator.ImageResizer;
import ooslideshow.slidegenerator.TransitionGenerator;
import ooslideshow.slideshow.SlideShowItem;

public class SlideGenerator
extends Thread {
    private SlideShowItem[] slides;
    private int outputWidth;
    private int outputHeight;
    private float defaultDuration;
    private SlideShowItem.resizePolicy defaultResizePolicy;
    private SlideShowItem.transition defaultTransition;
    private Color defaultBgColor;
    private boolean useAudio;
    private String audioFilename;
    private OutputPreset outputOptions;
    private Vector<String> framesList;
    Vector<String> tmpFilesList;
    String outputDir;
    String outputName;

    public SlideGenerator(SlideShowItem[] slides, int outputWidth, int outputHeight, float defaultDuration, SlideShowItem.resizePolicy defaultResizePolicy, SlideShowItem.transition defaultTransition, Color defaultBgColor, boolean useAudio, String audioFilename, OutputPreset outputOptions, String outputDir, String outputName) {
        this.slides = slides;
        this.outputWidth = outputWidth;
        this.outputHeight = outputHeight;
        this.defaultDuration = defaultDuration;
        this.defaultResizePolicy = defaultResizePolicy;
        this.defaultTransition = defaultTransition;
        this.defaultBgColor = defaultBgColor;
        this.useAudio = useAudio;
        this.audioFilename = audioFilename;
        this.outputOptions = outputOptions;
        this.framesList = new Vector();
        this.tmpFilesList = new Vector();
        this.outputDir = outputDir;
        this.outputName = outputName;
    }

    public void run() {
        this.tmpFilesList.clear();
        int numOfDigitsInName = (int)Math.floor(Math.log10(this.slides.length)) + 1;
        TransitionGenerator trGen = new TransitionGenerator();
        this.framesList.clear();
        File dir = new File(this.outputDir);
        if (!dir.isDirectory()) {
            return;
        }
        ImageResizer ir = new ImageResizer();
        String fname = "";
        for (int i = 0; i < this.slides.length; ++i) {
            String message = String.format("Creating slide " + String.valueOf(i + 1), new Object[0]);
            float slideDuration = this.slides[i].getDuration();
            Color slideBgColor = this.slides[i].getBgColor();
            SlideShowItem.resizePolicy tmpResizePolicy = this.slides[i].getResizePolicy();
            SlideShowItem.transition slideTransition = this.slides[i].getTransitionType();
            if (slideDuration == -1.0f) {
                slideDuration = this.defaultDuration;
            }
            if (slideBgColor == null) {
                slideBgColor = this.defaultBgColor;
            }
            ImageResizer.resizePolicy slideResizePolicy = tmpResizePolicy == SlideShowItem.resizePolicy.DEFAULT ? this.slideshowItemResizePolicyToImageResizerResizePolicy(this.defaultResizePolicy) : this.slideshowItemResizePolicyToImageResizerResizePolicy(tmpResizePolicy);
            if (slideTransition == SlideShowItem.transition.DEFAULT) {
                slideTransition = this.defaultTransition;
            }
            fname = ir.resizeImage(this.slides[i].getFilename(), this.outputDir, this.getFrameName(numOfDigitsInName, i), this.outputWidth, this.outputHeight, slideResizePolicy, slideBgColor);
            if (slideTransition != SlideShowItem.transition.NONE) {
                String previousImgFilename = null;
                Color previousSlideBgColor = this.defaultBgColor;
                if (i > 0) {
                    previousImgFilename = this.framesList.lastElement();
                    previousSlideBgColor = this.slides[i - 1].getBgColor();
                    if (previousSlideBgColor == null) {
                        previousSlideBgColor = this.defaultBgColor;
                    }
                }
                String transitionName = "transition_";
                transitionName = i > 0 ? transitionName + this.getFrameSuffix(numOfDigitsInName, i - 1) + "-" + this.getFrameSuffix(numOfDigitsInName, i) + "_" : transitionName + "start" + "-" + this.getFrameSuffix(numOfDigitsInName, i) + "_";
                String[] transition2 = trGen.generateTransition(slideTransition, this.outputWidth, this.outputHeight, previousImgFilename, previousSlideBgColor, fname, slideBgColor, this.outputDir, transitionName);
                this.addTransitionToList(transition2);
            }
            this.addFrameToList(fname, slideDuration);
        }
        String inputListFile = this.saveFramesListToTextFile(this.outputDir, this.outputName);
        this.tmpFilesList.add(this.outputDir + File.separator + this.outputName + ".txt");
        Copier cp = new Copier();
        File audioSrc = new File(this.audioFilename);
        String target = this.outputDir + File.separator + this.outputName + ".audio";
        try {
            cp.copy(audioSrc, new File(target));
            this.tmpFilesList.add(target);
        }
        catch (IOException ioe) {
            System.err.println("Error while copying audio file");
            this.useAudio = false;
        }
        this.executeMencoder(inputListFile, dir, this.outputName);
        this.cleanupTemporaryFiles();
    }

    private void cleanupTemporaryFiles() {
        for (int i = 0; i < this.tmpFilesList.size(); ++i) {
            File tmp = new File(this.tmpFilesList.get(i));
            if (!tmp.isFile()) continue;
            tmp.delete();
        }
    }

    private String saveFramesListToTextFile(String outputDir, String outputName) {
        try {
            File out = new File(outputDir + File.separator + outputName + ".txt");
            FileWriter fw = new FileWriter(out, false);
            for (int i = 0; i < this.framesList.size(); ++i) {
                fw.write(this.framesList.get(i) + "\n");
            }
            fw.flush();
            fw.close();
            return out.getName();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return "";
        }
    }

    private void executeMencoder(String inputFile, File outputDir, String outputName) {
        String command = "mencoder mf://@" + inputFile + " -mf w=" + this.outputWidth + ":h=" + this.outputHeight + ":fps=10:type=jpg ";
        command = this.useAudio ? command + "-audiofile " + outputName + ".audio " + this.outputOptions.getCommand() : command + this.outputOptions.getCommandNoAudio();
        command = command + " -o " + outputName + "." + this.outputOptions.getOutputExtension();
        Runtime rt = Runtime.getRuntime();
        try {
            Process p = rt.exec(command, null, outputDir);
            String line = "";
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (line != null) {
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private ImageResizer.resizePolicy slideshowItemResizePolicyToImageResizerResizePolicy(SlideShowItem.resizePolicy src) {
        if (src == SlideShowItem.resizePolicy.SCALE) {
            return ImageResizer.resizePolicy.SCALE;
        }
        if (src == SlideShowItem.resizePolicy.STRETCH) {
            return ImageResizer.resizePolicy.STRETCH;
        }
        return ImageResizer.resizePolicy.CENTER_CROP;
    }

    private String getFrameName(int numOfDigits, int frameNumber) {
        String name = this.getFrameSuffix(numOfDigits, frameNumber);
        return "frame_" + name;
    }

    private String getFrameSuffix(int numOfDigits, int frameNumber) {
        String suffix = String.valueOf(frameNumber);
        int max = numOfDigits - suffix.length();
        for (int i = 0; i < max; ++i) {
            suffix = "0" + suffix;
        }
        return suffix;
    }

    private void addFrameToList(String frameFilename, float frameDuration) {
        if (frameFilename == null) {
            return;
        }
        int max = (int)Math.floor(frameDuration * 10.0f);
        for (int i = 0; i < max; ++i) {
            this.framesList.add(frameFilename);
        }
        this.tmpFilesList.add(frameFilename);
    }

    private void addTransitionToList(String[] frameFilenames) {
        for (int i = 0; i < frameFilenames.length; ++i) {
            this.framesList.add(frameFilenames[i]);
            this.tmpFilesList.add(frameFilenames[i]);
        }
    }
}

