/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slidegenerator;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ooslideshow.slidegenerator.transitions.Crossfade;
import ooslideshow.slidegenerator.transitions.Wipe;
import ooslideshow.slideshow.SlideShowItem;

public class TransitionGenerator {
    public String[] generateTransition(SlideShowItem.transition transitionType, int width, int height, String image1, Color bg1, String image2, Color bg2, String outputPath, String filename) {
        File f2;
        File f1;
        BufferedImage img1 = null;
        BufferedImage img2 = null;
        if (image1 != null && (f1 = new File(image1)).isFile()) {
            try {
                img1 = ImageIO.read(f1);
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
                img1 = null;
            }
        }
        if (image2 != null && (f2 = new File(image2)).isFile()) {
            try {
                img2 = ImageIO.read(f2);
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
                img2 = null;
            }
        }
        if (transitionType == SlideShowItem.transition.CROSSFADE) {
            return new Crossfade().generateFrames(width, height, img1, bg1, img2, bg2, outputPath, filename);
        }
        if (transitionType == SlideShowItem.transition.WIPE) {
            return new Wipe().generateFrames(width, height, img1, bg1, img2, bg2, outputPath, filename);
        }
        return null;
    }
}

