/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slidegenerator.transitions;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ooslideshow.slidegenerator.transitions.Transition;

public class Crossfade
implements Transition {
    public String[] generateFrames(int width, int height, BufferedImage img1, Color bg1, BufferedImage img2, Color bg2, String outputPath, String fname) {
        Graphics2D g2d;
        if (img1 == null) {
            img1 = new BufferedImage(width, height, 2);
            g2d = img1.createGraphics();
            g2d.setPaint(bg1);
            g2d.fillRect(0, 0, width, height);
            g2d.dispose();
        }
        if (img2 == null) {
            img2 = new BufferedImage(width, height, 2);
            g2d = img2.createGraphics();
            g2d.setPaint(bg2);
            g2d.fillRect(0, 0, width, height);
            g2d.dispose();
        }
        String[] result = new String[10];
        int j = 0;
        for (double i = 0.9; i > 0.0; i -= 0.1) {
            BufferedImage frame = this.blend(width, height, img1, img2, i);
            try {
                ImageIO.write((RenderedImage)frame, "jpg", new File(outputPath + File.separator + fname + String.valueOf(j) + ".jpg"));
                result[j] = outputPath + File.separator + fname + String.valueOf(j) + ".jpg";
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
            }
            ++j;
        }
        return result;
    }

    private BufferedImage blend(int width, int height, BufferedImage imgA, BufferedImage imgB, double weight) {
        BufferedImage bi3 = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi3.createGraphics();
        g2d.drawImage(imgA, null, 0, 0);
        g2d.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - weight)));
        g2d.drawImage(imgB, null, 0, 0);
        g2d.dispose();
        return bi3;
    }
}

