/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slidegenerator.transitions;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ooslideshow.slidegenerator.transitions.Transition;

public class Wipe
implements Transition {
    public String[] generateFrames(int width, int height, BufferedImage img1, Color bg1, BufferedImage img2, Color bg2, String outputPath, String fname) {
        Graphics2D g2d;
        if (img1 == null) {
            img1 = new BufferedImage(width, height, 2);
            g2d = img1.createGraphics();
            g2d.setPaint(bg1);
            g2d.fillRect(0, 0, width, height);
            g2d.dispose();
        }
        if (img2 == null) {
            img2 = new BufferedImage(width, height, 2);
            g2d = img2.createGraphics();
            g2d.setPaint(bg2);
            g2d.fillRect(0, 0, width, height);
            g2d.dispose();
        }
        int offset = width / 10;
        String[] result = new String[10];
        for (int i = 0; i < 10; ++i) {
            BufferedImage frame = this.getFrame(width, height, img1, img2, offset * i);
            try {
                ImageIO.write((RenderedImage)frame, "jpg", new File(outputPath + File.separator + fname + String.valueOf(i) + ".jpg"));
                result[i] = outputPath + File.separator + fname + String.valueOf(i) + ".jpg";
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
            }
        }
        return result;
    }

    public BufferedImage getFrame(int width, int height, BufferedImage img1, BufferedImage img2, int xOffset) {
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D g2d = result.createGraphics();
        g2d.drawRenderedImage(img2, null);
        g2d.translate(xOffset, 0);
        g2d.drawRenderedImage(img1, null);
        g2d.dispose();
        return result;
    }
}

