/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slideshow;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import ooslideshow.imageutils.ResizeImage;

public class SlideShowItem {
    public static final float defaultDisplayTimeFlag = -1.0f;
    public static final int defaultTransitionTimeFlag = -1;
    private String filename;
    private String filetype;
    private String path;
    private String name;
    private ImageIcon image;
    private int width;
    private int height;
    private transition transitionType;
    private resizePolicy resizeType;
    private float duration;
    private int transitionDuration;
    private Color bgColor;

    public SlideShowItem(String Filename) {
        this.filename = Filename;
        File f = new File(this.filename);
        this.name = f.getName();
        this.name = this.name.substring(0, this.name.lastIndexOf(46));
        this.filetype = f.toString().substring(this.filename.lastIndexOf(46) + 1, this.filename.length());
        this.path = f.getAbsolutePath();
        this.resizeType = resizePolicy.DEFAULT;
        this.transitionType = transition.DEFAULT;
        this.transitionDuration = -1;
        this.duration = -1.0f;
        this.bgColor = null;
        this.setImage(this.filename);
    }

    public String getFilename() {
        return new String(this.filename);
    }

    public String getName() {
        return new String(this.name);
    }

    public String getFiletype() {
        return new String(this.filetype);
    }

    public String getPath() {
        return new String(this.path);
    }

    public ImageIcon getIcon() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public transition getTransitionType() {
        return this.transitionType;
    }

    public resizePolicy getResizePolicy() {
        return this.resizeType;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getTransitionDuration() {
        return this.transitionDuration;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public String getTransitionTypeAsString() {
        if (this.transitionType == transition.DEFAULT) {
            return "default";
        }
        if (this.transitionType == transition.CROSSFADE) {
            return "crossfade";
        }
        if (this.transitionType == transition.WIPE) {
            return "wipe";
        }
        return "none";
    }

    public String getResizePolicyAsString() {
        if (this.resizeType == resizePolicy.DEFAULT) {
            return "default";
        }
        if (this.resizeType == resizePolicy.CROP) {
            return "Crop";
        }
        if (this.resizeType == resizePolicy.SCALE) {
            return "scale";
        }
        return "stretch";
    }

    public String getDurationAsString() {
        if ((double)this.duration == -1.0) {
            return "default";
        }
        return String.valueOf(this.duration);
    }

    public String getTransitionDurationAsString() {
        if (this.transitionDuration == -1) {
            return "default";
        }
        return String.valueOf(this.transitionDuration);
    }

    public String getBgColorAsString() {
        if (this.bgColor == null) {
            return "default";
        }
        return this.colorToHex(this.bgColor);
    }

    public void setTransitionType(transition newTransitionType) {
        this.transitionType = newTransitionType;
    }

    public void setResizePolicy(resizePolicy newResizePolicy) {
        this.resizeType = newResizePolicy;
    }

    public void setDuration(float newDisplayTime) {
        this.duration = newDisplayTime;
    }

    public void setTransitionDuration(int newTransitionDisplayTime) {
        this.transitionDuration = newTransitionDisplayTime;
    }

    public void setBgColor(Color newBgColor) {
        this.bgColor = newBgColor;
    }

    public void setImage(String filename) {
        File f;
        this.width = 0;
        this.height = 0;
        if (filename != null && (f = new File(filename)).exists()) {
            BufferedImage src = null;
            try {
                src = ImageIO.read(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (src != null) {
                this.width = src.getWidth();
                this.height = src.getHeight();
                this.image = new ResizeImage().scaleImage(src, 100, new Color(245, 245, 245));
            }
        }
    }

    public String colorToHex(Color c) {
        String r = Integer.toHexString(c.getRed());
        String g = Integer.toHexString(c.getGreen());
        String b = Integer.toHexString(c.getBlue());
        if (r.length() < 2) {
            r = '0' + r;
        }
        if (g.length() < 2) {
            g = '0' + g;
        }
        if (b.length() < 2) {
            b = '0' + b;
        }
        return '#' + r + g + b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum resizePolicy {
        DEFAULT,
        CROP,
        SCALE,
        STRETCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum transition {
        DEFAULT,
        CROSSFADE,
        WIPE,
        NONE;

    }
}

