/*
 * Decompiled with CFR 0.152.
 */
package ooslideshow.slideshow;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ooslideshow.OOSlideshowApp;
import ooslideshow.OOSlideshowView;
import ooslideshow.customcontrols.ColorBox;
import ooslideshow.slideshow.SlideShowItem;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SlideShowItemPropertiesForm
extends JDialog {
    private SlideShowItem[] items;
    private JList list;
    private OOSlideshowView parent;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ColorBox colorBox1;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JComboBox jComboBox4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSpinner jSpinner1;

    public SlideShowItemPropertiesForm(OOSlideshowView parent, boolean modal, SlideShowItem[] Items, JList List2) {
        super((Frame)parent.getFrame(), modal);
        this.initComponents();
        this.centerWindowOnScreen();
        this.items = Items;
        this.list = List2;
        this.parent = parent;
        this.initialize();
    }

    public void initialize() {
        this.initValues();
    }

    public void initValues() {
        if (this.items == null || this.items.length == 0) {
            return;
        }
        if (this.items.length == 1) {
            this.setValues(this.items[0].getDuration(), this.items[0].getTransitionType(), this.items[0].getTransitionDuration(), this.items[0].getResizePolicy(), this.items[0].getBgColor());
        } else {
            this.setToNoChange();
        }
    }

    public void setToNoChange() {
        this.jComboBox1.setSelectedIndex(0);
        this.jComboBox2.setSelectedIndex(0);
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox4.setSelectedIndex(0);
    }

    public void setValues(float duration, SlideShowItem.transition transition2, int transitionDuration, SlideShowItem.resizePolicy resizePolicy2, Color bgColor) {
        if (duration == -1.0f) {
            this.jComboBox1.setSelectedIndex(1);
        } else {
            this.jComboBox1.setSelectedIndex(2);
            this.jSpinner1.getModel().setValue(new Float(duration));
        }
        if (transition2 == SlideShowItem.transition.DEFAULT) {
            this.jComboBox2.setSelectedIndex(1);
        } else if (transition2 == SlideShowItem.transition.CROSSFADE) {
            this.jComboBox2.setSelectedIndex(2);
        } else if (transition2 == SlideShowItem.transition.WIPE) {
            this.jComboBox2.setSelectedIndex(3);
        } else {
            this.jComboBox2.setSelectedIndex(4);
        }
        if (resizePolicy2 == SlideShowItem.resizePolicy.DEFAULT) {
            this.jComboBox3.setSelectedIndex(1);
        } else if (resizePolicy2 == SlideShowItem.resizePolicy.CROP) {
            this.jComboBox3.setSelectedIndex(2);
        } else if (resizePolicy2 == SlideShowItem.resizePolicy.SCALE) {
            this.jComboBox3.setSelectedIndex(3);
        } else if (resizePolicy2 == SlideShowItem.resizePolicy.STRETCH) {
            this.jComboBox3.setSelectedIndex(4);
        }
        if (bgColor == null) {
            this.jComboBox4.setSelectedIndex(1);
        } else {
            this.jComboBox4.setSelectedIndex(2);
            this.colorBox1.setBackground(bgColor);
        }
    }

    public void assignValues() {
        int durationSelection = this.jComboBox1.getSelectedIndex();
        int transitionSelection = this.jComboBox2.getSelectedIndex();
        int resizeSelection = this.jComboBox3.getSelectedIndex();
        int bgSelection = this.jComboBox4.getSelectedIndex();
        for (int i = 0; i < this.items.length; ++i) {
            if (durationSelection > 0) {
                if (durationSelection == 1) {
                    this.items[i].setDuration(-1.0f);
                } else {
                    this.items[i].setDuration(((Float)this.jSpinner1.getModel().getValue()).floatValue());
                }
            }
            if (transitionSelection > 0) {
                if (transitionSelection == 1) {
                    this.items[i].setTransitionType(SlideShowItem.transition.DEFAULT);
                } else if (transitionSelection == 2) {
                    this.items[i].setTransitionType(SlideShowItem.transition.CROSSFADE);
                } else if (transitionSelection == 3) {
                    this.items[i].setTransitionType(SlideShowItem.transition.WIPE);
                } else {
                    this.items[i].setTransitionType(SlideShowItem.transition.NONE);
                }
            }
            if (resizeSelection > 0) {
                if (resizeSelection == 1) {
                    this.items[i].setResizePolicy(SlideShowItem.resizePolicy.DEFAULT);
                } else if (resizeSelection == 2) {
                    this.items[i].setResizePolicy(SlideShowItem.resizePolicy.CROP);
                } else if (resizeSelection == 3) {
                    this.items[i].setResizePolicy(SlideShowItem.resizePolicy.SCALE);
                } else {
                    this.items[i].setResizePolicy(SlideShowItem.resizePolicy.STRETCH);
                }
            }
            if (bgSelection <= 0) continue;
            if (bgSelection == 1) {
                this.items[i].setBgColor(null);
                continue;
            }
            this.items[i].setBgColor(this.colorBox1.getBackground());
        }
        ListModel m = this.list.getModel();
        this.list.setModel(m);
        this.parent.updateSlideshowInfoIndicators();
    }

    public void centerWindowOnScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.requestFocus();
    }

    private void customDurationSelected(boolean enable) {
        this.jSpinner1.setEnabled(enable);
        this.jLabel2.setEnabled(enable);
    }

    private void customBackgroundSelected(boolean enable) {
        this.colorBox1.setEnabled(enable);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jComboBox3 = new JComboBox();
        this.jComboBox4 = new JComboBox();
        this.colorBox1 = new ColorBox();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanel1.setName("jPanel1");
        ResourceMap resourceMap = Application.getInstance(OOSlideshowApp.class).getContext().getResourceMap(SlideShowItemPropertiesForm.class);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jSpinner1.setModel(new SpinnerNumberModel(Float.valueOf(5.0f), Float.valueOf(0.1f), null, Float.valueOf(0.1f)));
        this.jSpinner1.setEnabled(false);
        this.jSpinner1.setName("jSpinner1");
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SlideShowItemPropertiesForm.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setEnabled(false);
        this.jLabel2.setName("jLabel2");
        this.jSeparator1.setName("jSeparator1");
        this.jLabel3.setFont(resourceMap.getFont("jLabel3.font"));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jSeparator2.setName("jSeparator2");
        this.jLabel6.setFont(resourceMap.getFont("jLabel6.font"));
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setFont(resourceMap.getFont("jLabel7.font"));
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jSeparator3.setName("jSeparator3");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"No change", "Default", "Custom"}));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SlideShowItemPropertiesForm.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"No change", "Default", "Crossfade", "Wipe", "None"}));
        this.jComboBox2.setName("jComboBox2");
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SlideShowItemPropertiesForm.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"No change", "Default", "Center/Crop", "Scale", "Stretch"}));
        this.jComboBox3.setName("jComboBox3");
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"No change", "Default", "Custom"}));
        this.jComboBox4.setName("jComboBox4");
        this.jComboBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SlideShowItemPropertiesForm.this.jComboBox4ActionPerformed(evt);
            }
        });
        this.colorBox1.setName("colorBox1");
        GroupLayout colorBox1Layout = new GroupLayout(this.colorBox1);
        this.colorBox1.setLayout(colorBox1Layout);
        colorBox1Layout.setHorizontalGroup(colorBox1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        colorBox1Layout.setVerticalGroup(colorBox1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox2, -2, 148, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox1, -2, 146, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(220, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap(446, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox3, -2, 147, -2)).addComponent(this.jLabel6).addComponent(this.jLabel7).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jComboBox4, -2, 148, -2).addGap(6, 6, 6).addComponent(this.colorBox1, -2, -1, -2))).addGap(317, 317, 317)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator3, GroupLayout.Alignment.LEADING, -1, 503, Short.MAX_VALUE).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING, -1, 503, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 503, Short.MAX_VALUE)).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.colorBox1, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox4)).addContainerGap(39, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jPanel2.setName("jPanel2");
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SlideShowItemPropertiesForm.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SlideShowItemPropertiesForm.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(388, Short.MAX_VALUE).addComponent(this.jButton2, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 62, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2, -2, 22, -2).addComponent(this.jButton1, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 529, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 295, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.customDurationSelected(this.jComboBox1.getSelectedIndex() == 2);
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
    }

    private void jComboBox4ActionPerformed(ActionEvent evt) {
        this.customBackgroundSelected(this.jComboBox4.getSelectedIndex() == 2);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.assignValues();
        this.dispose();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        Float v = (Float)this.jSpinner1.getValue();
        v = Float.valueOf(v.floatValue() * 10.0f);
        v = Float.valueOf((float)Math.round(v.floatValue()) / 10.0f);
        this.jSpinner1.setValue(v);
    }
}

