/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv;

import com.greendeltatc.simapro.csv.CSVReader;
import com.greendeltatc.simapro.csv.model.SPDataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;

public class CSVParser {
    private SPDataSet dataSet;
    private BufferedReader reader;
    private File csvfile;
    private boolean run;

    public CSVParser(File csvfile) {
        this.csvfile = csvfile;
    }

    private StringReader readPart(String part) throws IOException {
        String line;
        boolean read = true;
        boolean start = false;
        String process = null;
        while ((line = this.reader.readLine()) != null && read) {
            if (line.equals(part)) {
                start = true;
            }
            if (start) {
                process = line.equals(part) ? line + "\n" : process + line + "\n";
            }
            if (!line.equals("End")) continue;
            read = false;
        }
        if (process != null) {
            return new StringReader(process);
        }
        this.reader.close();
        this.reader = null;
        this.run = false;
        return null;
    }

    public SPDataSet getDataSet() {
        return this.dataSet;
    }

    public void start() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new BufferedReader(new FileReader(this.csvfile));
        this.run = true;
    }

    public boolean next() throws IOException, IllegalArgumentException {
        if (!this.run) {
            throw new IllegalArgumentException("Reading was not started.");
        }
        CSVReader csvReader = new CSVReader();
        StringReader reader = this.readPart("Process");
        if (reader != null) {
            try {
                this.dataSet = csvReader.read(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.dataSet = null;
        }
        return this.dataSet != null;
    }

    public int count() throws IOException {
        String line;
        int count = 0;
        this.start();
        while ((line = this.reader.readLine()) != null) {
            if (!line.equals("Process")) continue;
            ++count;
        }
        this.run = false;
        return count;
    }

    public SPDataSet readGeneralData() throws IllegalArgumentException, IOException {
        this.start();
        CSVReader csvReader = new CSVReader();
        SPDataSet dataSet = new SPDataSet("");
        return dataSet;
    }
}

