/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv;

import com.greendeltatc.simapro.csv.model.IDistribution;
import com.greendeltatc.simapro.csv.model.SPCalculatedParameter;
import com.greendeltatc.simapro.csv.model.SPDataEntry;
import com.greendeltatc.simapro.csv.model.SPDataSet;
import com.greendeltatc.simapro.csv.model.SPDocumentation;
import com.greendeltatc.simapro.csv.model.SPElementaryFlow;
import com.greendeltatc.simapro.csv.model.SPInputParameter;
import com.greendeltatc.simapro.csv.model.SPLiteratureReference;
import com.greendeltatc.simapro.csv.model.SPLiteratureReferenceEntry;
import com.greendeltatc.simapro.csv.model.SPLogNormalDistribution;
import com.greendeltatc.simapro.csv.model.SPNormalDistribution;
import com.greendeltatc.simapro.csv.model.SPPedigreeMatrix;
import com.greendeltatc.simapro.csv.model.SPProcess;
import com.greendeltatc.simapro.csv.model.SPProductFlow;
import com.greendeltatc.simapro.csv.model.SPQuantity;
import com.greendeltatc.simapro.csv.model.SPReferenceProduct;
import com.greendeltatc.simapro.csv.model.SPSubstance;
import com.greendeltatc.simapro.csv.model.SPSystemDescription;
import com.greendeltatc.simapro.csv.model.SPSystemDescriptionEntry;
import com.greendeltatc.simapro.csv.model.SPTriangleDistribution;
import com.greendeltatc.simapro.csv.model.SPUniformDistribution;
import com.greendeltatc.simapro.csv.model.SPUnit;
import com.greendeltatc.simapro.csv.model.SPWasteSpecification;
import com.greendeltatc.simapro.csv.model.SPWasteTreatment;
import com.greendeltatc.simapro.csv.model.types.BoundaryWithNature;
import com.greendeltatc.simapro.csv.model.types.CutOffRule;
import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.Geography;
import com.greendeltatc.simapro.csv.model.types.ProcessAllocation;
import com.greendeltatc.simapro.csv.model.types.ProcessCategory;
import com.greendeltatc.simapro.csv.model.types.ProcessType;
import com.greendeltatc.simapro.csv.model.types.ProductFlowType;
import com.greendeltatc.simapro.csv.model.types.Representativeness;
import com.greendeltatc.simapro.csv.model.types.Status;
import com.greendeltatc.simapro.csv.model.types.SubCompartment;
import com.greendeltatc.simapro.csv.model.types.Substitution;
import com.greendeltatc.simapro.csv.model.types.SystemBoundary;
import com.greendeltatc.simapro.csv.model.types.Technology;
import com.greendeltatc.simapro.csv.model.types.TimePeriod;
import com.greendeltatc.simapro.csv.model.types.WasteTreatmentAllocation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CSVReader {
    private Map<String, SPLiteratureReference> literatureReferences = new HashMap<String, SPLiteratureReference>();
    private Map<String, SPQuantity> quantities = new HashMap<String, SPQuantity>();
    private Map<String, SPSubstance> substances = new HashMap<String, SPSubstance>();
    private Map<String, SPSystemDescription> systemDescriptions = new HashMap<String, SPSystemDescription>();
    private Map<String, SPUnit> units = new HashMap<String, SPUnit>();

    private IDistribution createDistibution(String type, String value1, String value2, String value3, String comment) {
        IDistribution distribution = null;
        if (type.toLowerCase().equals("lognormal")) {
            distribution = new SPLogNormalDistribution(Double.parseDouble(value1.replace(",", ".")), this.getPedigreeMatrix(comment));
        } else if (type.toLowerCase().equals("normal")) {
            distribution = new SPNormalDistribution(Double.parseDouble(value1.replace(",", ".")));
        } else if (type.toLowerCase().equals("triangle")) {
            distribution = new SPTriangleDistribution(Double.parseDouble(value2.replace(",", ".")), Double.parseDouble(value3.replace(",", ".")));
        } else if (type.toLowerCase().equals("uniform")) {
            distribution = new SPUniformDistribution(Double.parseDouble(value2.replace(",", ".")), Double.parseDouble(value3.replace(",", ".")));
        }
        return distribution;
    }

    private SPPedigreeMatrix getPedigreeMatrix(String comment) {
        SPPedigreeMatrix matrix = null;
        if (comment.startsWith("(") && comment.indexOf(")") == 12) {
            matrix = new SPPedigreeMatrix();
            String[] pedigree = comment.substring(1, comment.indexOf(")")).split(",");
            matrix.setReliability(pedigree[0]);
            matrix.setCompleteness(pedigree[1]);
            matrix.setTemporalCorrelation(pedigree[2]);
            matrix.setGeographicalCorrelation(pedigree[3]);
            matrix.setFurtherTechnologicalCorrelation(pedigree[4]);
            matrix.setSampleSize(pedigree[5]);
        }
        return matrix;
    }

    private SPSubstance getSubstance(String name) {
        SPSubstance substance = this.substances.get(name);
        if (substance == null) {
            substance = new SPSubstance(name, null, null);
            this.substances.put(name, substance);
        }
        return substance;
    }

    private SPUnit getUnit(String name) {
        SPUnit unit = this.units.get(name);
        if (unit == null) {
            unit = new SPUnit(name, 1.0);
            this.units.put(name, unit);
        }
        return unit;
    }

    private SPCalculatedParameter readCalculatedParameter(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String expression = split[1];
        String comment = split[2];
        for (int i = 3; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPCalculatedParameter(name, expression, comment);
    }

    private SPDataEntry readDataEntry(BufferedReader reader) throws IOException {
        SPDataEntry entry = null;
        SPDocumentation documentation = this.readDocumentation(reader);
        if (documentation.getCategory() == ProcessCategory.WASTE_TREATMENT) {
            entry = this.readWasteTreatment(reader.readLine());
            reader.readLine();
        } else {
            entry = this.readProcess(reader);
        }
        entry.setDocumentation(documentation);
        String line = null;
        while ((line = reader.readLine()) != null && !line.equals("End")) {
            if (line.equals("Avoided products")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readProduct(line, ProductFlowType.AVOIDED_PRODUCT));
                }
                continue;
            }
            if (line.equals("Resources")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.RESOURCE));
                }
                continue;
            }
            if (line.equals("Materials/fuels")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readProduct(line, ProductFlowType.MATERIAL_INPUT));
                }
                continue;
            }
            if (line.equals("Electricity/heat")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readProduct(line, ProductFlowType.ELECTRICITY_INPUT));
                }
                continue;
            }
            if (line.equals("Emissions to air")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.EMISSION_TO_AIR));
                }
                continue;
            }
            if (line.equals("Emissions to water")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.EMISSION_TO_WATER));
                }
                continue;
            }
            if (line.equals("Emissions to soil")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.EMISSION_TO_SOIL));
                }
                continue;
            }
            if (line.equals("Final waste flows")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.FINAL_WASTE));
                }
                continue;
            }
            if (line.equals("Non material emissions")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.NON_MATERIAL_EMISSIONS));
                }
                continue;
            }
            if (line.equals("Social issues")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.SOCIAL_ISSUE));
                }
                continue;
            }
            if (line.equals("Economic issues")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readElementaryFlow(line, ElementaryFlowType.ECONOMIC_ISSUE));
                }
                continue;
            }
            if (line.equals("Waste to treatment")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readProduct(line, ProductFlowType.WASTE_TREATMENT));
                }
                continue;
            }
            if (line.equals("Input parameters")) {
                while ((line = reader.readLine()) != null && !line.equals("")) {
                    entry.add(this.readInputParameter(line));
                }
                continue;
            }
            if (!line.equals("Calculated parameters")) continue;
            while ((line = reader.readLine()) != null && !line.equals("")) {
                entry.add(this.readCalculatedParameter(line));
            }
        }
        return entry;
    }

    private SPDocumentation readDocumentation(BufferedReader reader) throws IOException {
        String line = null;
        ProcessCategory category = null;
        String identifier = null;
        ProcessType type = null;
        String name = null;
        Status status = null;
        TimePeriod period = null;
        Geography geography = null;
        Technology technology = null;
        Representativeness representativeness = null;
        ProcessAllocation processAllocation = null;
        Substitution substitution = null;
        CutOffRule rule = null;
        BoundaryWithNature boundaryWithNature = null;
        SystemBoundary systemBoundary = null;
        WasteTreatmentAllocation wasteAllocation = null;
        boolean infrastructure = false;
        String date = null;
        String record = null;
        String generator = null;
        String collectionMethod = null;
        String dataTreatment = null;
        String verification = null;
        String comment = null;
        String allocationRules = null;
        SPSystemDescriptionEntry systemDescriptionEntry = null;
        SPLiteratureReferenceEntry[] literatureReferenceEntries = null;
        while ((line = reader.readLine()) != null && !line.equals("Products") && !line.equals("Waste treatment")) {
            if (line.equals("Category type")) {
                category = ProcessCategory.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Process identifier")) {
                identifier = reader.readLine();
                continue;
            }
            if (line.equals("Type")) {
                type = ProcessType.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Process name")) {
                name = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Status")) {
                status = Status.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Time period")) {
                period = TimePeriod.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Geography")) {
                geography = Geography.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Technology")) {
                technology = Technology.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Representativeness")) {
                representativeness = Representativeness.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Multiple output allocation")) {
                processAllocation = ProcessAllocation.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Substitution allocation")) {
                substitution = Substitution.forValue(reader.readLine());
                continue;
            }
            if (line.equals("Cut off rules")) {
                rule = CutOffRule.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Capital goods")) {
                systemBoundary = SystemBoundary.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Boundary with nature")) {
                boundaryWithNature = BoundaryWithNature.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Waste treatment allocation")) {
                wasteAllocation = WasteTreatmentAllocation.forValue(reader.readLine().replace(";", ""));
                continue;
            }
            if (line.equals("Infrastructure")) {
                String iLine = reader.readLine().replace(";", "");
                infrastructure = iLine.equals("Yes");
                continue;
            }
            if (line.equals("Date")) {
                date = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Record")) {
                record = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Generator")) {
                generator = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Collection method")) {
                collectionMethod = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Data treatment")) {
                dataTreatment = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Verification")) {
                verification = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Comment")) {
                comment = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("Allocation rules")) {
                allocationRules = reader.readLine().replace(";", "");
                continue;
            }
            if (line.equals("System description")) {
                systemDescriptionEntry = this.readSystemDescriptionEntry(reader.readLine());
                continue;
            }
            if (!line.equals("Literature references")) continue;
            literatureReferenceEntries = this.readLiteratureReferenceEntries(reader);
        }
        SPDocumentation documentation = new SPDocumentation(name, category, type);
        documentation.setIdentifier(identifier);
        documentation.setAllocationRules(allocationRules);
        documentation.setBoundaryWithNature(boundaryWithNature);
        documentation.setCollectionMethod(collectionMethod);
        documentation.setComment(comment);
        documentation.setCreationDate(date);
        documentation.setCutOffRule(rule);
        documentation.setDataTreatment(dataTreatment);
        documentation.setGenerator(generator);
        documentation.setGeography(geography);
        documentation.setInfrastructureProcess(infrastructure);
        documentation.setProcessAllocation(processAllocation);
        documentation.setRecord(record);
        documentation.setRepresentativeness(representativeness);
        documentation.setStatus(status);
        documentation.setSubstitution(substitution);
        documentation.setSystemBoundary(systemBoundary);
        documentation.setSystemDescriptionEntry(systemDescriptionEntry);
        documentation.setTechnology(technology);
        documentation.setTimePeriod(period);
        documentation.setVerification(verification);
        documentation.setWasteTreatmentAllocation(wasteAllocation);
        if (literatureReferenceEntries != null) {
            for (void var33_33 : literatureReferenceEntries) {
                documentation.add((SPLiteratureReferenceEntry)var33_33);
            }
        }
        return documentation;
    }

    private SPElementaryFlow readElementaryFlow(String line, ElementaryFlowType type) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String subCompartment = split[1];
        String unit = split[2];
        String formula = split[3];
        String distribution = split[4];
        String dValue1 = split[5];
        String dValue2 = split[6];
        String dValue3 = split[7];
        String comment = split[8];
        for (int i = 9; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPElementaryFlow(type, SubCompartment.forValue(subCompartment), this.getSubstance(name), this.getUnit(unit), formula, comment, this.createDistibution(distribution, dValue1, dValue2, dValue3, comment));
    }

    private SPInputParameter readInputParameter(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String value = split[1];
        String distribution = split[2];
        String dValue1 = split[3];
        String dValue2 = split[4];
        String dValue3 = split[5];
        String hidden = split[6];
        String comment = split[7];
        for (int i = 8; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPInputParameter(name, Double.parseDouble(value.replace(',', '.')), this.createDistibution(distribution, dValue1, dValue2, dValue3, comment), comment, hidden.equals("Yes"));
    }

    private void readLiteratureReference(BufferedReader reader) throws IOException {
        String line = null;
        String name = null;
        String category = null;
        String description = null;
        while ((line = reader.readLine()) != null && !line.equals("End")) {
            if (line.equals("Name")) {
                name = line.replace(";", "");
                continue;
            }
            if (line.equals("Category")) {
                category = line.replace(";", "");
                continue;
            }
            if (!line.equals("Description")) continue;
            description = line.replace(";", "");
        }
        SPLiteratureReference literatureReference = this.literatureReferences.get(name);
        if (literatureReference != null) {
            literatureReference.setCategory(category);
            literatureReference.setContent(description);
        }
    }

    private SPLiteratureReferenceEntry[] readLiteratureReferenceEntries(BufferedReader reader) throws IOException {
        ArrayList<SPLiteratureReferenceEntry> entries = new ArrayList<SPLiteratureReferenceEntry>();
        String line = null;
        while ((line = reader.readLine()) != null && !line.equals("")) {
            SPLiteratureReference literatureReference;
            String lrName = null;
            String lrComment = null;
            if (line.contains(";")) {
                lrName = line.substring(0, line.indexOf(59));
                if (!line.endsWith(";")) {
                    lrComment = line.substring(line.indexOf(59) + 1);
                }
            } else {
                lrName = line;
            }
            if ((literatureReference = this.literatureReferences.get(lrName)) == null) {
                literatureReference = new SPLiteratureReference(lrName, null, null);
                this.literatureReferences.put(lrName, literatureReference);
            }
            entries.add(new SPLiteratureReferenceEntry(literatureReference, lrComment));
        }
        return entries.toArray(new SPLiteratureReferenceEntry[entries.size()]);
    }

    private SPProcess readProcess(BufferedReader reader) throws IOException {
        ArrayList<SPReferenceProduct> referenceProducts = new ArrayList<SPReferenceProduct>();
        String subCategory = null;
        String line = null;
        while ((line = reader.readLine()) != null && !line.equals("")) {
            if (subCategory == null) {
                subCategory = line;
                for (int semCounter = 0; semCounter < 5 && subCategory.contains(";"); ++semCounter) {
                    subCategory = subCategory.substring(subCategory.indexOf(59) + 1);
                }
                if (subCategory.contains(";")) {
                    subCategory = subCategory.substring(0, subCategory.indexOf(59));
                }
            }
            referenceProducts.add(this.readReference(line));
        }
        SPProcess process = null;
        process = new SPProcess((SPReferenceProduct)referenceProducts.get(0), subCategory, null);
        for (int i = 1; i < referenceProducts.size(); ++i) {
            process.add((SPReferenceProduct)referenceProducts.get(i));
        }
        return process;
    }

    private SPProductFlow readProduct(String line, ProductFlowType type) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String unit = split[1];
        String formula = split[2];
        String distribution = split[3];
        String dValue1 = split[4];
        String dValue2 = split[5];
        String dValue3 = split[6];
        String comment = split[7];
        for (int i = 8; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPProductFlow(type, name, this.getUnit(unit), formula, comment, this.createDistibution(distribution, dValue1, dValue2, dValue3, comment));
    }

    private String readProjectLine(String line) {
        String project = line.substring(line.indexOf(58) + 1);
        while (project.startsWith(" ")) {
            project = project.substring(1);
        }
        project = project.substring(0, project.indexOf(125));
        return project;
    }

    private SPQuantity readQuantity(String line) {
        String name = line.substring(0, line.indexOf(59));
        String dimensional = line = line.substring(0, line.indexOf(59));
        if (dimensional.contains(";")) {
            dimensional = dimensional.substring(0, dimensional.indexOf(59));
        }
        SPQuantity quantity = new SPQuantity(name, null);
        quantity.setDimensional(dimensional.equals("Yes"));
        this.quantities.put(name, quantity);
        return quantity;
    }

    private SPReferenceProduct readReference(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String unit = split[1];
        String formula = split[2];
        String allocation = split[3];
        String wasteType = split[4];
        String category = split[5];
        String comment = split[6];
        for (int i = 7; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPReferenceProduct(name, this.getUnit(unit), formula, Double.parseDouble(allocation.replace(',', '.')), wasteType, comment, category);
    }

    private void readSubstance(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String unit = split[1];
        String cas = split[2];
        String comment = split[3];
        for (int i = 4; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        SPSubstance substance = this.substances.get(name);
        if (substance != null) {
            substance.setCASNumber(cas);
            substance.setReferenceUnit(this.getUnit(unit));
            substance.setComment(comment);
        }
    }

    private void readSystemDescription(BufferedReader reader) throws IOException {
        String line = null;
        String name = null;
        String category = null;
        String description = null;
        String subSystems = null;
        String cutOffRules = null;
        String energyModel = null;
        String transportModel = null;
        String wasteModel = null;
        String otherAssumptions = null;
        String otherInformation = null;
        String allocationRules = null;
        while ((line = reader.readLine()) != null && !line.equals("End")) {
            if (line.equals("Name")) {
                name = line.replace(";", "");
                continue;
            }
            if (line.equals("Category")) {
                category = line.replace(";", "");
                continue;
            }
            if (line.equals("Description")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Sub-systems")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Cut-off rules")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Energy model")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Transport model")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Waste model")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Other assumptions")) {
                description = line.replace(";", "");
                continue;
            }
            if (line.equals("Other information")) {
                description = line.replace(";", "");
                continue;
            }
            if (!line.equals("Allocation rules")) continue;
            description = line.replace(";", "");
        }
        SPSystemDescription systemDescription = this.systemDescriptions.get(name);
        if (systemDescription != null) {
            systemDescription.setAllocationRules(allocationRules);
            systemDescription.setCategory(category);
            systemDescription.setCutOffRules(cutOffRules);
            systemDescription.setDescription(description);
            systemDescription.setEnergyModel(energyModel);
            systemDescription.setOtherAssumptions(otherAssumptions);
            systemDescription.setOtherInformation(otherInformation);
            systemDescription.setSubSystems(subSystems);
            systemDescription.setTransportModel(transportModel);
            systemDescription.setWasteModel(wasteModel);
        }
    }

    private SPSystemDescriptionEntry readSystemDescriptionEntry(String line) {
        SPSystemDescriptionEntry entry = null;
        String sdName = null;
        String sdComment = null;
        if (line.contains(";")) {
            sdName = line.substring(0, line.indexOf(59));
            if (!line.endsWith(";")) {
                sdComment = line.substring(line.indexOf(59) + 1);
            }
        } else {
            sdName = line;
        }
        if (!sdName.equals("")) {
            SPSystemDescription systemDescription = this.systemDescriptions.get(sdName);
            if (systemDescription == null) {
                systemDescription = new SPSystemDescription(sdName, null);
                this.systemDescriptions.put(sdName, systemDescription);
            }
            entry = new SPSystemDescriptionEntry(systemDescription, sdComment);
        }
        return entry;
    }

    private void readUnit(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String quantityName = split[1];
        String conversionFactor = split[2];
        String referenceUnit = split[3];
        for (int i = 4; i < split.length - 1; ++i) {
            referenceUnit = referenceUnit + ";" + split[i];
        }
        SPUnit unit = this.units.get(name);
        if (unit != null) {
            unit.setConversionFactor(Double.parseDouble(conversionFactor.replace(',', '.')));
            SPQuantity quantity = this.quantities.get(quantityName);
            if (quantity != null) {
                quantity.add(unit);
                if (referenceUnit.equals(name)) {
                    quantity.setReferenceUnit(unit);
                }
            }
        }
    }

    private SPWasteSpecification readWasteSpecification(String line) {
        line = line + "; ";
        String[] split = line.split(";");
        String name = split[0];
        String unit = split[1];
        String formula = split[2];
        String wasteType = split[3];
        String category = split[4];
        String comment = split[5];
        for (int i = 6; i < split.length - 1; ++i) {
            comment = comment + ";" + split[i];
        }
        return new SPWasteSpecification(name, this.getUnit(unit), formula, wasteType, comment, category);
    }

    private SPWasteTreatment readWasteTreatment(String line) {
        String subCategory = line;
        for (int semCounter = 0; semCounter < 4 && subCategory.contains(";"); ++semCounter) {
            subCategory = subCategory.substring(subCategory.indexOf(59) + 1);
        }
        if (subCategory.contains(";")) {
            subCategory = subCategory.substring(0, subCategory.indexOf(59));
        }
        return new SPWasteTreatment(this.readWasteSpecification(line), subCategory, null);
    }

    public SPDataSet read(File csvFile) throws IOException {
        return this.read(new FileReader(csvFile));
    }

    public SPDataSet read(Reader csvReader) throws IOException {
        BufferedReader reader = new BufferedReader(csvReader);
        String line = null;
        SPDataSet dataSet = new SPDataSet(null);
        while ((line = reader.readLine()) != null) {
            if ((line = line.replace("\u007f", "/n")).startsWith("{Project:")) {
                dataSet.setProject(this.readProjectLine(line));
                continue;
            }
            if (line.equals("Process")) {
                SPDataEntry entry = this.readDataEntry(reader);
                if (entry instanceof SPProcess) {
                    dataSet.add((SPProcess)entry);
                    continue;
                }
                if (!(entry instanceof SPWasteTreatment)) continue;
                dataSet.add((SPWasteTreatment)entry);
                continue;
            }
            if (line.equals("System description")) {
                this.readSystemDescription(reader);
                continue;
            }
            if (line.equals("Literature reference")) {
                this.readLiteratureReference(reader);
                continue;
            }
            if (line.equals("Database Input parameters") || line.equals("Project Input parameters")) {
                while ((line = reader.readLine()) != null && !line.equals("") && !line.equals("End")) {
                    dataSet.add(this.readInputParameter(line));
                }
                continue;
            }
            if (line.equals("Database Calculated parameters") || line.equals("Project Input parameters")) {
                while ((line = reader.readLine()) != null && !line.equals("") && !line.equals("End")) {
                    dataSet.add(this.readCalculatedParameter(line));
                }
                continue;
            }
            if (line.equals("Quantities")) {
                while ((line = reader.readLine()) != null && !line.equals("") && !line.equals("End")) {
                    dataSet.add(this.readQuantity(line));
                }
                continue;
            }
            if (line.equals("Units")) {
                while ((line = reader.readLine()) != null && !line.equals("") && !line.equals("End")) {
                    this.readUnit(line);
                }
                continue;
            }
            if (!line.equals("Raw materials") && !line.equals("Airborne emissions") && !line.equals("Waterborne emissions") && !line.equals("Final waste flows") && !line.equals("Emissions to soil") && !line.equals("Non material emissions")) continue;
            while ((line = reader.readLine()) != null && !line.equals("") && !line.equals("End")) {
                this.readSubstance(line);
            }
        }
        return dataSet;
    }
}

