/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv;

import com.greendeltatc.simapro.csv.model.IDistribution;
import com.greendeltatc.simapro.csv.model.SPCalculatedParameter;
import com.greendeltatc.simapro.csv.model.SPDataEntry;
import com.greendeltatc.simapro.csv.model.SPDataSet;
import com.greendeltatc.simapro.csv.model.SPDocumentation;
import com.greendeltatc.simapro.csv.model.SPElementaryFlow;
import com.greendeltatc.simapro.csv.model.SPFlow;
import com.greendeltatc.simapro.csv.model.SPInputParameter;
import com.greendeltatc.simapro.csv.model.SPLiteratureReference;
import com.greendeltatc.simapro.csv.model.SPLiteratureReferenceEntry;
import com.greendeltatc.simapro.csv.model.SPLogNormalDistribution;
import com.greendeltatc.simapro.csv.model.SPProcess;
import com.greendeltatc.simapro.csv.model.SPProductFlow;
import com.greendeltatc.simapro.csv.model.SPQuantity;
import com.greendeltatc.simapro.csv.model.SPReferenceProduct;
import com.greendeltatc.simapro.csv.model.SPSystemDescription;
import com.greendeltatc.simapro.csv.model.SPUnit;
import com.greendeltatc.simapro.csv.model.SPWasteSpecification;
import com.greendeltatc.simapro.csv.model.SPWasteToTreatmentFlow;
import com.greendeltatc.simapro.csv.model.SPWasteTreatment;
import com.greendeltatc.simapro.csv.model.types.BoundaryWithNature;
import com.greendeltatc.simapro.csv.model.types.CutOffRule;
import com.greendeltatc.simapro.csv.model.types.DistributionParameterType;
import com.greendeltatc.simapro.csv.model.types.DistributionType;
import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.Geography;
import com.greendeltatc.simapro.csv.model.types.ProcessAllocation;
import com.greendeltatc.simapro.csv.model.types.ProcessCategory;
import com.greendeltatc.simapro.csv.model.types.ProductFlowType;
import com.greendeltatc.simapro.csv.model.types.Representativeness;
import com.greendeltatc.simapro.csv.model.types.Status;
import com.greendeltatc.simapro.csv.model.types.Substitution;
import com.greendeltatc.simapro.csv.model.types.SystemBoundary;
import com.greendeltatc.simapro.csv.model.types.Technology;
import com.greendeltatc.simapro.csv.model.types.TimePeriod;
import com.greendeltatc.simapro.csv.model.types.WasteTreatmentAllocation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CSVWriter {
    private char separator = (char)44;
    private BufferedWriter writer = null;

    public CSVWriter() {
    }

    public CSVWriter(char separator) {
        this.separator = separator;
    }

    private SPSystemDescription[] collectSystemDescriptions(SPDataSet dataSet) {
        SPSystemDescription sd;
        ArrayList<SPSystemDescription> systemDescriptions = new ArrayList<SPSystemDescription>();
        ArrayList<String> descriptionNames = new ArrayList<String>();
        for (SPProcess sPProcess : dataSet.getProcesses()) {
            if (sPProcess.getDocumentation().getSystemDescriptionEntry() == null || descriptionNames.contains((sd = sPProcess.getDocumentation().getSystemDescriptionEntry().getSystemDescription()).getName())) continue;
            descriptionNames.add(sd.getName());
            systemDescriptions.add(sd);
        }
        for (SPDataEntry sPDataEntry : dataSet.getWasteTreatments()) {
            if (sPDataEntry.getDocumentation().getSystemDescriptionEntry() == null || descriptionNames.contains((sd = sPDataEntry.getDocumentation().getSystemDescriptionEntry().getSystemDescription()).getName())) continue;
            descriptionNames.add(sd.getName());
            systemDescriptions.add(sd);
        }
        return systemDescriptions.toArray(new SPSystemDescription[systemDescriptions.size()]);
    }

    private SPLiteratureReference[] collectLiteratureReferences(SPDataSet dataSet) {
        SPLiteratureReference lr;
        ArrayList<SPLiteratureReference> literatureReferences = new ArrayList<SPLiteratureReference>();
        ArrayList<String> referenceNames = new ArrayList<String>();
        for (SPProcess sPProcess : dataSet.getProcesses()) {
            for (SPLiteratureReferenceEntry entry : sPProcess.getDocumentation().getLiteratureReferencesEntries()) {
                lr = entry.getLiteratureReference();
                if (referenceNames.contains(lr.getName())) continue;
                referenceNames.add(lr.getName());
                literatureReferences.add(lr);
            }
        }
        for (SPDataEntry sPDataEntry : dataSet.getWasteTreatments()) {
            for (SPLiteratureReferenceEntry entry : sPDataEntry.getDocumentation().getLiteratureReferencesEntries()) {
                lr = entry.getLiteratureReference();
                if (referenceNames.contains(lr.getName())) continue;
                referenceNames.add(lr.getName());
                literatureReferences.add(lr);
            }
        }
        return literatureReferences.toArray(new SPLiteratureReference[literatureReferences.size()]);
    }

    private void writeLiteratureReference(SPLiteratureReference literatureReference) throws IOException {
        this.writeln("Literature reference");
        this.writer.newLine();
        this.writeEntry("Name", literatureReference.getName());
        this.writer.newLine();
        this.writeEntry("Category", literatureReference.getCategory() != null ? literatureReference.getCategory() : "Others");
        this.writer.newLine();
        this.writeEntry("Description", literatureReference.getContent());
        this.writer.newLine();
        this.writeln("End");
        this.writer.newLine();
    }

    private String getDistributionPart(IDistribution distribution) {
        String line = "";
        if (distribution == null) {
            line = "Undefined;0;0;0;";
        } else {
            DistributionType type = distribution.getType();
            if (type == null) {
                type = DistributionType.UNDEFINED;
            }
            line = type.getValue().replace('.', this.separator) + ";";
            switch (distribution.getType()) {
                case LOG_NORMAL: {
                    SPLogNormalDistribution logNormalDistribution = (SPLogNormalDistribution)distribution;
                    line = line + distribution.getDistributionParameter(DistributionParameterType.SQUARED_STANDARD_DEVIATION) + ";0;0;" + logNormalDistribution.getPedigreeMatrix().getPedigreeCommentString();
                    break;
                }
                case NORMAL: {
                    line = line + distribution.getDistributionParameter(DistributionParameterType.DOUBLED_STANDARD_DEVIATION) + ";0;0;";
                    break;
                }
                case TRIANGLE: {
                    line = line + "0;" + distribution.getDistributionParameter(DistributionParameterType.MINIMUM) + ";" + distribution.getDistributionParameter(DistributionParameterType.MAXIMUM) + ";";
                    break;
                }
                case UNIFORM: {
                    line = line + "0;" + distribution.getDistributionParameter(DistributionParameterType.MINIMUM) + ";" + distribution.getDistributionParameter(DistributionParameterType.MAXIMUM) + ";";
                    break;
                }
                case UNDEFINED: {
                    line = line + "0;0;0;";
                }
            }
        }
        return line;
    }

    private String getElementaryFlowLine(SPElementaryFlow flow) {
        String line = flow.getSubstance().getName() + ";";
        if (flow.getSubCompartment() != null) {
            line = line + flow.getSubCompartment().getValue();
        }
        line = line + ";" + flow.getUnit().getName() + ";" + flow.getAmount().replace('.', this.separator) + ";" + this.getDistributionPart(flow.getDistribution()) + flow.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
        return line;
    }

    private String getProductLine(SPProductFlow product) {
        String line = product.getName() + ";" + product.getUnit().getName() + ";" + product.getAmount().replace('.', this.separator) + ";" + this.getDistributionPart(product.getDistribution());
        if (product.getComment() != null) {
            line = line + product.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
        }
        return line;
    }

    private String getWasteToTreatmentLine(SPWasteToTreatmentFlow flow) {
        String line = flow.getName() + ";" + flow.getUnit().getName() + ";" + flow.getAmount() + ";" + flow.getDistributionType().getValue() + ";" + flow.getStandardDeviation() + ";" + flow.getMin() + ";" + flow.getMax() + ";";
        return line;
    }

    private String getProductLine(SPReferenceProduct product, String subCategory) {
        String line = product.getName() + ";" + product.getUnit().getName() + ";" + product.getAmount().replace('.', this.separator) + ";" + product.getAllocation() + ";";
        line = product.getWasteType() != null && !product.getWasteType().equals("") ? line + product.getWasteType() : line + "not defined";
        line = line + ";";
        line = subCategory != null ? line + subCategory : line + "Others";
        line = line + ";";
        if (product.getComment() != null) {
            line = line + product.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
        }
        line = line + ";";
        return line;
    }

    private String getWasteSpecificationLine(SPWasteSpecification wasteSpecification, String subCategory) {
        String line = wasteSpecification.getName() + ";" + wasteSpecification.getUnit().getName() + ";" + wasteSpecification.getAmount().replace('.', this.separator) + ";";
        line = wasteSpecification.getWasteType() != null && !wasteSpecification.getWasteType().equals("") ? line + wasteSpecification.getWasteType() : line + "All waste types";
        line = line + ";Others";
        if (subCategory != null) {
            line = line + subCategory;
        }
        line = line + ";";
        if (wasteSpecification.getComment() != null) {
            line = line + wasteSpecification.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
        }
        line = line + ";";
        return line;
    }

    private void setUp(String fileName, File directory) throws IOException {
        File file = new File(directory.getAbsolutePath() + File.separator + fileName + ".csv");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    private void tearDown() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    private void writeCalculatedParameter(SPCalculatedParameter parameter) throws IOException {
        this.writeln(parameter.getName() + ";" + parameter.getExpression().replace(".", String.valueOf(this.separator)) + ";" + (parameter.getComment() != null ? parameter.getComment().replace(';', ',') : "").replaceAll("\\r?\\n", "\u007f") + '\u007f');
    }

    private void writeDocumentation(SPDocumentation documentation, boolean process) throws IOException {
        String systemDescription;
        if (process) {
            this.writeEntry("Category type", documentation.getCategory() != null ? documentation.getCategory().getValue() : ProcessCategory.MATERIAL.getValue());
        } else {
            this.writeEntry("Category type", ProcessCategory.WASTE_TREATMENT.getValue());
        }
        this.writeEntry("Process identifier", null);
        this.writeEntry("Type", null);
        this.writeEntry("Process name", documentation.getName());
        this.writeEntry("Status", documentation.getStatus() != null ? documentation.getStatus().getValue() : Status.FINISHED.getValue());
        this.writeEntry("Time period", documentation.getTimePeriod() != null ? documentation.getTimePeriod().getValue() : TimePeriod.UNSPECIFIED.getValue());
        this.writeEntry("Geography", documentation.getGeography() != null ? documentation.getGeography().getValue() : Geography.UNSPECIFIED.getValue());
        this.writeEntry("Technology", documentation.getTechnology() != null ? documentation.getTechnology().getValue() : Technology.UNSPECIFIED.getValue());
        this.writeEntry("Representativeness", documentation.getRepresentativeness() != null ? documentation.getRepresentativeness().getValue() : Representativeness.UNSPECIFIED.getValue());
        if (process) {
            this.writeEntry("Multiple output allocation", documentation.getProcessAllocation() != null ? documentation.getProcessAllocation().getValue() : ProcessAllocation.UNSPECIFIED.getValue());
            this.writeEntry("Substitution allocation", documentation.getSubstitution() != null ? documentation.getSubstitution().getValue() : Substitution.UNSPECIFIED.getValue());
        } else {
            this.writeEntry("Waste treatment allocation", documentation.getWasteTreatmentAllocation() != null ? documentation.getWasteTreatmentAllocation().getValue() : WasteTreatmentAllocation.UNSPECIFIED.getValue());
        }
        this.writeEntry("Cut off rules", documentation.getCutOffRule() != null ? documentation.getCutOffRule().getValue() : CutOffRule.UNSPECIFIED.getValue());
        this.writeEntry("Capital goods", documentation.getSystemBoundary() != null ? documentation.getSystemBoundary().getValue() : SystemBoundary.UNSPECIFIED.getValue());
        this.writeEntry("Boundary with nature", documentation.getBoundaryWithNature() != null ? documentation.getBoundaryWithNature().getValue() : BoundaryWithNature.UNSPECIFIED.getValue());
        this.writeEntry("Infrastructure", documentation.isInfrastructureProcess() ? "Yes" : "No");
        this.writeEntry("Date", documentation.getCreationDate());
        this.writeEntry("Record", documentation.getRecord().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeEntry("Generator", documentation.getGenerator().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeln("Literature references");
        boolean atLeastOneReference = false;
        for (SPLiteratureReferenceEntry entry : documentation.getLiteratureReferencesEntries()) {
            String literatureReference;
            String string = literatureReference = entry.getLiteratureReference() != null ? entry.getLiteratureReference().getName() : null;
            if (literatureReference != null && !literatureReference.equals("") && entry.getComment() != null) {
                literatureReference = literatureReference + ";" + entry.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
            }
            if (literatureReference == null || literatureReference.equals("")) continue;
            this.writeln(literatureReference);
            atLeastOneReference = true;
        }
        if (!atLeastOneReference) {
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writeEntry("Collection method", documentation.getCollectionMethod().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeEntry("Data treatment", documentation.getDataTreatment().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeEntry("Verification", documentation.getVerification().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeEntry("Comment", "\"" + (documentation.getComment().replace('\"', '\'') + "\"").replaceAll("\\r?\\n", "\u007f") + '\u007f');
        this.writeEntry("Allocation rules", documentation.getAllocationRules().replaceAll("\\r?\\n", "\u007f") + '\u007f');
        String string = systemDescription = documentation.getSystemDescriptionEntry() != null ? documentation.getSystemDescriptionEntry().getSystemDescription().getName() : null;
        if (systemDescription != null && !systemDescription.equals("") && documentation.getSystemDescriptionEntry().getComment() != null) {
            systemDescription = systemDescription + ";" + documentation.getSystemDescriptionEntry().getComment();
        }
        if (systemDescription != null) {
            systemDescription = systemDescription.replaceAll("\\r?\\n", "\u007f") + '\u007f';
        }
        this.writeEntry("System description", systemDescription);
    }

    private void writeEntry(String name, String value) throws IOException {
        this.writeln(name);
        this.writeln(value != null ? value : "");
        this.writer.newLine();
    }

    private void writeHeader(String project) throws IOException {
        this.writeln("{SimaPro 7.2}");
        this.writeln("{Processes}");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss");
        this.writeln("{Date: " + dateFormat.format(new Date()) + "}");
        this.writeln("{Time: " + timeFormat.format(new Date()) + "}");
        this.writeln("{Project: " + project + "}");
        this.writeln("{CSV Format version: 7.0.0}");
        this.writeln("{CSV separator: Semicolon}");
        this.writeln("{Decimal separator: " + this.separator + "}");
        this.writeln("{Date separator: .}");
        this.writeln("{Short date format: dd.MM.yyyy}");
        this.writer.newLine();
    }

    private void writeInputParameter(SPInputParameter parameter) throws IOException {
        String line = parameter.getName() + ";" + Double.toString(parameter.getValue()).replace(".", String.valueOf(this.separator)) + ";";
        line = line + this.getDistributionPart(parameter.getDistribution());
        line = line + (parameter.isHidden() ? "Yes" : "No") + ";";
        if (parameter.getComment() != null) {
            line = line + parameter.getComment().replaceAll("\\r?\\n", "\u007f") + '\u007f';
        }
        this.writeln(line);
    }

    private void writeln(String line) throws IOException {
        this.writer.write(line);
        this.writer.newLine();
    }

    private void writeProcess(SPProcess process) throws IOException {
        this.writeln("Process");
        this.writer.newLine();
        this.writeDocumentation(process.getDocumentation(), true);
        this.writeln("Products");
        for (SPReferenceProduct sPReferenceProduct : process.getReferenceProducts()) {
            this.writeln(this.getProductLine(sPReferenceProduct, process.getSubCategory()));
        }
        this.writer.newLine();
        this.writeln("Avoided products");
        for (SPFlow sPFlow : process.getProductFlows(ProductFlowType.AVOIDED_PRODUCT)) {
            this.writeln(this.getProductLine((SPProductFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Resources");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.RESOURCE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Materials/fuels");
        for (SPFlow sPFlow : process.getProductFlows(ProductFlowType.MATERIAL_INPUT)) {
            this.writeln(this.getProductLine((SPProductFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Electricity/heat");
        for (SPFlow sPFlow : process.getProductFlows(ProductFlowType.ELECTRICITY_INPUT)) {
            this.writeln(this.getProductLine((SPProductFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to air");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.EMISSION_TO_AIR)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to water");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.EMISSION_TO_WATER)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to soil");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.EMISSION_TO_SOIL)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Final waste flows");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.FINAL_WASTE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Non material emissions");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.NON_MATERIAL_EMISSIONS)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Social issues");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.SOCIAL_ISSUE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Economic issues");
        for (SPFlow sPFlow : process.getElementaryFlows(ElementaryFlowType.ECONOMIC_ISSUE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Waste to treatment");
        for (SPFlow sPFlow : process.getWasteToTreatmentFlows()) {
            this.writeln(this.getWasteToTreatmentLine((SPWasteToTreatmentFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Input parameters");
        if (process.getInputParameters() != null && process.getInputParameters().length > 0) {
            for (SPInputParameter sPInputParameter : process.getInputParameters()) {
                this.writeInputParameter(sPInputParameter);
            }
        } else {
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writeln("Calculated parameters");
        if (process.getCalculatedParameters() != null && process.getCalculatedParameters().length > 0) {
            for (SPCalculatedParameter sPCalculatedParameter : process.getCalculatedParameters()) {
                this.writeCalculatedParameter(sPCalculatedParameter);
            }
        } else {
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writeln("End");
        this.writer.newLine();
    }

    private void writeQuantity(SPQuantity quantity) throws IOException {
        this.writeln(quantity.getName() + ";" + (quantity.isDimensional() ? "Yes" : "No"));
    }

    private void writeSystemDescription(SPSystemDescription systemDescription) throws IOException {
        this.writeln("System description");
        this.writer.newLine();
        this.writeEntry("Name", systemDescription.getName());
        this.writeEntry("Category", systemDescription.getCategory() != null ? systemDescription.getCategory() : "Others");
        this.writeEntry("Description", systemDescription.getDescription());
        this.writeEntry("Sub-systems", systemDescription.getSubSystems());
        this.writeEntry("Cut-off rules", systemDescription.getCutOffRules());
        this.writeEntry("Energy model", systemDescription.getEnergyModel());
        this.writeEntry("Transport model", systemDescription.getTransportModel());
        this.writeEntry("Waste model", systemDescription.getWasteModel());
        this.writeEntry("Other assumptions", systemDescription.getOtherAssumptions());
        this.writeEntry("Other information", systemDescription.getOtherInformation());
        this.writeEntry("Allocation rules", systemDescription.getAllocationRules());
        this.writeln("End");
        this.writer.newLine();
    }

    private void writeUnit(SPQuantity quantity, SPUnit unit) throws IOException {
        this.writeln(unit.getName() + ";" + quantity.getName() + ";" + unit.getConversionFactor() + ";" + quantity.getReferenceUnit().getName());
    }

    private void writeWasteTreatment(SPWasteTreatment wasteTreatment) throws IOException {
        this.writeln("Process");
        this.writer.newLine();
        this.writeDocumentation(wasteTreatment.getDocumentation(), false);
        this.writeln("Waste treatment");
        this.writeln(this.getWasteSpecificationLine(wasteTreatment.getWasteSpecification(), wasteTreatment.getSubCategory()));
        this.writer.newLine();
        this.writeln("Avoided products");
        for (SPProductFlow sPProductFlow : wasteTreatment.getProductFlows(ProductFlowType.AVOIDED_PRODUCT)) {
            this.writeln(this.getProductLine(sPProductFlow));
        }
        this.writer.newLine();
        this.writeln("Resources");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.RESOURCE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Materials/fuels");
        for (SPFlow sPFlow : wasteTreatment.getProductFlows(ProductFlowType.MATERIAL_INPUT)) {
            this.writeln(this.getProductLine((SPProductFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Electricity/heat");
        for (SPFlow sPFlow : wasteTreatment.getProductFlows(ProductFlowType.ELECTRICITY_INPUT)) {
            this.writeln(this.getProductLine((SPProductFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to air");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.EMISSION_TO_AIR)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to water");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.EMISSION_TO_WATER)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Emissions to soil");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.EMISSION_TO_SOIL)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Final waste flows");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.FINAL_WASTE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Non material emissions");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.NON_MATERIAL_EMISSIONS)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Social issues");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.SOCIAL_ISSUE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Economic issues");
        for (SPFlow sPFlow : wasteTreatment.getElementaryFlows(ElementaryFlowType.ECONOMIC_ISSUE)) {
            this.writeln(this.getElementaryFlowLine((SPElementaryFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Waste to treatment");
        for (SPFlow sPFlow : wasteTreatment.getWasteToTreatmentFlows()) {
            this.writeln(this.getWasteToTreatmentLine((SPWasteToTreatmentFlow)sPFlow));
        }
        this.writer.newLine();
        this.writeln("Input parameters");
        if (wasteTreatment.getInputParameters() != null && wasteTreatment.getInputParameters().length > 0) {
            for (SPInputParameter sPInputParameter : wasteTreatment.getInputParameters()) {
                this.writeInputParameter(sPInputParameter);
            }
        } else {
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writeln("End");
        this.writer.newLine();
        this.writeln("Calculated parameters");
        if (wasteTreatment.getCalculatedParameters() != null && wasteTreatment.getCalculatedParameters().length > 0) {
            for (SPCalculatedParameter sPCalculatedParameter : wasteTreatment.getCalculatedParameters()) {
                this.writeCalculatedParameter(sPCalculatedParameter);
            }
        } else {
            this.writer.newLine();
        }
        this.writer.newLine();
        this.writeln("End");
        this.writer.newLine();
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void write(File directory, SPDataSet dataSet) throws IOException {
        this.write(directory, dataSet, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public void write(File directory, SPDataSet dataSet, boolean splitGivenDatasets, boolean writeGeneralData) throws IOException {
        boolean writeHeader = true;
        if (splitGivenDatasets) {
            if (this.writer == null) {
                this.setUp(dataSet.getProject(), directory);
            } else {
                writeHeader = false;
            }
        } else {
            this.setUp(dataSet.getProject(), directory);
        }
        if (writeHeader) {
            this.writeHeader(dataSet.getProject());
        }
        for (SPProcess sPProcess : dataSet.getProcesses()) {
            this.writeProcess(sPProcess);
        }
        for (SPDataEntry sPDataEntry : dataSet.getWasteTreatments()) {
            this.writeWasteTreatment((SPWasteTreatment)sPDataEntry);
        }
        if (writeGeneralData) {
            int n;
            for (SPSystemDescription sPSystemDescription : this.collectSystemDescriptions(dataSet)) {
                this.writeSystemDescription(sPSystemDescription);
            }
            for (SPLiteratureReference sPLiteratureReference : this.collectLiteratureReferences(dataSet)) {
                this.writeLiteratureReference(sPLiteratureReference);
            }
            SPQuantity[] quantities = dataSet.getQuantities();
            if (quantities != null && quantities.length > 0) {
                void var9_22;
                void var9_20;
                this.writeln("Quantities");
                SPQuantity[] sPQuantityArray = quantities;
                n = sPQuantityArray.length;
                boolean bl = false;
                while (var9_20 < n) {
                    SPQuantity sPQuantity = sPQuantityArray[var9_20];
                    this.writeQuantity(sPQuantity);
                    ++var9_20;
                }
                this.writer.newLine();
                this.writeln("End");
                this.writer.newLine();
                this.writeln("Units");
                sPQuantityArray = quantities;
                n = sPQuantityArray.length;
                boolean bl2 = false;
                while (var9_22 < n) {
                    SPQuantity sPQuantity = sPQuantityArray[var9_22];
                    for (SPUnit unit : sPQuantity.getUnits()) {
                        this.writeUnit(sPQuantity, unit);
                    }
                    ++var9_22;
                }
                this.writer.newLine();
                this.writeln("End");
                this.writer.newLine();
            }
            this.writeEntry("Database Input parameters", null);
            this.writeln("End");
            this.writer.newLine();
            this.writeEntry("Database Calculated parameters", null);
            this.writeln("End");
            this.writer.newLine();
            this.writeln("Project Input parameters");
            if (dataSet.getInputParameters() != null && dataSet.getInputParameters().length > 0) {
                void var9_24;
                SPInputParameter[] sPInputParameterArray = dataSet.getInputParameters();
                n = sPInputParameterArray.length;
                boolean bl = false;
                while (var9_24 < n) {
                    SPInputParameter sPInputParameter = sPInputParameterArray[var9_24];
                    this.writeInputParameter(sPInputParameter);
                    ++var9_24;
                }
            } else {
                this.writer.newLine();
            }
            this.writeln("End");
            this.writer.newLine();
            this.writeln("Project Calculated parameters");
            if (dataSet.getCalculatedParameters() != null && dataSet.getCalculatedParameters().length > 0) {
                void var9_26;
                SPCalculatedParameter[] sPCalculatedParameterArray = dataSet.getCalculatedParameters();
                n = sPCalculatedParameterArray.length;
                boolean bl = false;
                while (var9_26 < n) {
                    SPCalculatedParameter sPCalculatedParameter = sPCalculatedParameterArray[var9_26];
                    this.writeCalculatedParameter(sPCalculatedParameter);
                    ++var9_26;
                }
            } else {
                this.writer.newLine();
            }
            this.writeln("End");
            this.writer.newLine();
            this.tearDown();
        }
    }
}

