/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv.model;

import com.greendeltatc.simapro.csv.model.SPCalculatedParameter;
import com.greendeltatc.simapro.csv.model.SPDocumentation;
import com.greendeltatc.simapro.csv.model.SPElementaryFlow;
import com.greendeltatc.simapro.csv.model.SPInputParameter;
import com.greendeltatc.simapro.csv.model.SPProductFlow;
import com.greendeltatc.simapro.csv.model.SPWasteToTreatmentFlow;
import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.ProductFlowType;
import java.util.ArrayList;
import java.util.List;

public abstract class SPDataEntry {
    private List<SPCalculatedParameter> calculatedParameters = new ArrayList<SPCalculatedParameter>();
    private List<SPInputParameter> inputParameters = new ArrayList<SPInputParameter>();
    private SPDocumentation documentation;
    private List<SPElementaryFlow> elementaryFlows = new ArrayList<SPElementaryFlow>();
    private List<SPProductFlow> productFlows = new ArrayList<SPProductFlow>();
    private List<SPWasteToTreatmentFlow> wasteToTreatmentFlows = new ArrayList<SPWasteToTreatmentFlow>();
    private String subCategory;

    public void add(SPCalculatedParameter parameter) {
        this.calculatedParameters.add(parameter);
    }

    public void add(SPInputParameter parameter) {
        this.inputParameters.add(parameter);
    }

    public void add(SPElementaryFlow flow) {
        this.elementaryFlows.add(flow);
    }

    public void add(SPProductFlow flow) {
        this.productFlows.add(flow);
    }

    public void add(SPWasteToTreatmentFlow flow) {
        this.wasteToTreatmentFlows.add(flow);
    }

    public SPCalculatedParameter[] getCalculatedParameters() {
        return this.calculatedParameters.toArray(new SPCalculatedParameter[this.calculatedParameters.size()]);
    }

    public SPDocumentation getDocumentation() {
        return this.documentation;
    }

    public SPElementaryFlow[] getElementaryFlows(ElementaryFlowType type) {
        ArrayList<SPElementaryFlow> elementaryFlows = new ArrayList<SPElementaryFlow>();
        for (SPElementaryFlow flow : this.elementaryFlows) {
            if (flow.getType() != type) continue;
            elementaryFlows.add(flow);
        }
        return elementaryFlows.toArray(new SPElementaryFlow[elementaryFlows.size()]);
    }

    public SPInputParameter[] getInputParameters() {
        return this.inputParameters.toArray(new SPInputParameter[this.inputParameters.size()]);
    }

    public SPProductFlow[] getProductFlows(ProductFlowType type) {
        ArrayList<SPProductFlow> productFlows = new ArrayList<SPProductFlow>();
        for (SPProductFlow flow : this.productFlows) {
            if (flow.getType() != type) continue;
            productFlows.add(flow);
        }
        return productFlows.toArray(new SPProductFlow[productFlows.size()]);
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setDocumentation(SPDocumentation documentation) {
        this.documentation = documentation;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public SPProductFlow[] getProductFlows() {
        return this.productFlows.toArray(new SPProductFlow[this.productFlows.size()]);
    }

    public SPElementaryFlow[] getElementaryFlows() {
        return this.elementaryFlows.toArray(new SPElementaryFlow[this.elementaryFlows.size()]);
    }

    public SPWasteToTreatmentFlow[] getWasteToTreatmentFlows() {
        return this.wasteToTreatmentFlows.toArray(new SPWasteToTreatmentFlow[this.wasteToTreatmentFlows.size()]);
    }

    public boolean containsInputParameter(String name) {
        boolean result = false;
        for (SPInputParameter parameter : this.inputParameters) {
            if (!parameter.getName().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }
}

