/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv.model;

import com.greendeltatc.simapro.csv.model.pedigreetypes.Completeness;
import com.greendeltatc.simapro.csv.model.pedigreetypes.FurtherTechnologicalCorrelation;
import com.greendeltatc.simapro.csv.model.pedigreetypes.GeographicalCorrelation;
import com.greendeltatc.simapro.csv.model.pedigreetypes.Reliability;
import com.greendeltatc.simapro.csv.model.pedigreetypes.SampleSize;
import com.greendeltatc.simapro.csv.model.pedigreetypes.TemporalCorrelation;
import java.util.HashSet;
import java.util.Set;

public class SPPedigreeMatrix {
    private static Set<String> pedigreeContain = new HashSet<String>();
    public Reliability reliability = Reliability.NA;
    public Completeness completeness = Completeness.NA;
    public TemporalCorrelation temporalCorrelation = TemporalCorrelation.NA;
    public GeographicalCorrelation geographicalCorrelation = GeographicalCorrelation.NA;
    public FurtherTechnologicalCorrelation furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.NA;
    public SampleSize sampleSize = SampleSize.NA;

    public SPPedigreeMatrix() {
        pedigreeContain.add("1");
        pedigreeContain.add("2");
        pedigreeContain.add("3");
        pedigreeContain.add("4");
        pedigreeContain.add("5");
    }

    public String getPedigreeCommentString() {
        String matrix = null;
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.reliability.getKey());
        builder.append(",");
        builder.append(this.completeness.getKey());
        builder.append(",");
        builder.append(this.temporalCorrelation.getKey());
        builder.append(",");
        builder.append(this.geographicalCorrelation.getKey());
        builder.append(",");
        builder.append(this.furtherTechnologicalCorrelation.getKey());
        builder.append(",");
        builder.append(this.sampleSize.getKey());
        builder.append(")");
        matrix = builder.toString();
        return matrix;
    }

    public double getCalculatedUncertainty() {
        double u1 = Math.pow(Math.log(this.reliability.getIndicator()), 2.0);
        double u2 = Math.pow(Math.log(this.completeness.getIndicator()), 2.0);
        double u3 = Math.pow(Math.log(this.temporalCorrelation.getIndicator()), 2.0);
        double u4 = Math.pow(Math.log(this.geographicalCorrelation.getIndicator()), 2.0);
        double u5 = Math.pow(Math.log(this.furtherTechnologicalCorrelation.getIndicator()), 2.0);
        double u6 = Math.pow(Math.log(this.sampleSize.getIndicator()), 2.0);
        double ub = Math.pow(Math.log(1.05), 2.0);
        return Math.exp(Math.sqrt(u1 + u2 + u3 + u4 + u5 + u6 + ub));
    }

    public void setCompleteness(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.completeness = Completeness.ONE;
                    break;
                }
                case 2: {
                    this.completeness = Completeness.TWO;
                    break;
                }
                case 3: {
                    this.completeness = Completeness.THREE;
                    break;
                }
                case 4: {
                    this.completeness = Completeness.FOUR;
                    break;
                }
                case 5: {
                    this.completeness = Completeness.FIVE;
                }
            }
        } else {
            this.completeness = Completeness.NA;
        }
    }

    public void setFurtherTechnologicalCorrelation(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.ONE;
                    break;
                }
                case 2: {
                    this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.TWO;
                    break;
                }
                case 3: {
                    this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.THREE;
                    break;
                }
                case 4: {
                    this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.FOUR;
                    break;
                }
                case 5: {
                    this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.FIVE;
                }
            }
        } else {
            this.furtherTechnologicalCorrelation = FurtherTechnologicalCorrelation.NA;
        }
    }

    public void setGeographicalCorrelation(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.geographicalCorrelation = GeographicalCorrelation.ONE;
                    break;
                }
                case 2: {
                    this.geographicalCorrelation = GeographicalCorrelation.TWO;
                    break;
                }
                case 3: {
                    this.geographicalCorrelation = GeographicalCorrelation.THREE;
                    break;
                }
                case 4: {
                    this.geographicalCorrelation = GeographicalCorrelation.FOUR;
                    break;
                }
                case 5: {
                    this.geographicalCorrelation = GeographicalCorrelation.FIVE;
                }
            }
        } else {
            this.geographicalCorrelation = GeographicalCorrelation.NA;
        }
    }

    public void setReliability(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.reliability = Reliability.ONE;
                    break;
                }
                case 2: {
                    this.reliability = Reliability.TWO;
                    break;
                }
                case 3: {
                    this.reliability = Reliability.THREE;
                    break;
                }
                case 4: {
                    this.reliability = Reliability.FOUR;
                    break;
                }
                case 5: {
                    this.reliability = Reliability.FIVE;
                }
            }
        } else {
            this.reliability = Reliability.NA;
        }
    }

    public void setSampleSize(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.sampleSize = SampleSize.ONE;
                    break;
                }
                case 2: {
                    this.sampleSize = SampleSize.TWO;
                    break;
                }
                case 3: {
                    this.sampleSize = SampleSize.THREE;
                    break;
                }
                case 4: {
                    this.sampleSize = SampleSize.FOUR;
                    break;
                }
                case 5: {
                    this.sampleSize = SampleSize.FIVE;
                }
            }
        } else {
            this.sampleSize = SampleSize.NA;
        }
    }

    public void setTemporalCorrelation(String pedigree) {
        if (pedigreeContain.contains(pedigree)) {
            switch (Integer.parseInt(pedigree)) {
                case 1: {
                    this.temporalCorrelation = TemporalCorrelation.ONE;
                    break;
                }
                case 2: {
                    this.temporalCorrelation = TemporalCorrelation.TWO;
                    break;
                }
                case 3: {
                    this.temporalCorrelation = TemporalCorrelation.THREE;
                    break;
                }
                case 4: {
                    this.temporalCorrelation = TemporalCorrelation.FOUR;
                    break;
                }
                case 5: {
                    this.temporalCorrelation = TemporalCorrelation.FIVE;
                }
            }
        } else {
            this.temporalCorrelation = TemporalCorrelation.NA;
        }
    }
}

