/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv.model.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum Geography {
    AFRICA("Africa", "35d21e4a-ab38-493b-8d96-89f73064b0d5"),
    ARCTIC_REGIONS("Arctic regions", "06f138a4-9920-4b13-adc9-3db56ca686e1"),
    ASIA_CHINA("Asia, China", "4346af8b-8bed-40b8-a69d-9d9e24002a81"),
    ASIA_FORMER_USSR("Asia, former USSR", "f7896ba6-83a5-4d31-8152-0b253499cdde"),
    ASIA_INDIAN_REGION("Asia, Indian region", "6baa27e6-9da6-4de9-ac9e-3c37e2472a7e"),
    ASIA_JAPAN("Asia, Japan", "1bf2eb37-2aac-401c-b164-bd96643f02d7"),
    ASIA_KOREA("Asia, Korea", "70e76b8d-70a4-4959-b8ea-8a737ea1c905"),
    ASIA_MIDDLE_EAST("Asia, Middle East", "d6a74e32-e22a-44fa-b156-d3e7bb7e7b3b"),
    ASIA_SOUTH_EAST("Asia, South East", "ecc709b1-3130-468f-ac0f-128033248ca4"),
    AUSTRALIA("Australia", "e8905d7b-a59b-4ac7-a16e-3201e2a64732"),
    EUROPE_EASTERN("Europe, Eastern", "ef36ca76-6f88-4876-aad2-b4b302ad4956"),
    EUROPE_WESTERN("Europe, Western", "e246ae90-8288-4cde-bdfb-191ec366230e"),
    MIXED_DATA("Mixed data", "759da9a8-bd50-4603-8794-47c1d042b0ee"),
    NORTH_AMERICA("North America", "44511364-d30f-4036-a7d9-693fb9f272c1"),
    OCEANS("Oceans", "2564cdde-42d1-4a04-a0b0-f5fadc7660f6"),
    SOUTH_AND_CENTRAL_AMERICA("South and Central America", "907d890a-626f-4bb3-9ca9-7ba481f34572"),
    UNKNOWN("Unknown", "abffdf35-818d-4232-b78b-3c6bdcd1acfa"),
    UNSPECIFIED("Unspecified", "661e052f-80e3-4502-b6cc-7f82c89391a4"),
    WORLD("World", "369e2806-4727-4d60-bd13-6e8df7ce8984");

    private String value;
    private String es2Id;
    private static final Map<String, Geography> instances;

    private Geography(String value, String es2Id) {
        this.value = value;
        this.es2Id = es2Id;
    }

    public String getValue() {
        return this.value;
    }

    public String getES2Id() {
        return this.es2Id;
    }

    public static Geography forValue(String value) {
        Geography geography = null;
        int i = 0;
        while (geography == null && i < Geography.values().length) {
            if (Geography.values()[i].getValue().equals(value)) {
                geography = Geography.values()[i];
                continue;
            }
            ++i;
        }
        return geography;
    }

    public static Map<String, Geography> getInstances() {
        return instances;
    }

    static {
        HashMap<String, Geography> lInstances = new HashMap<String, Geography>();
        for (Geography eft : Geography.values()) {
            lInstances.put(eft.value, eft);
        }
        instances = Collections.unmodifiableMap(lInstances);
    }
}

