/*
 * Decompiled with CFR 0.152.
 */
package com.greendeltatc.simapro.csv.model.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum SubCompartment {
    AIRBORNE_HIGH_POP("high. pop."),
    AIRBORNE_INDOOR("indoor"),
    AIRBORNE_LOW_POP("low. pop."),
    AIRBORNE_LOW_POP_LONG_TERM("low. pop., long-term"),
    AIRBORNE_STATOSPHERE("stratosphere"),
    AIRBORNE_STATOSPHERE_TROPOSHERE("stratosphere + troposhere"),
    RAW_MATERIAL_BIOTIC("biotic"),
    RAW_MATERIAL_IN_AIR("in air"),
    RAW_MATERIAL_IN_GROUND("in ground"),
    RAW_MATERIAL_IN_WATER("in water"),
    RAW_MATERIAL_LAND("land"),
    SOIL_AGRICULTURAL("agricultural"),
    SOIL_FORESTRY("forestry"),
    SOIL_INDUSTRIAL("industrial"),
    SOIL_URBAN("urban, non industrial"),
    WATERBORNE_FOSSILWATER("fossilwater"),
    WATERBORNE_GROUNDWATER("groundwater"),
    WATERBORNE_GROUNDWATER_LONG_TERM("groundwater, long-term"),
    WATERBORNE_LAKE("lake"),
    WATERBORNE_OCEAN("ocean"),
    WATERBORNE_RIVER("river"),
    WATERBORNE_RIVER_LONG_TERM("river, long-term"),
    UNSPECIFIED("unspecified");

    private String value;
    private static final Map<String, SubCompartment> instances;

    private SubCompartment(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static SubCompartment forValue(String value) {
        SubCompartment compartment = null;
        int i = 0;
        while (compartment == null && i < SubCompartment.values().length) {
            if (SubCompartment.values()[i].getValue().equals(value)) {
                compartment = SubCompartment.values()[i];
                continue;
            }
            ++i;
        }
        return compartment;
    }

    public static Map<String, SubCompartment> getInstances() {
        return instances;
    }

    static {
        HashMap<String, SubCompartment> lInstances = new HashMap<String, SubCompartment>();
        for (SubCompartment eft : SubCompartment.values()) {
            lInstances.put(eft.value, eft);
        }
        instances = Collections.unmodifiableMap(lInstances);
    }
}

