/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import java.util.ArrayList;
import org.openlca.expressions.Expression;
import org.openlca.expressions.ExpressionException;

public abstract class AbstractExpression
implements Expression {
    protected ArrayList<Expression> arguments = new ArrayList(3);
    protected int line;
    protected int column;

    @Override
    public void addArgument(Expression expression) {
        this.arguments.add(expression);
    }

    @Override
    public void addArgument(int index, Expression expression) {
        this.arguments.add(index, expression);
    }

    @Override
    public void setPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void check() throws ExpressionException {
    }

    protected void checkArguments(Class<?>[] types) throws ExpressionException {
        if (this.arguments.size() != types.length) {
            throw new ExpressionException(String.valueOf(this.getName()) + " requires " + types.length + " argument(s)", this.getLine(), this.getColumn());
        }
        int i = 0;
        while (i < types.length) {
            this.checkArgument(i, types[i]);
            ++i;
        }
    }

    protected void checkArgument(int position, Class<?> clazz) throws ExpressionException {
        Class<?> resultClass = this.arguments.get(position).getResultType();
        if (resultClass != null && !clazz.isAssignableFrom(resultClass)) {
            throw new ExpressionException("Argument " + position + " of " + this.getName() + " is of an incorrect type", this.getLine(), this.getColumn());
        }
    }

    protected void checkNoArguments() throws ExpressionException {
        if (this.arguments.size() > 0) {
            throw new ExpressionException(String.valueOf(this.getName()) + " takes no parameters", this.getLine(), this.getColumn());
        }
    }

    protected void checkArgumentsOfSameType(Class<?> clazz) throws ExpressionException {
        int i = 0;
        while (i < this.arguments.size()) {
            Expression expression = this.arguments.get(i);
            if (expression.getResultType() != null && !clazz.isAssignableFrom(expression.getResultType())) {
                throw new ExpressionException("Argument " + i + " of " + this.getName() + " is of an incorrect type", this.getLine(), this.getColumn());
            }
            ++i;
        }
    }
}

