/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openlca.expressions.AbstractComparisonExpression;
import org.openlca.expressions.DecimalConstantFunction;
import org.openlca.expressions.Expression;
import org.openlca.expressions.FormulaParserConstants;
import org.openlca.expressions.FormulaParserTokenManager;
import org.openlca.expressions.OpAddition;
import org.openlca.expressions.OpAnd;
import org.openlca.expressions.OpDivision;
import org.openlca.expressions.OpEqual;
import org.openlca.expressions.OpExponentiation;
import org.openlca.expressions.OpGreaterThan;
import org.openlca.expressions.OpGreaterThanOrEqual;
import org.openlca.expressions.OpIntegerDivision;
import org.openlca.expressions.OpLessThan;
import org.openlca.expressions.OpLessThanOrEqual;
import org.openlca.expressions.OpModuloDivision;
import org.openlca.expressions.OpMultiplication;
import org.openlca.expressions.OpNotEqual;
import org.openlca.expressions.OpOr;
import org.openlca.expressions.OpSubstraction;
import org.openlca.expressions.OpUnaryMinus;
import org.openlca.expressions.OpXor;
import org.openlca.expressions.ParseException;
import org.openlca.expressions.SimpleCharStream;
import org.openlca.expressions.Token;
import org.openlca.expressions.VariableFunction;
import org.openlca.expressions.functions.FunctionFactory;

public class FormulaParser
implements FormulaParserConstants {
    protected Stack<Expression> argStack = new Stack();
    protected FunctionFactory functionFactory = FunctionFactory.getInstance();
    protected List<VariableFunction> variables = new ArrayList<VariableFunction>();
    public FormulaParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        FormulaParser.jj_la1_init_0();
    }

    public Expression getExpression() {
        return this.argStack.pop();
    }

    public List<VariableFunction> getVariables() {
        return this.variables;
    }

    public FormulaParser(Reader reader, FunctionFactory functionFactory) {
        this(reader);
        this.functionFactory = functionFactory;
    }

    private void combineBinary(Token x, Expression f) {
        Expression a = this.argStack.pop();
        Expression b = this.argStack.pop();
        f.addArgument(b);
        f.addArgument(a);
        f.setPosition(x.beginLine, x.beginColumn);
        this.argStack.push(f);
    }

    public final void parse() throws ParseException {
        this.expand();
        this.jj_consume_token(0);
    }

    public final void expand() throws ParseException {
        this.logicalOr();
    }

    public final void logicalOr() throws ParseException {
        this.logicalXor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            Token x = this.jj_consume_token(7);
            this.logicalXor();
            this.combineBinary(x, new OpOr());
        }
    }

    public final void logicalXor() throws ParseException {
        this.logicalAnd();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            Token x = this.jj_consume_token(21);
            this.logicalAnd();
            this.combineBinary(x, new OpXor());
        }
    }

    public final void logicalAnd() throws ParseException {
        this.compare();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            Token x = this.jj_consume_token(6);
            this.compare();
            this.combineBinary(x, new OpAnd());
        }
    }

    public final void compare() throws ParseException {
        this.realsum();
        block11: while (true) {
            Token x;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    x = this.jj_consume_token(13);
                    break;
                }
                case 14: {
                    x = this.jj_consume_token(14);
                    break;
                }
                case 15: {
                    x = this.jj_consume_token(15);
                    break;
                }
                case 16: {
                    x = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    x = this.jj_consume_token(17);
                    break;
                }
                case 18: {
                    x = this.jj_consume_token(18);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.realsum();
            AbstractComparisonExpression func = null;
            if (x.kind == 13) {
                func = new OpLessThan();
            } else if (x.kind == 14) {
                func = new OpLessThanOrEqual();
            } else if (x.kind == 15) {
                func = new OpEqual();
            } else if (x.kind == 16) {
                func = new OpNotEqual();
            } else if (x.kind == 17) {
                func = new OpGreaterThan();
            } else if (x.kind == 18) {
                func = new OpGreaterThanOrEqual();
            } else {
                throw new ParseException("Unexpected token kind: " + x.kind);
            }
            this.combineBinary(x, func);
        }
    }

    public final void realsum() throws ParseException {
        this.term();
        block7: while (true) {
            Token x;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    x = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    x = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.term();
            if (x.kind == 8) {
                this.combineBinary(x, new OpAddition());
                continue;
            }
            this.combineBinary(x, new OpSubstraction());
        }
    }

    public final void term() throws ParseException {
        this.power();
        block9: while (true) {
            Token x;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 12: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    x = this.jj_consume_token(10);
                    break;
                }
                case 11: {
                    x = this.jj_consume_token(11);
                    break;
                }
                case 12: {
                    x = this.jj_consume_token(12);
                    break;
                }
                case 20: {
                    x = this.jj_consume_token(20);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.power();
            if (x.kind == 10) {
                this.combineBinary(x, new OpMultiplication());
                continue;
            }
            if (x.kind == 12) {
                this.combineBinary(x, new OpIntegerDivision());
                continue;
            }
            if (x.kind == 11) {
                this.combineBinary(x, new OpDivision());
                continue;
            }
            if (x.kind != 20) continue;
            this.combineBinary(x, new OpModuloDivision());
        }
    }

    public final void power() throws ParseException {
        this.unary();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            Token x = this.jj_consume_token(19);
            this.unary();
            this.combineBinary(x, new OpExponentiation());
        }
    }

    public final void unary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: {
                Token x;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        x = this.jj_consume_token(9);
                        break;
                    }
                    case 8: {
                        x = this.jj_consume_token(8);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.element();
                if (x.kind != 9) break;
                Expression a = this.argStack.pop();
                OpUnaryMinus negateFunction = new OpUnaryMinus();
                negateFunction.addArgument(a);
                negateFunction.setPosition(x.beginLine, x.beginColumn);
                this.argStack.push(negateFunction);
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                this.element();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void element() throws ParseException {
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                Double value;
                this.jj_consume_token(25);
                try {
                    value = new Double(this.token.image);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Invalid number: " + this.token.image);
                }
                DecimalConstantFunction func = new DecimalConstantFunction(value);
                func.setPosition(this.token.beginLine, this.token.beginColumn);
                this.argStack.push(func);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                if (this.jj_2_1(2)) {
                    this.function();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        VariableFunction variableFunction = new VariableFunction(this.token.image);
                        variableFunction.setPosition(this.token.beginLine, this.token.beginColumn);
                        this.argStack.push(variableFunction);
                        this.variables.add(variableFunction);
                        break block1;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        this.expand();
                        this.jj_consume_token(30);
                        break block1;
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void function() throws ParseException {
        Expression function;
        int paramCount = 0;
        this.jj_consume_token(28);
        String functionName = this.token.image;
        this.jj_consume_token(29);
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 25: 
            case 28: 
            case 29: {
                this.expand();
                ++paramCount;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block1;
                        }
                    }
                    this.jj_consume_token(31);
                    this.expand();
                    ++paramCount;
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(30);
        try {
            function = this.functionFactory.createFunction(functionName);
        }
        catch (Exception e) {
            throw new ParseException("Problem with function '" + functionName + "': " + e.toString());
        }
        if (function == null) {
            throw new ParseException("Nonexisting function name '" + functionName + "'");
        }
        int i = 0;
        while (i < paramCount) {
            Expression arg = this.argStack.pop();
            function.addArgument(0, arg);
            ++i;
        }
        this.argStack.push(function);
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3_1() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_9() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(29);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{128, 0x200000, 64, 516096, 516096, 768, 768, 0x101C00, 0x101C00, 524288, 768, 0x32000300, 0x2000000, 0x30000000, Integer.MIN_VALUE, 0x32000300};
    }

    public FormulaParser(InputStream stream) {
        this(stream, null);
    }

    public FormulaParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public FormulaParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public FormulaParser(FormulaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(FormulaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 16) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) continue block1;
                    ++i2;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 16) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

