/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import org.openlca.expressions.Expression;
import org.openlca.expressions.ExpressionException;
import org.openlca.expressions.Scope;

public class VariableFunction
implements Expression {
    protected String variableName;
    protected String position;
    protected int line;
    protected int column;

    public VariableFunction(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public void addArgument(Expression function) {
        throw new RuntimeException("Cannot add an argument to a variable");
    }

    @Override
    public void addArgument(int index, Expression expression) {
        throw new RuntimeException("Cannot add an argument to a variable");
    }

    @Override
    public Object evaluate(Scope context) throws ExpressionException {
        Object object = context.resolveVariable(this.variableName);
        if (object == null) {
            throw new ExpressionException("Unknown variable " + this.variableName, this.getLine(), this.getColumn());
        }
        return object;
    }

    @Override
    public void check() throws ExpressionException {
    }

    @Override
    public Class<?> getResultType() {
        return null;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public void setPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public String getName() {
        return "Variable";
    }
}

