/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions.functions;

import java.util.HashMap;
import org.openlca.expressions.Expression;
import org.openlca.expressions.OpExponentiation;
import org.openlca.expressions.functions.Abs;
import org.openlca.expressions.functions.Acos;
import org.openlca.expressions.functions.And;
import org.openlca.expressions.functions.Asin;
import org.openlca.expressions.functions.Atan;
import org.openlca.expressions.functions.Avg;
import org.openlca.expressions.functions.Ceil;
import org.openlca.expressions.functions.Cos;
import org.openlca.expressions.functions.Cosh;
import org.openlca.expressions.functions.Cotan;
import org.openlca.expressions.functions.E;
import org.openlca.expressions.functions.Exp;
import org.openlca.expressions.functions.False;
import org.openlca.expressions.functions.Floor;
import org.openlca.expressions.functions.Frac;
import org.openlca.expressions.functions.IPow;
import org.openlca.expressions.functions.If;
import org.openlca.expressions.functions.Int;
import org.openlca.expressions.functions.Ln;
import org.openlca.expressions.functions.Log;
import org.openlca.expressions.functions.Max;
import org.openlca.expressions.functions.Min;
import org.openlca.expressions.functions.Not;
import org.openlca.expressions.functions.Or;
import org.openlca.expressions.functions.Pi;
import org.openlca.expressions.functions.Random;
import org.openlca.expressions.functions.Round;
import org.openlca.expressions.functions.Sin;
import org.openlca.expressions.functions.Sinh;
import org.openlca.expressions.functions.Sqr;
import org.openlca.expressions.functions.Sqrt;
import org.openlca.expressions.functions.Sum;
import org.openlca.expressions.functions.Tan;
import org.openlca.expressions.functions.Tanh;
import org.openlca.expressions.functions.True;

public class FunctionFactory {
    protected static FunctionFactory instance = new FunctionFactory();
    protected HashMap<String, Class<? extends Expression>> functions = new HashMap();

    public static FunctionFactory getInstance() {
        return instance;
    }

    public FunctionFactory() {
        this.registerFunction("pi", Pi.class);
        this.registerFunction("e", E.class);
        this.registerFunction("true", True.class);
        this.registerFunction("false", False.class);
        this.registerFunction("abs", Abs.class);
        this.registerFunction("avg", Avg.class);
        this.registerFunction("mean", Avg.class);
        this.registerFunction("ceil", Ceil.class);
        this.registerFunction("floor", Floor.class);
        this.registerFunction("frac", Frac.class);
        this.registerFunction("int", Int.class);
        this.registerFunction("min", Min.class);
        this.registerFunction("max", Max.class);
        this.registerFunction("round", Round.class);
        this.registerFunction("trunc", Int.class);
        this.registerFunction("sqr", Sqr.class);
        this.registerFunction("sqrt", Sqrt.class);
        this.registerFunction("sum", Sum.class);
        this.registerFunction("random", Random.class);
        this.registerFunction("rand", Random.class);
        this.registerFunction("exp", Exp.class);
        this.registerFunction("ipower", IPow.class);
        this.registerFunction("ln", Ln.class);
        this.registerFunction("log", Log.class);
        this.registerFunction("lg", Log.class);
        this.registerFunction("power", OpExponentiation.class);
        this.registerFunction("pow", OpExponentiation.class);
        this.registerFunction("acos", Acos.class);
        this.registerFunction("arccos", Acos.class);
        this.registerFunction("asin", Asin.class);
        this.registerFunction("arcsin", Asin.class);
        this.registerFunction("atan", Atan.class);
        this.registerFunction("arctan", Atan.class);
        this.registerFunction("cos", Cos.class);
        this.registerFunction("cosh", Cosh.class);
        this.registerFunction("cotan", Cotan.class);
        this.registerFunction("cot", Cotan.class);
        this.registerFunction("sin", Sin.class);
        this.registerFunction("sinh", Sinh.class);
        this.registerFunction("tan", Tan.class);
        this.registerFunction("tanh", Tanh.class);
        this.registerFunction("not", Not.class);
        this.registerFunction("if", If.class);
        this.registerFunction("iff", If.class);
        this.registerFunction("iif", If.class);
        this.registerFunction("and", And.class);
        this.registerFunction("or", Or.class);
    }

    public void registerFunction(String name, Class<? extends Expression> clazz) {
        if (!Expression.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Tried to register an expression which does not implement the Expression inteface");
        }
        this.functions.put(name, clazz);
    }

    public Expression createFunction(String name) throws Exception {
        Class<? extends Expression> clazz = this.functions.get(name);
        if (clazz == null) {
            return null;
        }
        return clazz.newInstance();
    }
}

