/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class ResourceFolder {
    protected File rootDir;

    public ResourceFolder(File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException("The root directory cannot be NULL.");
        }
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("The given root directory is NOT a directory.");
        }
        this.rootDir = rootDir;
    }

    public File getIndexFile() {
        return new File(this.rootDir, "index.html");
    }

    public File getLogFile() {
        return new File(this.rootDir, "log.html");
    }

    public File getValidationLog() {
        return new File(this.rootDir, "validation.html");
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public abstract void createContent();

    public List<File> listFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.rootDir != null && this.rootDir.exists() && this.rootDir.isDirectory()) {
            LinkedList<File> queue = new LinkedList<File>();
            queue.add(this.rootDir);
            while (!queue.isEmpty()) {
                for (File f : ((File)queue.poll()).listFiles()) {
                    if (f.isDirectory()) {
                        queue.add(f);
                        continue;
                    }
                    files.add(f);
                }
            }
        }
        return files;
    }

    protected void extract(String subPackage, File targetFolder) {
        try {
            if (!targetFolder.exists()) {
                targetFolder.mkdir();
            }
            InputStream idxIS = this.getClass().getResourceAsStream(subPackage + "/index.xml");
            SAXBuilder builder = new SAXBuilder();
            Document index = builder.build(idxIS);
            for (Object o : index.getRootElement().getChildren("file")) {
                Element fileElement = (Element)o;
                String fileName = fileElement.getTextNormalize();
                File targetFile = new File(targetFolder, fileName);
                if (targetFile.exists()) continue;
                BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(subPackage + "/" + fileName));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                int b = -1;
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

