/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.Conversion;
import org.openlca.olcatdb.conversion.FileIndex;
import org.openlca.olcatdb.conversion.LogHtmlFormatter;
import org.openlca.olcatdb.conversion.Monitor;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDFlowProperty;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.ilcd.ILCDUnitGroup;
import org.openlca.olcatdb.parsing.XmlContextParser;

public abstract class AbstractConversionImpl
implements Conversion,
Iterator<InputStream> {
    public String monitorProgressText = "Convert";
    protected Logger logger = Logger.getLogger("org.openlca.olcatdb.conversion");
    protected FileIndex createdFiles = new FileIndex();
    protected File sourceXml = null;
    private File nextFile = null;
    protected ZipFile sourceZip = null;
    private Enumeration<? extends ZipEntry> zipEntries = null;
    private ZipEntry nextEntry = null;
    private HashMap<String, Object> objectCache = new HashMap();
    private Logs logs;
    private Timer timer;
    private FileHandler logFile;
    protected File targetDir;
    protected Monitor monitor;
    private int worked = 0;
    protected boolean canceled = false;

    public String getCurrentFileName() {
        String fileName = null;
        if (this.nextFile != null) {
            fileName = this.nextFile.getName();
        } else if (this.nextEntry != null) {
            fileName = this.nextEntry.getName();
        }
        return fileName;
    }

    @Override
    public void setSourceFile(File sourceFile) {
        if (sourceFile != null) {
            String name = sourceFile.getName().toLowerCase();
            if (name.endsWith(".xml") || name.endsWith(".spold")) {
                this.sourceXml = sourceFile;
                this.nextFile = sourceFile;
            } else if (name.endsWith(".zip")) {
                try {
                    this.sourceZip = new ZipFile(sourceFile);
                    this.zipEntries = this.sourceZip.entries();
                    this.pointNextEntry();
                }
                catch (Exception e) {
                    this.logger.severe("Cannot open the source ZIP: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    @Override
    public boolean hasNext() {
        return !this.canceled && (this.nextFile != null || this.nextEntry != null);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream next() {
        InputStream is = null;
        String next = "";
        if (this.nextFile == null && this.nextEntry == null) {
            this.logger.severe("No source XML file or ZIP entry could be loaded.");
        } else if (this.nextFile != null) {
            next = this.nextFile.getName();
            try {
                is = new FileInputStream(this.nextFile);
            }
            catch (Exception e) {
                this.logger.severe("Cannot load XML file: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.nextFile = null;
            }
        } else {
            try {
                next = this.nextEntry.getName();
                is = this.sourceZip.getInputStream(this.nextEntry);
            }
            catch (Exception e) {
                this.logger.severe("Cannot load ZIP entry: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.pointNextEntry();
            }
        }
        if (this.monitor != null && is != null) {
            this.monitor.progress(this.monitorProgressText + " " + next, ++this.worked);
        }
        return is;
    }

    @Override
    public void remove() {
    }

    protected void createFolder(File targetDir) {
        this.timer = new Timer();
        this.timer.start();
        this.logs = new Logs();
        this.logger.addHandler(this.logs);
        if (this.monitor != null) {
            this.monitor.begin(this.estimateEffort());
            if (this.sourceXml != null) {
                this.monitor.progress("Setup conversion", 0);
            }
        }
    }

    protected void logFile(ResourceFolder folder) {
        try {
            File file = folder.getLogFile();
            this.logFile = new FileHandler(file.getAbsolutePath());
            this.logFile.setFormatter(new LogHtmlFormatter());
            this.logger.addHandler(this.logFile);
        }
        catch (Exception e) {
            this.logger.severe("Cannot create log file: " + e.getMessage());
        }
    }

    protected boolean matchEntry(String entryName) {
        return entryName != null && (entryName.toLowerCase().endsWith(".xml") || entryName.toLowerCase().endsWith(".spold"));
    }

    protected Object fetch(DataSetReference ref) {
        if (ref == null) {
            this.logger.severe("Fetch on NULL reference.");
            return null;
        }
        String uri = ref.getUri();
        if (uri == null) {
            this.logger.severe("No URI in data set reference.");
            return null;
        }
        Object o = this.objectCache.get(uri);
        if (o != null) {
            return o;
        }
        String refTypeStr = ref.getType();
        if (refTypeStr == null) {
            this.logger.severe("There is no data set type given in reference to file " + uri);
            return null;
        }
        ILCDDataSetType refType = ILCDDataSetType.forName(refTypeStr);
        if (refType == null) {
            this.logger.severe("There is no data set type for name '" + refTypeStr + "'.");
            return null;
        }
        Class contextClass = null;
        String folder = null;
        switch (refType) {
            case Contact: {
                contextClass = ILCDContact.class;
                folder = "contacts";
                break;
            }
            case Flow: {
                contextClass = ILCDFlow.class;
                folder = "flows";
                break;
            }
            case Source: {
                contextClass = ILCDSource.class;
                folder = "sources";
                break;
            }
            case FlowProperty: {
                contextClass = ILCDFlowProperty.class;
                folder = "flowproperties";
                break;
            }
            case UnitGroup: {
                contextClass = ILCDUnitGroup.class;
                folder = "unitgroups";
                break;
            }
        }
        if (contextClass == null) {
            this.logger.severe("No context call available for type '" + refTypeStr + "'");
            return null;
        }
        String refId = ref.getRefObjectId();
        if (refId == null) {
            this.logger.severe("No reference object ID given in reference to file '" + uri + "'");
            return null;
        }
        ILCDContact context = null;
        if (this.sourceXml != null) {
            File file = new File(this.sourceXml.getParentFile(), uri);
            if (!file.exists() || !file.isFile()) {
                this.logger.severe("The referenced file not exists: " + file.getAbsolutePath());
                return null;
            }
            try {
                FileInputStream fis = new FileInputStream(file);
                XmlContextParser parser = new XmlContextParser();
                context = parser.getContext(contextClass, fis);
                this.objectCache.put(uri, context);
            }
            catch (Exception e) {
                this.logger.severe("Cannot parse the referenced file: " + file.getAbsolutePath());
            }
        } else if (this.sourceZip != null) {
            ZipEntry entry = null;
            Enumeration<? extends ZipEntry> entries = this.sourceZip.entries();
            while (entries.hasMoreElements() && entry == null) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                if (zipEntry.isDirectory() || !name.endsWith(".xml") && !name.endsWith(".XML") || !name.contains(folder) || !name.contains(refId)) continue;
                entry = zipEntry;
            }
            if (entry == null) {
                this.logger.severe("Cannot find Zip entry for reference " + uri);
                return null;
            }
            try {
                XmlContextParser parser = new XmlContextParser();
                InputStream is = this.sourceZip.getInputStream(entry);
                context = parser.getContext(contextClass, is);
                this.objectCache.put(uri, context);
            }
            catch (Exception e) {
                this.logger.severe("Cannot parse the referenced Zip entry " + uri);
            }
        }
        if (context == null) {
            this.logger.severe("Cannot load object for reference: " + ref);
        }
        return context;
    }

    protected void flush() {
        ResourceFolder folder = this.getResult();
        if (folder != null) {
            File indexFile;
            if (this.logs != null) {
                this.logger.removeHandler(this.logs);
                this.logs.flush();
                this.logs.close();
                if (this.logs.count > 0 && folder.getLogFile() != null) {
                    this.createdFiles.setLog(folder.getLogFile().toURI().toString());
                }
            }
            if (this.createdFiles != null) {
                String title = Integer.toString(this.createdFiles.getDataSets().size()) + " files created";
                if (this.timer != null) {
                    this.timer.stop();
                    title = title + " (" + this.timer.toString() + ")";
                }
                this.createdFiles.setTitle(title);
            }
            if ((indexFile = folder.getIndexFile()) != null && this.createdFiles != null) {
                try {
                    this.createdFiles.toFile(indexFile);
                }
                catch (Exception e) {
                    this.logger.severe("Cannot create index file: " + e.getMessage());
                }
            }
        }
        if (this.logFile != null) {
            this.logger.removeHandler(this.logFile);
            this.logFile.flush();
            this.logFile.close();
        }
        this.objectCache.clear();
        if (this.sourceZip != null) {
            try {
                this.sourceZip.close();
            }
            catch (Exception e) {
                this.logger.severe("Cannot close ZIP file: " + e.getMessage());
                e.printStackTrace();
            }
            this.sourceZip = null;
        }
        if (this.monitor != null) {
            this.monitor.finished(this);
        }
    }

    private int estimateEffort() {
        int size = 0;
        if (this.sourceXml != null) {
            size = 2;
        } else if (this.sourceZip != null) {
            try {
                Enumeration<? extends ZipEntry> entries = this.sourceZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!this.matchEntry(entry.getName())) continue;
                    ++size;
                }
            }
            catch (Exception e) {
                this.logger.severe(e.getMessage());
            }
        }
        return size;
    }

    private void pointNextEntry() {
        this.nextEntry = null;
        if (this.zipEntries != null) {
            while (this.nextEntry == null && this.zipEntries.hasMoreElements()) {
                String entryName;
                ZipEntry entry = this.zipEntries.nextElement();
                if (entry.isDirectory() || !this.matchEntry(entryName = entry.getName())) continue;
                this.nextEntry = entry;
            }
        }
    }

    private class Timer {
        private long atStart;
        private long atStop;

        private Timer() {
        }

        public void start() {
            this.atStart = new GregorianCalendar().getTimeInMillis();
        }

        public void stop() {
            this.atStop = new GregorianCalendar().getTimeInMillis();
        }

        public String toString() {
            long sec = (this.atStop - this.atStart) / 1000L;
            return Long.toString(sec) + " seconds";
        }
    }

    private class Logs
    extends Handler {
        private int count = 0;

        private Logs() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            ++this.count;
        }
    }
}

