/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import com.greendeltatc.simapro.csv.CSVParser;
import com.greendeltatc.simapro.csv.model.IDistribution;
import com.greendeltatc.simapro.csv.model.SPCalculatedParameter;
import com.greendeltatc.simapro.csv.model.SPDataEntry;
import com.greendeltatc.simapro.csv.model.SPDocumentation;
import com.greendeltatc.simapro.csv.model.SPElementaryFlow;
import com.greendeltatc.simapro.csv.model.SPFlow;
import com.greendeltatc.simapro.csv.model.SPInputParameter;
import com.greendeltatc.simapro.csv.model.SPLiteratureReference;
import com.greendeltatc.simapro.csv.model.SPLiteratureReferenceEntry;
import com.greendeltatc.simapro.csv.model.SPLogNormalDistribution;
import com.greendeltatc.simapro.csv.model.SPNormalDistribution;
import com.greendeltatc.simapro.csv.model.SPPedigreeMatrix;
import com.greendeltatc.simapro.csv.model.SPProcess;
import com.greendeltatc.simapro.csv.model.SPProductFlow;
import com.greendeltatc.simapro.csv.model.SPReferenceProduct;
import com.greendeltatc.simapro.csv.model.SPTriangleDistribution;
import com.greendeltatc.simapro.csv.model.SPUniformDistribution;
import com.greendeltatc.simapro.csv.model.SPWasteSpecification;
import com.greendeltatc.simapro.csv.model.SPWasteTreatment;
import com.greendeltatc.simapro.csv.model.pedigreetypes.Completeness;
import com.greendeltatc.simapro.csv.model.pedigreetypes.FurtherTechnologicalCorrelation;
import com.greendeltatc.simapro.csv.model.pedigreetypes.GeographicalCorrelation;
import com.greendeltatc.simapro.csv.model.pedigreetypes.Reliability;
import com.greendeltatc.simapro.csv.model.pedigreetypes.TemporalCorrelation;
import com.greendeltatc.simapro.csv.model.types.BoundaryWithNature;
import com.greendeltatc.simapro.csv.model.types.CutOffRule;
import com.greendeltatc.simapro.csv.model.types.DistributionParameterType;
import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.ProcessAllocation;
import com.greendeltatc.simapro.csv.model.types.ProcessCategory;
import com.greendeltatc.simapro.csv.model.types.Status;
import com.greendeltatc.simapro.csv.model.types.Substitution;
import com.greendeltatc.simapro.csv.model.types.WasteTreatmentAllocation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.openlca.expressions.FormulaInterpreter;
import org.openlca.expressions.InterpreterException;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.TextAndImage;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2Description;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2GeographyRef;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2LogNormalDistribution;
import org.openlca.olcatdb.ecospold2.ES2NormalDistribution;
import org.openlca.olcatdb.ecospold2.ES2Parameter;
import org.openlca.olcatdb.ecospold2.ES2PedigreeMatrix;
import org.openlca.olcatdb.ecospold2.ES2Representativeness;
import org.openlca.olcatdb.ecospold2.ES2Technology;
import org.openlca.olcatdb.ecospold2.ES2TimePeriod;
import org.openlca.olcatdb.ecospold2.ES2TriangularDistribution;
import org.openlca.olcatdb.ecospold2.ES2Uncertainty;
import org.openlca.olcatdb.ecospold2.ES2UniformDistribution;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityEntry;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityName;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityNameList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Compartment;
import org.openlca.olcatdb.ecospold2.masterdata.ES2CompartmentList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ElemFlow;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ElemFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Geography;
import org.openlca.olcatdb.ecospold2.masterdata.ES2GeographyList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ProductFlow;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ProductFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2SubCompartment;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Tag;
import org.openlca.olcatdb.ecospold2.masterdata.ES2TagList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Unit;
import org.openlca.olcatdb.ecospold2.masterdata.ES2UnitList;
import org.openlca.olcatdb.ecospold2.resources.ES2Folder;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

public class CSVToES2Conversion
extends AbstractConversionImpl {
    private ES2Folder es2Folder;
    private File sourceFile;
    private Map<String, Entry> index = new HashMap<String, Entry>();
    private Map<String, ES2Parameter> parameters = new HashMap<String, ES2Parameter>();
    private ES2ActivityList activityList = new ES2ActivityList();
    private ES2ActivityNameList activityNameList = new ES2ActivityNameList();
    private ES2GeographyList geographyList = new ES2GeographyList();
    private ES2ElemFlowList elemFlowList = new ES2ElemFlowList();
    private ES2ProductFlowList productFlowList = new ES2ProductFlowList();
    private ES2UnitList unitList = new ES2UnitList();
    private ES2CompartmentList compartmentList = new ES2CompartmentList();
    private ES2TagList tagList = new ES2TagList();
    private XmlOutputter outputter;
    private TemplateType template = TemplateType.EcoSpold02;

    public CSVToES2Conversion(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    protected void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.es2Folder = new ES2Folder(targetDir);
        this.es2Folder.createContent();
        this.logFile(this.es2Folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.es2Folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        try {
            CSVParser parser = new CSVParser(this.sourceFile);
            this.monitor.progress("Count the processes", 0);
            int processes = parser.count();
            this.setRefIndex(processes, parser);
            this.monitor.begin(processes);
            parser.start();
            int counter = 0;
            while (parser.next() && !this.canceled) {
                DataSetReference reference;
                for (SPProcess sPProcess : parser.getDataSet().getProcesses()) {
                    reference = this.convert(sPProcess);
                    if (reference != null) {
                        this.createdFiles.add(reference);
                    }
                    this.monitor.progress("Convert process " + ++counter + "/" + processes, counter);
                }
                for (SPDataEntry sPDataEntry : parser.getDataSet().getWasteTreatments()) {
                    reference = this.convert(sPDataEntry);
                    if (reference != null) {
                        this.createdFiles.add(reference);
                    }
                    this.monitor.progress("Convert process " + ++counter + "/" + processes, counter);
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Parse exception: " + e.getMessage());
            e.printStackTrace();
        }
        this.flushMasterData();
        this.flush();
    }

    private void setRefIndex(int processes, CSVParser parser) throws IOException {
        this.monitor.begin(processes);
        parser.start();
        int counter = 0;
        while (parser.next() && !this.canceled) {
            Entry entry;
            for (SPProcess sPProcess : parser.getDataSet().getProcesses()) {
                this.monitor.progress("Create index " + ++counter + "/" + processes, counter);
                entry = new Entry();
                entry.processId = UUID.randomUUID().toString();
                this.index.put(sPProcess.getDocumentation().getIdentifier(), entry);
                for (SPReferenceProduct flow : sPProcess.getReferenceProducts()) {
                    entry.productId = UUID.randomUUID().toString();
                    this.index.put(flow.getName(), entry);
                }
            }
            for (SPDataEntry sPDataEntry : parser.getDataSet().getWasteTreatments()) {
                this.monitor.progress("Create index " + ++counter + "/" + processes, counter);
                entry = new Entry();
                entry.processId = UUID.randomUUID().toString();
                entry.productId = UUID.randomUUID().toString();
                this.index.put(sPDataEntry.getDocumentation().getIdentifier(), entry);
                this.index.put(((SPWasteTreatment)sPDataEntry).getWasteSpecification().getName(), entry);
            }
        }
    }

    private void flushMasterData() {
        this.flushMasterData("ActivityIndex.xml", this.activityList, TemplateType.ES2ActivityList);
        this.activityList = null;
        this.flushMasterData("ActivityNames.xml", this.activityNameList, TemplateType.ES2ActivityNameList);
        this.activityNameList = null;
        this.flushMasterData("Geographies.xml", this.geographyList, TemplateType.ES2GeographyList);
        this.geographyList = null;
        this.flushMasterData("ElementaryExchanges.xml", this.elemFlowList, TemplateType.ES2ElemFlowList);
        this.elemFlowList = null;
        this.flushMasterData("IntermediateExchanges.xml", this.productFlowList, TemplateType.ES2ProductFlowList);
        this.productFlowList = null;
        this.flushMasterData("Units.xml", this.unitList, TemplateType.ES2Units);
        this.unitList = null;
        this.flushMasterData("Compartments.xml", this.compartmentList, TemplateType.ES2CompartmentList);
        this.unitList = null;
        this.flushMasterData("Tags.xml", this.tagList, TemplateType.ES2TagList);
        this.tagList = null;
    }

    private void flushMasterData(String file, Object content, TemplateType template) {
        File mdDir = this.es2Folder.getMasterDataFolder();
        File outFile = new File(mdDir, file);
        if (outFile.exists()) {
            outFile.delete();
        }
        XmlOutputter outputter = new XmlOutputter();
        outputter.output(content, template, outFile, true);
    }

    private void addIntermediateExchangeToMasterData(ES2IntermediateExchange intermediateExchange) {
        ES2ProductFlow es2ProductFlow = new ES2ProductFlow();
        this.productFlowList.getProductFlows().add(es2ProductFlow);
        es2ProductFlow.id = intermediateExchange.id;
        es2ProductFlow.unitId = intermediateExchange.unitId;
        es2ProductFlow.getName().addAll(intermediateExchange.getName());
        es2ProductFlow.getComment().addAll(intermediateExchange.getComment());
    }

    private ES2Unit getUnit(String unitName) {
        ES2Unit es2Unit = null;
        for (ES2Unit unit : this.unitList.getUnits()) {
            for (LangString langString : unit.getNames()) {
                if (!langString.getValue().equals(unitName)) continue;
                es2Unit = unit;
            }
        }
        if (es2Unit == null) {
            es2Unit = new ES2Unit();
            this.unitList.getUnits().add(es2Unit);
            es2Unit.getNames().add(new LangString(unitName));
            es2Unit.id = UUID.randomUUID().toString();
        }
        return es2Unit;
    }

    private ES2Compartment getCompartment(SPElementaryFlow elementaryFlow) {
        ES2Compartment es2Compartment = null;
        ES2SubCompartment es2SubCompartment = null;
        if (elementaryFlow.getSubCompartment() != null) {
            for (ES2Compartment compartment : this.compartmentList.getCompartments()) {
                for (LangString langString : compartment.getNames()) {
                    if (!langString.getValue().equals(elementaryFlow.getType().getValue())) continue;
                    es2Compartment = compartment;
                }
            }
            if (es2Compartment == null) {
                es2Compartment = new ES2Compartment();
                this.compartmentList.getCompartments().add(es2Compartment);
                es2Compartment.id = UUID.randomUUID().toString();
                es2Compartment.getNames().add(new LangString(elementaryFlow.getType().getValue()));
            }
            for (ES2SubCompartment subCompartment : es2Compartment.getSubCompartments()) {
                for (LangString langString : subCompartment.getNames()) {
                    if (!langString.equals(elementaryFlow.getSubCompartment().getValue())) continue;
                    es2SubCompartment = subCompartment;
                }
            }
            if (es2SubCompartment == null) {
                es2SubCompartment = new ES2SubCompartment();
                es2Compartment.getSubCompartments().add(es2SubCompartment);
                this.compartmentList.getCompartments().add(es2Compartment);
                es2SubCompartment.id = UUID.randomUUID().toString();
                es2SubCompartment.getNames().add(new LangString(elementaryFlow.getSubCompartment().getValue()));
            }
        }
        return es2Compartment;
    }

    private void addTagToMasterData(String tag, String comment) {
        if (!this.tagList.containsName(tag)) {
            ES2Tag es2Tag = new ES2Tag();
            this.tagList.getTags().add(es2Tag);
            es2Tag.name = tag;
            if (comment != null && !comment.equals("")) {
                es2Tag.getComments().add(new LangString(comment));
            }
        }
    }

    private DataSetReference convert(SPDataEntry dataEntry) throws IllegalAccessException {
        ES2EcoSpold ecoSpold = new ES2EcoSpold();
        ES2Dataset dataset = new ES2Dataset();
        ecoSpold.getDatasets().add(dataset);
        this.parameters.clear();
        this.parameters(dataEntry.getInputParameters(), dataEntry.getCalculatedParameters());
        dataset.getParameters().addAll(this.parameters.values());
        this.activity(dataEntry, dataset);
        this.activityTags(dataEntry, dataset);
        this.geography(dataEntry, dataset);
        this.technology(dataEntry, dataset);
        this.timePeriod(dataEntry, dataset);
        this.representativeness(dataEntry, dataset);
        for (SPElementaryFlow sPElementaryFlow : dataEntry.getElementaryFlows()) {
            this.elementaryFlow(sPElementaryFlow, dataset);
        }
        for (SPFlow sPFlow : dataEntry.getProductFlows()) {
            this.productFlow((SPProductFlow)sPFlow, dataset);
        }
        if (dataEntry instanceof SPProcess) {
            this.process((SPProcess)dataEntry, dataset);
        } else if (dataEntry instanceof SPWasteTreatment) {
            this.wasteTreatment((SPWasteTreatment)dataEntry, dataset);
        }
        File outFile = new File(this.es2Folder.getActivityFolder(), dataset.description.id + ".spold");
        this.outputter = new XmlOutputter();
        this.outputter.output((Object)ecoSpold, this.template, outFile, true);
        DataSetReference reference = new DataSetReference();
        if (dataset.description != null) {
            reference.setRefObjectId(dataset.description.activityNameId);
        }
        reference.setType("process data set");
        try {
            String uri = outFile.toURI().toString();
            reference.setUri(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dataset.description != null && !dataset.description.getName().isEmpty()) {
            reference.setName(dataset.description.getName().get(0).getValue());
        }
        return reference;
    }

    private void parameters(SPInputParameter[] inputParameters, SPCalculatedParameter[] calculatedParameters) throws IllegalAccessException {
        HashMap<String, SPCalculatedParameter> index = new HashMap<String, SPCalculatedParameter>();
        for (SPInputParameter sPInputParameter : inputParameters) {
            index.put(sPInputParameter.getName(), null);
        }
        for (SPCalculatedParameter sPCalculatedParameter : calculatedParameters) {
            index.put(sPCalculatedParameter.getName(), sPCalculatedParameter);
        }
        for (SPInputParameter sPInputParameter : inputParameters) {
            this.inputParameter(sPInputParameter);
        }
        for (SPCalculatedParameter sPCalculatedParameter : calculatedParameters) {
            if (this.parameters.containsKey(sPCalculatedParameter.getName())) continue;
            this.calculatedParamter(sPCalculatedParameter, index);
        }
    }

    private void inputParameter(SPInputParameter parameter) {
        ES2Parameter es2Parameter = new ES2Parameter();
        this.parameters.put(parameter.getName(), es2Parameter);
        es2Parameter.id = UUID.randomUUID().toString();
        if (parameter.getName() != null && !parameter.getName().equals("")) {
            es2Parameter.getName().add(new LangString(parameter.getName()));
            es2Parameter.variableName = parameter.getName();
        }
        es2Parameter.amount = parameter.getValue();
        if (parameter.getComment() != null && !parameter.getComment().equals("")) {
            es2Parameter.getComment().add(new LangString(parameter.getComment()));
        }
        if (parameter.getDistribution() != null) {
            es2Parameter.uncertainty = this.uncertainty(parameter.getDistribution());
        }
    }

    private void calculatedParamter(SPCalculatedParameter parameter, Map<String, SPCalculatedParameter> index) throws IllegalAccessException {
        String expression;
        ES2Parameter es2Parameter = new ES2Parameter();
        this.parameters.put(parameter.getName(), es2Parameter);
        es2Parameter.id = UUID.randomUUID().toString();
        if (parameter.getName() != null && !parameter.getName().equals("")) {
            es2Parameter.getName().add(new LangString(parameter.getName()));
            es2Parameter.variableName = parameter.getName();
        }
        es2Parameter.isCalculatedAmount = true;
        es2Parameter.mathematicalRelation = expression = parameter.getExpression();
        try {
            FormulaInterpreter interpreter = new FormulaInterpreter();
            for (String name : index.keySet()) {
                if (!expression.contains(name)) continue;
                if (this.parameters.containsKey(name)) {
                    interpreter.bind(name, Double.toString(this.parameters.get((Object)name).amount));
                    continue;
                }
                this.calculatedParamter(index.get(name), index);
                if (!this.parameters.containsKey(name)) {
                    throw new IllegalAccessException("Conversion formula error!");
                }
                interpreter.bind(name, Double.toString(this.parameters.get((Object)name).amount));
            }
            es2Parameter.amount = interpreter.eval(expression.replace(",", ";"));
        }
        catch (InterpreterException e) {
            e.printStackTrace();
        }
    }

    private void productFlow(SPProductFlow productFlow, ES2Dataset dataset) {
        ES2IntermediateExchange intermediateExchange;
        block16: {
            String amount;
            intermediateExchange = new ES2IntermediateExchange();
            dataset.getIntermediateExchanges().add(intermediateExchange);
            intermediateExchange.id = UUID.randomUUID().toString();
            Entry entry = this.index.get(productFlow.getName());
            if (entry != null) {
                String acitivityLinkId = entry.processId;
                if (acitivityLinkId == null) {
                    acitivityLinkId = UUID.randomUUID().toString();
                }
                intermediateExchange.intermediateExchangeId = entry.productId;
            }
            if (productFlow.getName() != null) {
                intermediateExchange.getName().add(new LangString(productFlow.getName()));
            }
            if (productFlow.getUnit() != null && !productFlow.getUnit().getName().equals("")) {
                ES2Unit unit = this.getUnit(productFlow.getUnit().getName());
                intermediateExchange.unitId = unit.id;
                intermediateExchange.getUnitNames().addAll(unit.getNames());
            }
            if ((amount = productFlow.getAmount()) != null && !productFlow.getAmount().equals("")) {
                try {
                    intermediateExchange.amount = Double.parseDouble(productFlow.getAmount().replace(",", "."));
                }
                catch (NumberFormatException e) {
                    if (!this.parameters.containsKey(amount)) break block16;
                    ES2Parameter parameter = this.parameters.get(amount);
                    intermediateExchange.amount = parameter.amount;
                    intermediateExchange.isCalculatedAmount = true;
                    intermediateExchange.mathematicalRelation = parameter.variableName;
                }
            }
        }
        if (productFlow.getDistribution() != null) {
            intermediateExchange.uncertainty = this.uncertainty(productFlow.getDistribution());
        }
        if (productFlow.getComment() != null) {
            intermediateExchange.getComment().add(new LangString(productFlow.getComment()));
        }
        if (productFlow.getType() != null) {
            switch (productFlow.getType()) {
                case AVOIDED_PRODUCT: {
                    intermediateExchange.outputGroup = 2;
                    if (!(intermediateExchange.amount > 0.0)) break;
                    intermediateExchange.amount *= -1.0;
                    break;
                }
                case WASTE_TREATMENT: {
                    intermediateExchange.outputGroup = 3;
                    break;
                }
                case ELECTRICITY_INPUT: {
                    intermediateExchange.inputGroup = 2;
                    break;
                }
                case MATERIAL_INPUT: {
                    intermediateExchange.inputGroup = 1;
                }
            }
        }
        this.addIntermediateExchangeToMasterData(intermediateExchange);
    }

    private void elementaryFlow(SPElementaryFlow elementaryFlow, ES2Dataset dataset) {
        ES2Compartment compartment;
        ES2ElementaryExchange elementaryExchange;
        block13: {
            String amount;
            elementaryExchange = new ES2ElementaryExchange();
            dataset.getElementaryExchanges().add(elementaryExchange);
            elementaryExchange.id = UUID.randomUUID().toString();
            if (elementaryFlow.getName() != null) {
                elementaryExchange.getName().add(new LangString(elementaryFlow.getName()));
            }
            if (elementaryFlow.getUnit() != null && !elementaryFlow.getUnit().getName().equals("")) {
                ES2Unit unit = this.getUnit(elementaryFlow.getUnit().getName());
                elementaryExchange.unitId = unit.id;
                elementaryExchange.getUnitNames().addAll(unit.getNames());
            }
            if (elementaryFlow.getComment() != null && !elementaryFlow.getComment().equals("")) {
                elementaryExchange.getComment().add(new LangString(elementaryFlow.getComment()));
            }
            if ((amount = elementaryFlow.getAmount()) != null && !elementaryFlow.getAmount().equals("")) {
                try {
                    elementaryExchange.amount = Double.parseDouble(elementaryFlow.getAmount().replace(",", "."));
                }
                catch (NumberFormatException e) {
                    if (!this.parameters.containsKey(amount)) break block13;
                    ES2Parameter parameter = this.parameters.get(amount);
                    elementaryExchange.amount = parameter.amount;
                    elementaryExchange.isCalculatedAmount = true;
                    elementaryExchange.mathematicalRelation = parameter.variableName;
                }
            }
        }
        if (elementaryFlow.getDistribution() != null) {
            elementaryExchange.uncertainty = this.uncertainty(elementaryFlow.getDistribution());
        }
        if (elementaryFlow.getType() != null) {
            if (elementaryFlow.getType() != ElementaryFlowType.RESOURCE) {
                elementaryExchange.outputGroup = 4;
            } else {
                elementaryExchange.inputGroup = 4;
            }
        }
        if (elementaryFlow.getSubstance() != null) {
            elementaryExchange.casNumber = elementaryFlow.getSubstance().getCASNumber();
        }
        if ((compartment = this.getCompartment(elementaryFlow)) != null) {
            elementaryExchange.compartmentId = compartment.id;
        }
        if (!this.elemFlowList.containsName(elementaryExchange.getName())) {
            ES2ElemFlow elemFlow = new ES2ElemFlow();
            this.elemFlowList.getElemFlows().add(elemFlow);
            elemFlow.id = elementaryExchange.id;
            elemFlow.unitId = elementaryExchange.unitId;
            elemFlow.getName().addAll(elementaryExchange.getName());
            elemFlow.getComment().addAll(elementaryExchange.getComment());
        }
    }

    private ES2Uncertainty uncertainty(IDistribution distribution) {
        ES2Uncertainty uncertainty = new ES2Uncertainty();
        if (distribution != null) {
            switch (distribution.getType()) {
                case LOG_NORMAL: {
                    ES2LogNormalDistribution es2LogNormalDistribution;
                    SPLogNormalDistribution spLogNormalDistribution = (SPLogNormalDistribution)distribution;
                    uncertainty.logNormalDistribution = es2LogNormalDistribution = new ES2LogNormalDistribution();
                    double squared = spLogNormalDistribution.getDistributionParameter(DistributionParameterType.SQUARED_STANDARD_DEVIATION);
                    double variance = Math.log(Math.sqrt(squared)) * 2.0;
                    es2LogNormalDistribution.variance = variance;
                    es2LogNormalDistribution.varianceWithPedigreeUncertainty = squared + variance;
                    es2LogNormalDistribution.standardDeviation95 = Math.sqrt(variance);
                    if (spLogNormalDistribution.getPedigreeMatrix() != null) {
                        uncertainty.pedigreeMatrix = this.pedigreeMatrix(spLogNormalDistribution.getPedigreeMatrix());
                    }
                    if (spLogNormalDistribution.getPedigreeMatrix() == null) break;
                    uncertainty.getGeneralComment().add(new LangString("SampleSize: " + spLogNormalDistribution.getPedigreeMatrix().sampleSize.getKey() + " = " + spLogNormalDistribution.getPedigreeMatrix().sampleSize.getValue()));
                    break;
                }
                case NORMAL: {
                    ES2NormalDistribution es2NormalDistribution;
                    SPNormalDistribution spNormalDistribution = (SPNormalDistribution)distribution;
                    uncertainty.normalDistribution = es2NormalDistribution = new ES2NormalDistribution();
                    double standardDeviation = spNormalDistribution.getDistributionParameter(DistributionParameterType.DOUBLED_STANDARD_DEVIATION);
                    es2NormalDistribution.variance = standardDeviation;
                    es2NormalDistribution.standardDeviation95 = Math.sqrt(standardDeviation);
                    break;
                }
                case TRIANGLE: {
                    ES2TriangularDistribution es2TriangularDistribution;
                    SPTriangleDistribution spTriangleDistribution = (SPTriangleDistribution)distribution;
                    uncertainty.triangularDistribution = es2TriangularDistribution = new ES2TriangularDistribution();
                    es2TriangularDistribution.minValue = spTriangleDistribution.getDistributionParameter(DistributionParameterType.MINIMUM);
                    es2TriangularDistribution.maxValue = spTriangleDistribution.getDistributionParameter(DistributionParameterType.MAXIMUM);
                    break;
                }
                case UNIFORM: {
                    ES2UniformDistribution es2UniformDistribution;
                    SPUniformDistribution spUniformDistribution = (SPUniformDistribution)distribution;
                    uncertainty.uniformDistribution = es2UniformDistribution = new ES2UniformDistribution();
                    es2UniformDistribution.minValue = spUniformDistribution.getDistributionParameter(DistributionParameterType.MINIMUM);
                    es2UniformDistribution.maxValue = spUniformDistribution.getDistributionParameter(DistributionParameterType.MAXIMUM);
                    break;
                }
                case UNDEFINED: {
                    uncertainty = null;
                }
            }
        }
        return uncertainty;
    }

    private ES2PedigreeMatrix pedigreeMatrix(SPPedigreeMatrix pedigreeMatrix) {
        ES2PedigreeMatrix es2PedigreeMatrix = new ES2PedigreeMatrix();
        if (pedigreeMatrix.completeness != Completeness.NA) {
            es2PedigreeMatrix.completeness = Integer.parseInt(pedigreeMatrix.completeness.getKey());
        }
        if (pedigreeMatrix.furtherTechnologicalCorrelation != FurtherTechnologicalCorrelation.NA) {
            es2PedigreeMatrix.furtherTechnologyCorrelation = Integer.parseInt(pedigreeMatrix.furtherTechnologicalCorrelation.getKey());
        }
        if (pedigreeMatrix.geographicalCorrelation != GeographicalCorrelation.NA) {
            es2PedigreeMatrix.geographicalCorrelation = Integer.parseInt(pedigreeMatrix.geographicalCorrelation.getKey());
        }
        if (pedigreeMatrix.reliability != Reliability.NA) {
            es2PedigreeMatrix.reliability = Integer.parseInt(pedigreeMatrix.reliability.getKey());
        }
        if (pedigreeMatrix.temporalCorrelation != TemporalCorrelation.NA) {
            es2PedigreeMatrix.temporalCorrelation = Integer.parseInt(pedigreeMatrix.temporalCorrelation.getKey());
        }
        return es2PedigreeMatrix;
    }

    private void representativeness(SPDataEntry dataEntry, ES2Dataset dataset) {
        ES2Representativeness representativeness;
        dataset.representativeness = representativeness = new ES2Representativeness();
        if (dataEntry.getDocumentation().getRepresentativeness() != null) {
            representativeness.getSamplingProcedure().add(new LangString(dataEntry.getDocumentation().getRepresentativeness().getValue()));
        }
    }

    private void activity(SPDataEntry dataEntry, ES2Dataset dataset) {
        ES2Description description;
        dataset.description = description = new ES2Description(true);
        SPDocumentation documentation = dataEntry.getDocumentation();
        description.activityNameId = description.id = this.index.get((Object)dataEntry.getDocumentation().getIdentifier()).processId;
        if (documentation.getName() != null) {
            description.getName().add(new LangString(dataEntry.getDocumentation().getName()));
        }
        String generalComment = "";
        if (documentation.getComment() != null) {
            generalComment = documentation.getComment();
        }
        if (!generalComment.equals("")) {
            description.generalComment = new TextAndImage(generalComment);
        }
        if (documentation.getAllocationRules() != null) {
            description.allocationComment = new TextAndImage(documentation.getAllocationRules());
        }
        if (documentation.getProcessType() != null) {
            switch (documentation.getProcessType()) {
                case UNIT_PROCESS: {
                    description.type = 1;
                    break;
                }
                case SYSTEM: {
                    description.type = 2;
                }
            }
        }
        ES2ActivityEntry indexEntry = new ES2ActivityEntry();
        this.activityList.getEntries().add(indexEntry);
        indexEntry.specialActivityType = 0;
        indexEntry.activityNameId = dataset.description.activityNameId;
        indexEntry.id = dataset.description.id;
        indexEntry.getName().addAll(dataset.description.getName());
        if (dataset.geography != null) {
            indexEntry.geographyId = dataset.geography.geographyId;
            indexEntry.getLocation().addAll(dataset.geography.getShortNames());
        }
        if (dataset.timePeriod != null) {
            indexEntry.startDate = dataset.timePeriod.startDate;
            indexEntry.endDate = dataset.timePeriod.endDate;
        }
        ES2ActivityName nameEntry = new ES2ActivityName();
        this.activityNameList.getActivityNames().add(nameEntry);
        if (dataset.description != null) {
            nameEntry.id = dataset.description.activityNameId;
            nameEntry.getNames().addAll(dataset.description.getName());
        }
    }

    private void activityTags(SPDataEntry dataEntry, ES2Dataset dataset) {
        Status status;
        BoundaryWithNature boundaryWithNature;
        CutOffRule cutOffRule;
        String tag;
        ProcessCategory processCategory = dataEntry.getDocumentation().getCategory();
        if (processCategory != null) {
            tag = "Category type: " + processCategory.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((cutOffRule = dataEntry.getDocumentation().getCutOffRule()) != null) {
            tag = "Cut off rules: " + cutOffRule.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((boundaryWithNature = dataEntry.getDocumentation().getBoundaryWithNature()) != null) {
            tag = "Boundary with nature: " + boundaryWithNature.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if (dataEntry.getDocumentation().isInfrastructureProcess()) {
            tag = "Infrastructure: Yes";
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((status = dataEntry.getDocumentation().getStatus()) != null) {
            tag = "Status: " + status.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((tag = dataEntry.getDocumentation().getRecord()) != null) {
            tag = "Record: " + tag;
            dataset.description.getTags().add(tag);
            this.addTagToMasterData("Record", null);
        }
        if ((tag = dataEntry.getDocumentation().getGenerator()) != null) {
            tag = "Generator: " + tag;
            dataset.description.getTags().add(tag);
            this.addTagToMasterData("Generator", null);
        }
        for (SPLiteratureReferenceEntry liEntry : dataEntry.getDocumentation().getLiteratureReferencesEntries()) {
            SPLiteratureReference literatureReference = liEntry.getLiteratureReference();
            if (literatureReference == null) continue;
            tag = "Literature references: " + literatureReference.getName();
            dataset.description.getTags().add(tag + ";" + liEntry.getComment());
            this.addTagToMasterData(tag, null);
        }
        tag = dataEntry.getDocumentation().getCollectionMethod();
        if (tag != null) {
            tag = "Collection method: " + tag;
            dataset.description.getTags().add(tag);
            this.addTagToMasterData("Collection method", null);
        }
        if ((tag = dataEntry.getDocumentation().getDataTreatment()) != null) {
            tag = "Data treatment: " + tag;
            dataset.description.getTags().add(tag);
            this.addTagToMasterData("Data treatment", null);
        }
        if ((tag = dataEntry.getDocumentation().getVerification()) != null) {
            tag = "Verification: " + tag;
            dataset.description.getTags().add(tag);
            this.addTagToMasterData("Verification", null);
        }
    }

    private void geography(SPDataEntry dataEntry, ES2Dataset dataset) {
        if (dataEntry.getDocumentation().getGeography() != null) {
            ES2GeographyRef refGeography;
            dataset.geography = refGeography = new ES2GeographyRef();
            refGeography.geographyId = dataEntry.getDocumentation().getGeography().getES2Id();
            refGeography.getShortNames().add(new LangString(dataEntry.getDocumentation().getGeography().getValue()));
            boolean geoExist = false;
            for (ES2Geography geo : this.geographyList.getGeographies()) {
                if (!geo.id.equals(dataEntry.getDocumentation().getGeography().getES2Id())) continue;
                geoExist = true;
            }
            if (!geoExist) {
                ES2Geography geography = new ES2Geography();
                geography.id = dataEntry.getDocumentation().getGeography().getES2Id();
                geography.getNames().add(new LangString(dataEntry.getDocumentation().getGeography().getValue()));
                geography.getShortNames().add(new LangString(dataEntry.getDocumentation().getGeography().getValue()));
                this.geographyList.getGeographies().add(geography);
            }
        }
    }

    private void technology(SPDataEntry dataEntry, ES2Dataset dataset) {
        if (dataEntry.getDocumentation().getTechnology() != null) {
            int technologyLevel;
            ES2Technology technology;
            dataset.technology = technology = new ES2Technology();
            switch (dataEntry.getDocumentation().getTechnology()) {
                case AVERAGE_TECHNOLOGY: {
                    technologyLevel = 3;
                    break;
                }
                case BEST_AVAILABLE_TECHNOLOGY: {
                    technologyLevel = 1;
                    break;
                }
                case FUTURE_TECHNOLOGY: {
                    technologyLevel = 1;
                    break;
                }
                case MIXED_DATA: {
                    technologyLevel = 3;
                    break;
                }
                case MODERN_TECHNOLOGY: {
                    technologyLevel = 2;
                    break;
                }
                case OUTDATED_TECHNOLOGY: {
                    technologyLevel = 5;
                    break;
                }
                case UNKNOWN: {
                    technologyLevel = 0;
                    break;
                }
                case UNSPECIFIED: {
                    technologyLevel = 0;
                    break;
                }
                case WORST_CASE: {
                    technologyLevel = 5;
                    break;
                }
                default: {
                    technologyLevel = 0;
                }
            }
            technology.technologyLevel = technologyLevel;
        }
    }

    private void timePeriod(SPDataEntry dataEntry, ES2Dataset dataset) {
        if (dataEntry.getDocumentation().getTimePeriod() != null) {
            ES2TimePeriod timePeriod;
            String startDate = null;
            String endDate = null;
            String comment = null;
            switch (dataEntry.getDocumentation().getTimePeriod()) {
                case P_1980_1984: {
                    startDate = "1980";
                    endDate = "1984";
                    break;
                }
                case P_1985_1989: {
                    startDate = "1985";
                    endDate = "1989";
                    break;
                }
                case P_1990_1994: {
                    startDate = "1990";
                    endDate = "1994";
                    break;
                }
                case P_1995_1999: {
                    startDate = "1995";
                    endDate = "1999";
                    break;
                }
                case P_2000_2004: {
                    startDate = "2000";
                    endDate = "2004";
                    break;
                }
                case P_2005_2009: {
                    startDate = "2005";
                    endDate = "2009";
                    break;
                }
                case P_2010_AND_AFTER: {
                    startDate = "2010";
                    endDate = "after";
                    break;
                }
                case P_1980_AND_BEFORE: {
                    startDate = "before";
                    endDate = "1980";
                    break;
                }
                case MIXED_DATA: {
                    comment = "mixed data";
                    break;
                }
                case UNKNOWN: {
                    comment = "unknown";
                    break;
                }
                case UNSPECIFIED: {
                    comment = "unspecified";
                }
            }
            dataset.timePeriod = timePeriod = new ES2TimePeriod();
            if (startDate != null) {
                timePeriod.startDate = startDate;
            }
            if (endDate != null) {
                timePeriod.endDate = endDate;
            }
            if (comment != null) {
                timePeriod.comment = new TextAndImage(comment);
            }
        }
    }

    private void process(SPProcess process, ES2Dataset dataset) {
        Substitution substitution;
        String tag;
        ProcessAllocation processAllocation = process.getDocumentation().getProcessAllocation();
        if (processAllocation != null) {
            tag = "Multiple output allocation: " + processAllocation.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((substitution = process.getDocumentation().getSubstitution()) != null) {
            tag = "Substitution allocation: " + substitution.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        this.refProducts(process, dataset);
    }

    private void refProducts(SPProcess process, ES2Dataset dataset) {
        for (SPReferenceProduct product : process.getReferenceProducts()) {
            ES2IntermediateExchange intermediateExchange;
            block11: {
                String amount;
                intermediateExchange = new ES2IntermediateExchange();
                dataset.getIntermediateExchanges().add(intermediateExchange);
                intermediateExchange.id = UUID.randomUUID().toString();
                if (product.getName() != null) {
                    intermediateExchange.getName().add(new LangString(product.getName()));
                }
                if ((amount = product.getAmount()) != null && !product.getAmount().equals("")) {
                    try {
                        intermediateExchange.amount = Double.parseDouble(product.getAmount().replace(",", "."));
                    }
                    catch (NumberFormatException e) {
                        if (!this.parameters.containsKey(amount)) break block11;
                        ES2Parameter parameter = this.parameters.get(amount);
                        intermediateExchange.amount = parameter.amount;
                        intermediateExchange.isCalculatedAmount = true;
                        intermediateExchange.mathematicalRelation = parameter.variableName;
                    }
                }
            }
            if (product.getUnit() != null && !product.getUnit().getName().equals("")) {
                ES2Unit unit = this.getUnit(product.getUnit().getName());
                intermediateExchange.unitId = unit.id;
                intermediateExchange.getUnitNames().addAll(unit.getNames());
            }
            if (product.getComment() != null) {
                intermediateExchange.getComment().add(new LangString(product.getComment()));
            }
            int type = 2;
            if (product.equals(process.getReferenceProducts()[0])) {
                type = 0;
            }
            intermediateExchange.outputGroup = type;
            String tag = product.getCategory();
            if (tag != null && !tag.equals("")) {
                tag = "Category: " + tag;
                intermediateExchange.getTags().add(tag);
                this.addTagToMasterData(tag, null);
            }
            if (product.getWasteType() != null) {
                tag = "Waste type: " + product.getWasteType();
                intermediateExchange.getTags().add(tag);
                this.addTagToMasterData(tag, null);
            }
            if ((tag = String.valueOf(product.getAllocation())) != null) {
                tag = "Allocation: " + tag;
                intermediateExchange.getTags().add(tag);
                this.addTagToMasterData("Allocation", null);
            }
            this.addIntermediateExchangeToMasterData(intermediateExchange);
        }
    }

    private void wasteTreatment(SPWasteTreatment treatment, ES2Dataset dataset) {
        WasteTreatmentAllocation treatmentAllocation = treatment.getDocumentation().getWasteTreatmentAllocation();
        if (treatmentAllocation != null) {
            String tag = "Waste treatment allocation: " + treatmentAllocation.getValue();
            dataset.description.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        this.wasteSpecification(treatment.getWasteSpecification(), dataset);
    }

    private void wasteSpecification(SPWasteSpecification specification, ES2Dataset dataset) {
        String category;
        String tag;
        ES2IntermediateExchange intermediateExchange;
        block8: {
            String amount;
            intermediateExchange = new ES2IntermediateExchange();
            dataset.getIntermediateExchanges().add(intermediateExchange);
            intermediateExchange.id = UUID.randomUUID().toString();
            if (specification.getName() != null) {
                intermediateExchange.getName().add(new LangString(specification.getName()));
            }
            if ((amount = specification.getAmount()) != null && !specification.getAmount().equals("")) {
                try {
                    intermediateExchange.amount = Double.parseDouble(specification.getAmount().replace(",", "."));
                }
                catch (NumberFormatException e) {
                    if (!this.parameters.containsKey(amount)) break block8;
                    ES2Parameter parameter = this.parameters.get(amount);
                    intermediateExchange.amount = parameter.amount;
                    intermediateExchange.isCalculatedAmount = true;
                    intermediateExchange.mathematicalRelation = parameter.variableName;
                }
            }
        }
        if (specification.getUnit() != null && !specification.getUnit().equals("")) {
            ES2Unit unit = this.getUnit(specification.getUnit().getName());
            intermediateExchange.unitId = unit.id;
            intermediateExchange.getUnitNames().addAll(unit.getNames());
        }
        if (specification.getComment() != null & !specification.getComment().equals("")) {
            intermediateExchange.getComment().add(new LangString(specification.getComment()));
        }
        intermediateExchange.outputGroup = 0;
        if (specification.getWasteType() != null) {
            tag = "Waste type: " + specification.getWasteType();
            intermediateExchange.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        if ((category = specification.getCategory()) != null && !category.equals("")) {
            tag = "Category: " + category;
            intermediateExchange.getTags().add(tag);
            this.addTagToMasterData(tag, null);
        }
        this.addIntermediateExchangeToMasterData(intermediateExchange);
    }

    private class Entry {
        String processId = null;
        String productId = null;

        private Entry() {
        }
    }
}

