/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import org.openlca.olcatdb.conversion.CSVToES2Conversion;
import org.openlca.olcatdb.conversion.Conversion;
import org.openlca.olcatdb.conversion.ConversionException;
import org.openlca.olcatdb.conversion.ES1ToES1SimaProConversion;
import org.openlca.olcatdb.conversion.ES1ToES2Conversion;
import org.openlca.olcatdb.conversion.ES1ToILCDConversion;
import org.openlca.olcatdb.conversion.ES2ToES1Conversion;
import org.openlca.olcatdb.conversion.ES2ToILCDConversion;
import org.openlca.olcatdb.conversion.ILCDToES1Conversion;
import org.openlca.olcatdb.conversion.ILCDToES2Conversion;
import org.openlca.olcatdb.conversion.XMLProcessFormat;
import org.openlca.olcatdb.conversion.es2tocsv.ES2ToCSVSetUpConversion;

public class ConversionDispatch {
    private ConversionDispatch() {
    }

    public static Conversion createConversion(File sourceFile, File targetDir, XMLProcessFormat targetFormat, boolean splitCSV, String lang, File masterData) throws ConversionException {
        if (!sourceFile.exists() || sourceFile.isDirectory()) {
            throw new IllegalArgumentException("The source file must be an existing file.");
        }
        if (targetDir == null || !targetDir.exists() || !targetDir.isDirectory()) {
            throw new IllegalArgumentException("The target directory must be an existing directory.");
        }
        XMLProcessFormat sourceFormat = XMLProcessFormat.fromFile(sourceFile);
        if (sourceFormat == null) {
            throw new ConversionException("Cannot identifiy the format of the given source file.");
        }
        if (sourceFormat == targetFormat) {
            throw new ConversionException("The source format is equal to the target format.");
        }
        String notImplementedMsg = "Not yet implemented.";
        Conversion conversion = null;
        switch (sourceFormat) {
            case EcoSpold1: {
                if (targetFormat == XMLProcessFormat.EcoSpold2) {
                    conversion = new ES1ToES2Conversion();
                    break;
                }
                if (targetFormat == XMLProcessFormat.ILCD) {
                    conversion = new ES1ToILCDConversion();
                    break;
                }
                if (targetFormat == XMLProcessFormat.EcoSpold1_Sima_Pro) {
                    conversion = new ES1ToES1SimaProConversion();
                    break;
                }
                if (targetFormat != XMLProcessFormat.CSV) break;
                throw new ConversionException(notImplementedMsg);
            }
            case EcoSpold2: {
                if (targetFormat == XMLProcessFormat.EcoSpold1) {
                    conversion = new ES2ToES1Conversion();
                    break;
                }
                if (targetFormat == XMLProcessFormat.EcoSpold1_Sima_Pro) {
                    conversion = new ES2ToES1Conversion(true);
                    break;
                }
                if (targetFormat == XMLProcessFormat.ILCD) {
                    conversion = new ES2ToILCDConversion();
                    break;
                }
                if (targetFormat != XMLProcessFormat.CSV) break;
                conversion = new ES2ToCSVSetUpConversion(splitCSV, lang, masterData);
                break;
            }
            case ILCD: {
                if (targetFormat == XMLProcessFormat.EcoSpold1) {
                    conversion = new ILCDToES1Conversion();
                    break;
                }
                if (targetFormat == XMLProcessFormat.EcoSpold1_Sima_Pro) {
                    conversion = new ILCDToES1Conversion(true);
                    break;
                }
                if (targetFormat == XMLProcessFormat.EcoSpold2) {
                    conversion = new ILCDToES2Conversion();
                    break;
                }
                if (targetFormat != XMLProcessFormat.CSV) break;
                throw new ConversionException(notImplementedMsg);
            }
            case CSV: {
                if (targetFormat == XMLProcessFormat.EcoSpold2) {
                    conversion = new CSVToES2Conversion(sourceFile);
                    break;
                }
                if (targetFormat != XMLProcessFormat.EcoSpold1 && targetFormat != XMLProcessFormat.EcoSpold1_Sima_Pro && targetFormat != XMLProcessFormat.ILCD) break;
                throw new ConversionException(notImplementedMsg);
            }
        }
        if (conversion == null) {
            throw new ConversionException("Cannot set up conversion.");
        }
        conversion.setSourceFile(sourceFile);
        conversion.setTargetDir(targetDir);
        return conversion;
    }
}

