/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import org.openlca.olcatdb.conversion.SPCategory;
import org.openlca.olcatdb.conversion.SPMappingFile;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1Validation;

public class ES1SimaProValidConversion {
    private SPMappingFile mappingFile = new SPMappingFile();

    public SPMappingFile getMappingFile() {
        return this.mappingFile;
    }

    public void validate(ES1Dataset dataSet) {
        this.checkRequiredElements(dataSet);
        this.checkRefFlowName(dataSet);
        this.checkRequiredExchangeAttributes(dataSet);
        this.correctSubCategory(dataSet);
    }

    private void checkRequiredElements(ES1Dataset dataSet) {
        if (dataSet.validation == null) {
            ES1Validation validation = new ES1Validation();
            int personId = 0;
            if (dataSet.getPerson(personId) == null) {
                ES1Person person = new ES1Person();
                person.number = personId;
                person.name = "unknown";
                dataSet.getPersons().add(person);
            }
            validation.proofReadingDetails = "unknown";
            validation.proofReadingValidator = personId;
            dataSet.validation = validation;
        }
    }

    private void checkRefFlowName(ES1Dataset dataSet) {
        for (ES1Exchange exchange : dataSet.getExchanges()) {
            if (exchange.outputGroup == null || exchange.outputGroup != 0 || exchange.name.equals(dataSet.referenceFunction.name)) continue;
            exchange.name = dataSet.referenceFunction.name;
        }
    }

    private void checkRequiredExchangeAttributes(ES1Dataset dataSet) {
        for (ES1Exchange exchange : dataSet.getExchanges()) {
            if (exchange.location == null) {
                exchange.location = "";
            }
            if (exchange.uncertaintyType == null) {
                exchange.uncertaintyType = 0;
            }
            if (exchange.inputGroup == null || exchange.inputGroup != 4) continue;
            if (exchange.category == null) {
                exchange.category = "unspecified";
            }
            if (exchange.subCategory != null) continue;
            exchange.subCategory = "unspecified";
        }
    }

    private void correctSubCategory(ES1Dataset dataSet) {
        for (ES1Exchange exchange : dataSet.getExchanges()) {
            if (exchange.category == null) continue;
            if (exchange.category.equals("air") && exchange.subCategory.equals("high population density")) {
                exchange.subCategory = "high. pop.";
            }
            if (exchange.category.equals("air") && exchange.subCategory.equals("low population density")) {
                exchange.subCategory = "low. pop.";
            }
            if (exchange.category.equals("air") && exchange.subCategory.equals("low population density, long-term")) {
                exchange.subCategory = "low. pop., long-term";
            }
            if (exchange.category.equals("air") && exchange.subCategory.equals("lower stratosphere + upper tropos")) {
                exchange.subCategory = "stratosphere";
            }
            if (exchange.category.equals("water") && exchange.subCategory.equals("fossil-")) {
                exchange.subCategory = "fossilwater";
            }
            if (exchange.category.equals("water") && exchange.subCategory.equals("ground-")) {
                exchange.subCategory = "groundwater";
            }
            if (!exchange.category.equals("water") || !exchange.subCategory.equals("ground-, long-term")) continue;
            exchange.subCategory = "groundwater, long";
        }
    }

    public void processForMappingFile(ES1Dataset dataSet) {
        for (ES1Exchange exchange : dataSet.getExchanges()) {
            SPCategory category = SPCategory.getCategory(exchange.category, exchange.subCategory, null);
            this.mappingFile.add(category);
        }
    }
}

