/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.ES1SimaProValidConversion;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold1.resources.ES1Folder;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

public class ES1ToES1SimaProConversion
extends AbstractConversionImpl {
    private ES1SimaProValidConversion simaProConverter = new ES1SimaProValidConversion();
    private ES1Folder es1Folder = null;

    @Override
    public void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.es1Folder = new ES1Folder(targetDir);
        this.es1Folder.createContent();
        this.logFile(this.es1Folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.es1Folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES1EcoSpold ecoSpold = parser.getContext(ES1EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES1Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference;
                    if (!dataset.isProcess() || (reference = this.convert(dataset)) == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private DataSetReference convert(ES1Dataset dataSet) {
        this.simaProConverter.validate(dataSet);
        ES1EcoSpold ecoSpold = new ES1EcoSpold();
        ecoSpold.getDatasets().add(dataSet);
        DataSetReference ref = null;
        String uuid = UUID.randomUUID().toString();
        File outFile = new File(this.es1Folder.getProcessFolder(), uuid + ".xml");
        if (outFile.exists()) {
            this.logger.severe("The file " + outFile.getAbsolutePath() + " already exists.");
        } else {
            XmlOutputter outputter = new XmlOutputter();
            outputter.output((Object)ecoSpold, TemplateType.EcoSpold01, outFile, true);
            ref = new DataSetReference();
            String name = "";
            name = dataSet.referenceFunction != null ? dataSet.referenceFunction.name : outFile.getName();
            ref.setName(name);
            ref.setUri(outFile.toURI().toString());
            ref.setRefObjectId(uuid);
            ref.setType(ILCDDataSetType.Process.toString());
            ref.setVersion("01.00.000");
        }
        return ref;
    }
}

