/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.TextAndImage;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1Source;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2Description;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2Entry;
import org.openlca.olcatdb.ecospold2.ES2FileAttributes;
import org.openlca.olcatdb.ecospold2.ES2GeographyRef;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2LogNormalDistribution;
import org.openlca.olcatdb.ecospold2.ES2MacroEconomicScenario;
import org.openlca.olcatdb.ecospold2.ES2NormalDistribution;
import org.openlca.olcatdb.ecospold2.ES2Publication;
import org.openlca.olcatdb.ecospold2.ES2Representativeness;
import org.openlca.olcatdb.ecospold2.ES2Review;
import org.openlca.olcatdb.ecospold2.ES2Technology;
import org.openlca.olcatdb.ecospold2.ES2TimePeriod;
import org.openlca.olcatdb.ecospold2.ES2TriangularDistribution;
import org.openlca.olcatdb.ecospold2.ES2Uncertainty;
import org.openlca.olcatdb.ecospold2.ES2UndefinedDistribution;
import org.openlca.olcatdb.ecospold2.ES2UniformDistribution;
import org.openlca.olcatdb.ecospold2.resources.ES2Folder;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

class ES1ToES2Conversion
extends AbstractConversionImpl {
    private ES2Folder es2Folder;

    ES1ToES2Conversion() {
    }

    @Override
    protected void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.es2Folder = new ES2Folder(targetDir);
        this.es2Folder.createContent();
        this.logFile(this.es2Folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.es2Folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES1EcoSpold ecoSpold = parser.getContext(ES1EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES1Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference;
                    if (!dataset.isProcess() || (reference = this.convert(dataset)) == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private DataSetReference convert(ES1Dataset dataset) {
        ES2EcoSpold ecoSpold = new ES2EcoSpold();
        ES2Dataset e2Dataset = new ES2Dataset();
        ecoSpold.getDatasets().add(e2Dataset);
        this.description(dataset, e2Dataset);
        this.classification(dataset, e2Dataset);
        this.geography(dataset, e2Dataset);
        this.technology(dataset, e2Dataset);
        this.time(dataset, e2Dataset);
        this.economicScen(dataset, e2Dataset);
        for (ES1Exchange exchange : dataset.getExchanges()) {
            if (exchange.isElementaryFlow()) {
                this.elementaryExchange(exchange, e2Dataset);
                continue;
            }
            this.intermediateExchange(exchange, e2Dataset);
        }
        this.representativeness(dataset, e2Dataset);
        this.review(dataset, e2Dataset);
        this.dataEntry(dataset, e2Dataset);
        this.publication(dataset, e2Dataset);
        this.fileAttributes(dataset, e2Dataset);
        File outFile = new File(this.es2Folder.getActivityFolder(), UUID.randomUUID().toString() + ".spold");
        XmlOutputter outputter = new XmlOutputter();
        outputter.output((Object)ecoSpold, TemplateType.EcoSpold02, outFile, true);
        DataSetReference reference = new DataSetReference();
        if (e2Dataset.description != null) {
            reference.setRefObjectId(e2Dataset.description.activityNameId);
        }
        reference.setType("process data set");
        try {
            String uri = outFile.toURI().toString();
            reference.setUri(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (e2Dataset.description != null && !e2Dataset.description.getName().isEmpty()) {
            reference.setName(e2Dataset.description.getName().get(0).getValue());
        }
        return reference;
    }

    private void description(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        ES2Description e2Description;
        e2Ds.description = e2Description = new ES2Description(true);
        e2Description.id = UUID.randomUUID().toString();
        e2Description.activityNameId = UUID.randomUUID().toString();
        if (e1Ds.referenceFunction != null) {
            e2Description.getName().add(new LangString(e1Ds.referenceFunction.name));
            if (e1Ds.referenceFunction.includedProcesses != null) {
                e2Description.getIncludedActivitiesEnd().add(new LangString(e1Ds.referenceFunction.includedProcesses));
            }
            if (e1Ds.referenceFunction.generalComment != null) {
                e2Description.generalComment = new TextAndImage(e1Ds.referenceFunction.generalComment);
            }
        }
    }

    private void classification(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.referenceFunction != null) {
            ES2ClassificationRef classification = new ES2ClassificationRef();
            e2Ds.getClassifications().add(classification);
            classification.classificationId = "5d8c60ab-17f8-4ba6-99ca-a72b75f66cf3";
            classification.getClassificationSystem().add(new LangString("EcoSpold01Categories"));
            String val = "" + e1Ds.referenceFunction.category + "/" + e1Ds.referenceFunction.subCategory;
            classification.getClassificationValue().add(new LangString(val));
        }
    }

    private void geography(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.geography != null) {
            ES2GeographyRef es2Geography;
            e2Ds.geography = es2Geography = new ES2GeographyRef();
            es2Geography.geographyId = UUID.randomUUID().toString();
            if (e1Ds.geography.location != null) {
                es2Geography.getShortNames().add(new LangString(e1Ds.geography.location));
            }
            if (e1Ds.geography.text != null) {
                es2Geography.comment = new TextAndImage(e1Ds.geography.text);
            }
        }
    }

    private void technology(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.technology != null) {
            ES2Technology e2Technology;
            e2Ds.technology = e2Technology = new ES2Technology();
            e2Technology.technologyLevel = 3;
            if (e1Ds.technology.text != null) {
                e2Technology.comment = new TextAndImage(e1Ds.technology.text);
            }
        }
    }

    private void time(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.timePeriod != null) {
            ES2TimePeriod e2Time;
            e2Ds.timePeriod = e2Time = new ES2TimePeriod();
            if (e1Ds.timePeriod.startYear != null) {
                e2Time.startDate = e1Ds.timePeriod.startYear.toString() + "-01-01";
            }
            if (e1Ds.timePeriod.endYear != null) {
                e2Time.endDate = e1Ds.timePeriod.endYear.toString() + "-01-01";
            }
            if (e1Ds.timePeriod.dataValidForEntirePeriod != null) {
                e2Time.dataValidForEntirePeriod = e1Ds.timePeriod.dataValidForEntirePeriod;
            }
            if (e1Ds.timePeriod.text != null) {
                e2Time.comment = new TextAndImage(e1Ds.timePeriod.text);
            }
        }
    }

    private void economicScen(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        ES2MacroEconomicScenario scen;
        e2Ds.macroEconomicScenario = scen = new ES2MacroEconomicScenario();
        scen.scenarioId = "D9F57F0A-A01F-42eb-A57B-8F18D6635801";
        scen.getName().add(new LangString("Business-as-Usual"));
    }

    private void intermediateExchange(ES1Exchange e1Exchange, ES2Dataset e2Ds) {
        ES2IntermediateExchange i2Exchange = new ES2IntermediateExchange();
        e2Ds.getIntermediateExchanges().add(i2Exchange);
        i2Exchange.id = UUID.randomUUID().toString();
        if (e1Exchange.meanValue != null) {
            i2Exchange.amount = e1Exchange.meanValue;
        }
        i2Exchange.isCalculatedAmount = false;
        i2Exchange.intermediateExchangeId = UUID.randomUUID().toString();
        i2Exchange.getName().add(new LangString(e1Exchange.name));
        i2Exchange.getUnitNames().add(new LangString(e1Exchange.unit));
        if (e1Exchange.generalComment != null) {
            i2Exchange.getComment().add(new LangString(e1Exchange.generalComment));
        }
        if (e1Exchange.uncertaintyType != null) {
            i2Exchange.uncertainty = new ES2Uncertainty();
            switch (e1Exchange.uncertaintyType) {
                case 0: {
                    ES2UndefinedDistribution udistr;
                    i2Exchange.uncertainty.undefinedDistribution = udistr = new ES2UndefinedDistribution();
                    if (e1Exchange.maxValue != null) {
                        udistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue != null) {
                        udistr.minValue = e1Exchange.minValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    udistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 1: {
                    ES2LogNormalDistribution ldistr;
                    i2Exchange.uncertainty.logNormalDistribution = ldistr = new ES2LogNormalDistribution();
                    if (e1Exchange.meanValue != null) {
                        ldistr.meanValue = e1Exchange.meanValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    ldistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 2: {
                    ES2NormalDistribution ndistr;
                    i2Exchange.uncertainty.normalDistribution = ndistr = new ES2NormalDistribution();
                    if (e1Exchange.meanValue != null) {
                        ndistr.meanValue = e1Exchange.meanValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    ndistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 3: {
                    ES2TriangularDistribution tdistr;
                    i2Exchange.uncertainty.triangularDistribution = tdistr = new ES2TriangularDistribution();
                    if (e1Exchange.maxValue != null) {
                        tdistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue != null) {
                        tdistr.minValue = e1Exchange.minValue;
                    }
                    if (e1Exchange.mostLikelyValue == null) break;
                    tdistr.mostLikelyValue = e1Exchange.mostLikelyValue;
                    break;
                }
                case 4: {
                    ES2UniformDistribution uniDistr;
                    i2Exchange.uncertainty.uniformDistribution = uniDistr = new ES2UniformDistribution();
                    if (e1Exchange.maxValue != null) {
                        uniDistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue == null) break;
                    uniDistr.minValue = e1Exchange.minValue;
                    break;
                }
            }
        }
        i2Exchange.inputGroup = e1Exchange.inputGroup;
        i2Exchange.outputGroup = e1Exchange.outputGroup;
    }

    private void elementaryExchange(ES1Exchange e1Exchange, ES2Dataset e2Ds) {
        ES2ElementaryExchange e2Exchange = new ES2ElementaryExchange();
        e2Ds.getElementaryExchanges().add(e2Exchange);
        e2Exchange.id = UUID.randomUUID().toString();
        if (e1Exchange.meanValue != null) {
            e2Exchange.amount = e1Exchange.meanValue;
        }
        e2Exchange.isCalculatedAmount = false;
        e2Exchange.elementaryExchangeId = UUID.randomUUID().toString();
        e2Exchange.getName().add(new LangString(e1Exchange.name));
        e2Exchange.getUnitNames().add(new LangString(e1Exchange.unit));
        if (e1Exchange.generalComment != null) {
            e2Exchange.getComment().add(new LangString(e1Exchange.generalComment));
        }
        if (e1Exchange.CASNumber != null) {
            e2Exchange.casNumber = e1Exchange.CASNumber;
        }
        if (e1Exchange.formula != null) {
            e2Exchange.formula = e1Exchange.formula;
        }
        if (e1Exchange.uncertaintyType != null) {
            e2Exchange.uncertainty = new ES2Uncertainty();
            switch (e1Exchange.uncertaintyType) {
                case 0: {
                    ES2UndefinedDistribution udistr;
                    e2Exchange.uncertainty.undefinedDistribution = udistr = new ES2UndefinedDistribution();
                    if (e1Exchange.maxValue != null) {
                        udistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue != null) {
                        udistr.minValue = e1Exchange.minValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    udistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 1: {
                    ES2LogNormalDistribution ldistr;
                    e2Exchange.uncertainty.logNormalDistribution = ldistr = new ES2LogNormalDistribution();
                    if (e1Exchange.meanValue != null) {
                        ldistr.meanValue = e1Exchange.meanValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    ldistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 2: {
                    ES2NormalDistribution ndistr;
                    e2Exchange.uncertainty.normalDistribution = ndistr = new ES2NormalDistribution();
                    if (e1Exchange.meanValue != null) {
                        ndistr.meanValue = e1Exchange.meanValue;
                    }
                    if (e1Exchange.standardDeviation95 == null) break;
                    ndistr.standardDeviation95 = e1Exchange.standardDeviation95;
                    break;
                }
                case 3: {
                    ES2TriangularDistribution tdistr;
                    e2Exchange.uncertainty.triangularDistribution = tdistr = new ES2TriangularDistribution();
                    if (e1Exchange.maxValue != null) {
                        tdistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue != null) {
                        tdistr.minValue = e1Exchange.minValue;
                    }
                    if (e1Exchange.mostLikelyValue == null) break;
                    tdistr.mostLikelyValue = e1Exchange.mostLikelyValue;
                    break;
                }
                case 4: {
                    ES2UniformDistribution uniDistr;
                    e2Exchange.uncertainty.uniformDistribution = uniDistr = new ES2UniformDistribution();
                    if (e1Exchange.maxValue != null) {
                        uniDistr.maxValue = e1Exchange.maxValue;
                    }
                    if (e1Exchange.minValue == null) break;
                    uniDistr.minValue = e1Exchange.minValue;
                    break;
                }
            }
        }
        e2Exchange.inputGroup = e1Exchange.inputGroup;
        e2Exchange.outputGroup = e1Exchange.outputGroup;
    }

    private void representativeness(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.representativeness != null) {
            ES2Representativeness repri;
            e2Ds.representativeness = repri = new ES2Representativeness();
            repri.systemModelId = "8B738EA0-F89E-4627-8679-433616064E82";
            repri.getSystemModelName().add(new LangString("undefined"));
            if (e1Ds.representativeness.samplingProcedure != null) {
                repri.getSamplingProcedure().add(new LangString(e1Ds.representativeness.samplingProcedure));
            }
            if (e1Ds.representativeness.extrapolations != null) {
                repri.getExtrapolations().add(new LangString(e1Ds.representativeness.extrapolations));
            }
        }
    }

    private void review(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.validation != null) {
            ES1Person person;
            ES2Review review = new ES2Review();
            e2Ds.getReviews().add(review);
            Integer ref = e1Ds.validation.proofReadingValidator;
            if (ref != null && (person = e1Ds.getPerson(ref)) != null) {
                review.reviewerEmail = person.email;
                review.reviewerId = UUID.randomUUID().toString();
                review.reviewerName = person.name;
            }
            if (e1Ds.dataSetInformation != null) {
                review.reviewDate = e1Ds.dataSetInformation.timestamp;
            }
            if (e1Ds.validation.proofReadingDetails != null) {
                review.details = new TextAndImage(e1Ds.validation.proofReadingDetails);
            }
            if (e1Ds.validation.otherDetails != null) {
                review.getOtherDetails().add(new LangString(e1Ds.validation.otherDetails));
            }
        }
    }

    private void dataEntry(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.dataEntryBy != null) {
            ES1Person person;
            ES2Entry dataEntry;
            e2Ds.dataEntryBy = dataEntry = new ES2Entry();
            Integer ref = e1Ds.dataEntryBy.person;
            if (ref != null && (person = e1Ds.getPerson(ref)) != null) {
                dataEntry.personEmail = person.email;
                dataEntry.personId = UUID.randomUUID().toString();
                dataEntry.personName = person.name;
            }
        }
    }

    private void publication(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        if (e1Ds.dataGeneratorAndPublication != null) {
            ES1Source source;
            ES1Person person;
            ES2Publication publication;
            e2Ds.publication = publication = new ES2Publication();
            publication.accessRestrictedTo = e1Ds.dataGeneratorAndPublication.accessRestrictedTo;
            publication.companyCode = e1Ds.dataGeneratorAndPublication.companyCode;
            publication.dataPublishedIn = e1Ds.dataGeneratorAndPublication.dataPublishedIn;
            publication.isCopyrightProtected = e1Ds.dataGeneratorAndPublication.copyright;
            publication.pageNumbers = e1Ds.dataGeneratorAndPublication.pageNumbers;
            Integer ref = e1Ds.dataGeneratorAndPublication.person;
            if (ref != null && (person = e1Ds.getPerson(ref)) != null) {
                publication.personEmail = person.email;
                publication.personId = UUID.randomUUID().toString();
                publication.personName = person.name;
            }
            if ((ref = e1Ds.dataGeneratorAndPublication.referenceToPublishedSource) != null && (source = e1Ds.getSource(ref)) != null) {
                publication.publishedSourceFirstAuthor = source.firstAuthor;
                publication.publishedSourceId = UUID.randomUUID().toString();
                publication.publishedSourceYear = source.year != null ? source.year.toString() : null;
            }
        }
    }

    private void fileAttributes(ES1Dataset e1Ds, ES2Dataset e2Ds) {
        ES2FileAttributes atts;
        e2Ds.fileAttributes = atts = new ES2FileAttributes(true);
        atts.contextId = "DE659012-50C4-4e96-B54A-FC781BF987AB";
        atts.creationTimestamp = Time.now();
        atts.defaultLanguage = "en";
        atts.fileGenerator = "openLCA - data converter";
        atts.fileTimestamp = Time.now();
        atts.internalSchemaVersion = "2.0.8";
        atts.lastEditTimestamp = Time.now();
        atts.getContextNames().add(new LangString("ecoinvent"));
    }
}

