/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.ILCDExchangeAccumulator;
import org.openlca.olcatdb.conversion.ILCDHelper;
import org.openlca.olcatdb.conversion.KeyGen;
import org.openlca.olcatdb.conversion.ReferenceFactory;
import org.openlca.olcatdb.database.CompartmentMap;
import org.openlca.olcatdb.database.ES1CompartmentRec;
import org.openlca.olcatdb.database.ES1ElemFlowRec;
import org.openlca.olcatdb.database.ElemFlowMap;
import org.openlca.olcatdb.database.ILCDCompartmentRec;
import org.openlca.olcatdb.database.ILCDElemFlowRec;
import org.openlca.olcatdb.database.UnitMap;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.SourceType;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.ecospold1.ES1DataSetInformation;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Geography;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1ReferenceFunction;
import org.openlca.olcatdb.ecospold1.ES1Representativeness;
import org.openlca.olcatdb.ecospold1.ES1Source;
import org.openlca.olcatdb.ecospold1.ES1Technology;
import org.openlca.olcatdb.ecospold1.ES1TimePeriod;
import org.openlca.olcatdb.ilcd.ILCDClass;
import org.openlca.olcatdb.ilcd.ILCDClassification;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDContactDescription;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDEntry;
import org.openlca.olcatdb.ilcd.ILCDExchange;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDGeography;
import org.openlca.olcatdb.ilcd.ILCDProcess;
import org.openlca.olcatdb.ilcd.ILCDProcessDescription;
import org.openlca.olcatdb.ilcd.ILCDProcessEntry;
import org.openlca.olcatdb.ilcd.ILCDProcessMethod;
import org.openlca.olcatdb.ilcd.ILCDProcessPublication;
import org.openlca.olcatdb.ilcd.ILCDProcessTechnology;
import org.openlca.olcatdb.ilcd.ILCDPublication;
import org.openlca.olcatdb.ilcd.ILCDQuantitativeReference;
import org.openlca.olcatdb.ilcd.ILCDRepresentativeness;
import org.openlca.olcatdb.ilcd.ILCDReview;
import org.openlca.olcatdb.ilcd.ILCDReviewScope;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.ilcd.ILCDSourceDescription;
import org.openlca.olcatdb.ilcd.ILCDTime;
import org.openlca.olcatdb.ilcd.resources.ILCDFolder;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

class ES1ToILCDConversion
extends AbstractConversionImpl {
    private ILCDExchangeAccumulator accumulator = new ILCDExchangeAccumulator();
    private Map<String, ILCDExchange> exchangesByFlow = new HashMap<String, ILCDExchange>();
    private String langCode = "en";
    private String localLangCode = "de";
    private HashMap<Integer, DataSetReference> sourceRefs = new HashMap();
    private HashMap<Integer, DataSetReference> contactRefs = new HashMap();
    private ILCDFolder ilcdFolder;

    ES1ToILCDConversion() {
    }

    @Override
    protected void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.ilcdFolder = new ILCDFolder(targetDir);
        this.ilcdFolder.createContent();
        this.logFile(this.ilcdFolder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.ilcdFolder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES1EcoSpold ecoSpold = parser.getContext(ES1EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES1Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference;
                    if (!dataset.isProcess() || (reference = this.convert(dataset)) == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private DataSetReference convert(ES1Dataset dataset) {
        this.pullLanguageCodes(dataset);
        this.sources(dataset);
        this.contacts(dataset);
        ILCDProcess process = new ILCDProcess();
        this.dataSetInfo(dataset, process);
        this.quantReferefence(dataset, process);
        this.time(dataset, process);
        this.geography(dataset, process);
        this.technology(dataset, process);
        this.method(dataset, process);
        this.representativeness(dataset, process);
        this.validation(dataset, process);
        this.adminInfo(dataset, process);
        this.publication(dataset, process);
        this.exchanges(dataset, process);
        this.sourceRefs.clear();
        this.contactRefs.clear();
        DataSetReference reference = new DataSetReference();
        reference.setRefObjectId(process.description.uuid);
        reference.setType(ILCDDataSetType.Process.toString());
        reference.setVersion("01.00.000");
        File f = this.ilcdFolder.file(reference);
        if (f.exists()) {
            this.logger.severe("The file " + f.getAbsoluteFile() + " already exists.");
            return null;
        }
        XmlOutputter outputter = new XmlOutputter();
        outputter.output((Object)process, TemplateType.ILCDProcess, f, true);
        reference.setUri(f.toURI().toString());
        reference.setName(process.description.getName().get(0).getValue());
        return reference;
    }

    private void contacts(ES1Dataset dataset) {
        for (ES1Person ePerson : dataset.getPersons()) {
            if (ePerson.number == null) continue;
            String[] uuidArgs = new String[]{ePerson.address, ePerson.name, ePerson.companyCode, ePerson.countryCode, Integer.toString(ePerson.number)};
            String pUUID = KeyGen.getPseodoUUID(uuidArgs);
            String name = ePerson.name != null ? ePerson.name : "no name";
            DataSetReference ref = new DataSetReference();
            ref.setRefObjectId(pUUID);
            ref.setName(name);
            ref.setType(ILCDDataSetType.Contact.toString());
            ref.setUri("../contacts/" + pUUID + ".xml");
            ref.setVersion("01.00.000");
            ref.getDescription().add(new LangString(name));
            this.contactRefs.put(ePerson.number, ref);
            if (this.ilcdFolder.exists(ref)) continue;
            this.contact(ePerson, ref);
        }
    }

    private void contact(ES1Person ePerson, DataSetReference ref) {
        ILCDPublication publication;
        ILCDEntry entry;
        ILCDContactDescription description;
        ILCDContact contact = new ILCDContact();
        contact.description = description = new ILCDContactDescription();
        description.uuid = ref.getRefObjectId();
        description.getShortName().add(new LangString(this.langCode, ePerson.name));
        String name = ePerson.name + " (" + ePerson.companyCode + ")";
        description.getName().add(new LangString(this.langCode, name));
        ILCDClassification classification = new ILCDClassification();
        ILCDClass clazz = new ILCDClass();
        clazz.id = "4";
        clazz.level = 0;
        clazz.name = "Persons";
        classification.getClasses().add(clazz);
        description.getClassifications().add(classification);
        description.getContactAddress().add(new LangString(this.langCode, ePerson.address + ", " + ePerson.countryCode));
        description.email = ePerson.email;
        description.telefax = ePerson.telefax;
        description.telephone = ePerson.telephone;
        contact.entry = entry = new ILCDEntry();
        entry.timestamp = Time.now();
        entry.getDataSetFormats().add(ReferenceFactory.ILCD_FORMAT.createReference());
        entry.getDataSetFormats().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
        contact.publication = publication = new ILCDPublication();
        publication.dataSetVersion = ref.getVersion();
        publication.permanentDataSetURI = ref.getUri();
        File outFile = this.ilcdFolder.file(ref);
        XmlOutputter outputter = new XmlOutputter();
        outputter.output((Object)contact, TemplateType.ILCDContact, outFile, true);
        DataSetReference cRef = ref.copy();
        cRef.setUri(outFile.toURI().toString());
        this.createdFiles.add(cRef);
    }

    private void sources(ES1Dataset dataset) {
        for (ES1Source eSource : dataset.getSources()) {
            if (eSource.number == null) continue;
            String[] uuidArgs = new String[]{eSource.title, eSource.firstAuthor, eSource.additionalAuthors, eSource.placeOfPublications, Integer.toString(eSource.number)};
            String pUUID = KeyGen.getPseodoUUID(uuidArgs);
            String shortName = "";
            if (eSource.firstAuthor != null) {
                shortName = shortName + eSource.firstAuthor;
            }
            if (eSource.additionalAuthors != null) {
                shortName = shortName + " et. al.";
            }
            if (eSource.year != null) {
                shortName = shortName + " (" + eSource.year + ")";
            }
            DataSetReference ref = new DataSetReference();
            ref.setRefObjectId(pUUID);
            ref.setName(shortName);
            ref.setType(ILCDDataSetType.Source.toString());
            ref.setUri("../sources/" + pUUID + ".xml");
            ref.setVersion("01.00.000");
            ref.getDescription().add(new LangString(shortName));
            this.sourceRefs.put(eSource.number, ref);
            if (this.ilcdFolder.exists(ref)) continue;
            this.source(eSource, ref);
        }
    }

    private void source(ES1Source eSource, DataSetReference ref) {
        ILCDPublication publication;
        ILCDEntry entry;
        String citation;
        ILCDSourceDescription iDescription;
        ILCDSource iSource = new ILCDSource();
        iSource.description = iDescription = new ILCDSourceDescription();
        if (eSource.sourceType != null) {
            String sourceType = null;
            switch (eSource.sourceType) {
                case 0: {
                    sourceType = "Undefined";
                    break;
                }
                case 1: {
                    sourceType = "Article in periodical";
                    break;
                }
                case 2: {
                    sourceType = "Chapter in anthology";
                    break;
                }
                case 3: {
                    sourceType = "Monograph";
                    break;
                }
                case 4: {
                    sourceType = "Direct measurement";
                    break;
                }
                case 5: {
                    sourceType = "Oral communication";
                    break;
                }
                case 6: {
                    sourceType = "Personal written communication";
                    break;
                }
                case 7: {
                    sourceType = "Questionnaire";
                    break;
                }
            }
            iDescription.publicationType = sourceType;
        }
        iDescription.uuid = ref.getRefObjectId();
        String shortName = "";
        if (eSource.firstAuthor != null) {
            shortName = shortName + eSource.firstAuthor;
        }
        if (eSource.additionalAuthors != null) {
            shortName = shortName + " et. al.";
        }
        if (eSource.year != null) {
            shortName = shortName + " (" + eSource.year + ")";
        }
        iDescription.getShortName().add(new LangString(shortName));
        ILCDClassification classification = new ILCDClassification();
        ILCDClass clazz = new ILCDClass();
        clazz.id = "5";
        clazz.level = 0;
        clazz.name = "Publications and communications";
        classification.getClasses().add(clazz);
        iDescription.getClassifications().add(classification);
        String string = citation = eSource.firstAuthor == null ? "" : eSource.firstAuthor;
        if (eSource.additionalAuthors != null) {
            citation = citation + ", " + eSource.additionalAuthors;
        }
        if (eSource.title != null) {
            citation = citation + ": " + eSource.title + ". ";
        }
        if (eSource.placeOfPublications != null) {
            citation = citation + eSource.placeOfPublications;
        }
        if (eSource.year != null) {
            citation = citation + " " + eSource.year;
        }
        iDescription.sourceCitation = citation;
        if (eSource.sourceType != null) {
            String publType;
            iDescription.publicationType = publType = SourceType.fromEcoSpoldCode(eSource.sourceType).getILCDName();
        }
        iSource.entry = entry = new ILCDEntry();
        entry.timestamp = Time.now();
        entry.getDataSetFormats().add(ReferenceFactory.ILCD_FORMAT.createReference());
        entry.getDataSetFormats().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
        iSource.publication = publication = new ILCDPublication();
        publication.dataSetVersion = ref.getVersion();
        publication.permanentDataSetURI = ref.getUri();
        File outFile = this.ilcdFolder.file(ref);
        XmlOutputter outputter = new XmlOutputter();
        outputter.output((Object)iSource, TemplateType.ILCDSource, outFile, true);
        DataSetReference cRef = ref.copy();
        cRef.setUri(outFile.toURI().toString());
        this.createdFiles.add(cRef);
    }

    private void dataSetInfo(ES1Dataset eDataset, ILCDProcess iProcess) {
        ES1ReferenceFunction refFun;
        ILCDProcessDescription iDescription;
        iProcess.description = iDescription = new ILCDProcessDescription();
        String[] args = new String[5];
        if (eDataset.referenceFunction != null) {
            String loc = "GLO";
            if (eDataset.geography != null && eDataset.geography.location != null) {
                loc = eDataset.geography.location;
            }
            ES1ReferenceFunction refFun2 = eDataset.referenceFunction;
            args[0] = loc + refFun2.name;
            args[1] = refFun2.category;
            args[2] = refFun2.subCategory;
            args[3] = refFun2.unit;
            args[4] = refFun2.infrastructureProcess == null ? "false" : refFun2.infrastructureProcess.toString();
        }
        iDescription.uuid = KeyGen.getPseodoUUID(args);
        if (eDataset.referenceFunction != null) {
            refFun = eDataset.referenceFunction;
            if (refFun.name != null) {
                iDescription.getName().add(new LangString(this.langCode, refFun.name));
            }
            if (refFun.localName != null) {
                iDescription.getName().add(new LangString(this.localLangCode, refFun.localName));
            }
        }
        if (eDataset.referenceFunction != null && !(refFun = eDataset.referenceFunction).getSynonyms().isEmpty()) {
            String synonyms = "";
            Iterator<String> it = refFun.getSynonyms().iterator();
            while (it.hasNext()) {
                String s = it.next();
                synonyms = synonyms + s;
                if (!it.hasNext()) continue;
                synonyms = synonyms + "; ";
            }
            iDescription.getSynonyms().add(new LangString(this.langCode, synonyms));
        }
        if (eDataset.referenceFunction != null && eDataset.referenceFunction.category != null) {
            refFun = eDataset.referenceFunction;
            ILCDClassification classification = new ILCDClassification();
            ILCDClass ilcdClass = new ILCDClass();
            ilcdClass.id = UUID.randomUUID().toString();
            ilcdClass.level = 0;
            ilcdClass.name = refFun.category;
            classification.getClasses().add(ilcdClass);
            if (refFun.subCategory != null) {
                ilcdClass = new ILCDClass();
                ilcdClass.id = UUID.randomUUID().toString();
                ilcdClass.level = 1;
                ilcdClass.name = refFun.subCategory;
                classification.getClasses().add(ilcdClass);
            }
            iDescription.getClassifications().add(classification);
        }
        if (eDataset.referenceFunction != null) {
            refFun = eDataset.referenceFunction;
            if (refFun.generalComment != null) {
                iDescription.getComment().add(new LangString(this.langCode, refFun.generalComment));
            }
        }
    }

    private void quantReferefence(ES1Dataset eDataset, ILCDProcess iProcess) {
        ILCDQuantitativeReference qRef;
        iProcess.quantitativeReference = qRef = new ILCDQuantitativeReference();
        Integer refExchange = null;
        for (ES1Exchange eExchange : eDataset.getExchanges()) {
            if (eExchange.outputGroup == null || eExchange.outputGroup != 0) continue;
            refExchange = eExchange.number;
        }
        if (refExchange != null) {
            qRef.type = "Reference flow(s)";
            qRef.getReferenceFlows().add(refExchange);
        } else {
            qRef.type = "Functional unit";
            String fu = "";
            if (eDataset.referenceFunction != null) {
                fu = fu + eDataset.referenceFunction.name + ", ";
                fu = fu + eDataset.referenceFunction.amount + " ";
                fu = fu + eDataset.referenceFunction.unit;
            }
            qRef.getFunctionalUnits().add(new LangString(this.langCode, ""));
        }
    }

    private void time(ES1Dataset eDataset, ILCDProcess iProcess) {
        XMLGregorianCalendar calendar;
        String timeString;
        ES1TimePeriod eTime;
        ILCDTime iTime;
        iProcess.time = iTime = new ILCDTime();
        if (eDataset.timePeriod != null) {
            eTime = eDataset.timePeriod;
            if (eTime.startYear != null) {
                iTime.referenceYear = eTime.startYear;
            } else {
                timeString = null;
                timeString = eTime.startYearMonth != null ? eTime.startYearMonth : eTime.startDate;
                if (timeString != null) {
                    try {
                        calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(timeString);
                        iTime.referenceYear = calendar.getYear();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (eDataset.timePeriod != null) {
            eTime = eDataset.timePeriod;
            if (eTime.endYear != null) {
                iTime.validUntil = eTime.endYear;
            } else {
                timeString = null;
                timeString = eTime.endYearMonth != null ? eTime.endYearMonth : eTime.endDate;
                if (timeString != null) {
                    try {
                        calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(timeString);
                        iTime.validUntil = calendar.getYear();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (eDataset.timePeriod != null && eDataset.timePeriod.text != null) {
            eTime = eDataset.timePeriod;
            iTime.getDescription().add(new LangString(this.langCode, eTime.text));
        }
    }

    private void geography(ES1Dataset eDataset, ILCDProcess iProcess) {
        ILCDGeography iGeography;
        iProcess.geography = iGeography = new ILCDGeography();
        if (eDataset.geography != null) {
            ES1Geography eGeography = eDataset.geography;
            if (eGeography.location != null) {
                iGeography.location = eGeography.location;
            }
            if (eGeography.text != null) {
                iGeography.getDescription().add(new LangString(this.langCode, eGeography.text));
            }
        }
    }

    private void technology(ES1Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessTechnology iTechnology;
        iProcess.technology = iTechnology = new ILCDProcessTechnology();
        if (eDataset.referenceFunction != null) {
            ES1ReferenceFunction refFun = eDataset.referenceFunction;
            if (refFun.includedProcesses != null) {
                iTechnology.getDescription().add(new LangString(this.langCode, refFun.includedProcesses));
            }
        }
        if (eDataset.technology != null) {
            ES1Technology eTech = eDataset.technology;
            if (eTech.text != null) {
                iTechnology.getApplicability().add(new LangString(this.langCode, eTech.text));
            }
        }
    }

    private void method(ES1Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessMethod iMethod;
        iProcess.method = iMethod = new ILCDProcessMethod();
        iMethod.lciMethodPrinciple = "Other";
        iMethod.getDeviationsFromLCIMethodApproaches().add(new LangString("None"));
        iMethod.getDeviationsFromLCIMethodPrinciple().add(new LangString("None"));
        iMethod.getDeviationsFromModellingConstants().add(new LangString("None"));
        iMethod.getLciMethodApproaches().add("Other");
        if (this.isFromEcoinvent(eDataset)) {
            iMethod.getModellingConstants().add(new LangString("See the ecoinvent reports at http://www.ecoinvent.org."));
            iMethod.getMethodDetails().add(ReferenceFactory.ECOINVENT_METHODIC.createReference());
        }
        if (eDataset.dataSetInformation != null) {
            ES1DataSetInformation eInformation = eDataset.dataSetInformation;
            if (eInformation.type != null) {
                String ilcdType = null;
                switch (eInformation.type) {
                    case 1: {
                        ilcdType = "Unit process, single operation";
                        break;
                    }
                    case 2: {
                        ilcdType = "LCI result";
                        break;
                    }
                    case 5: {
                        ilcdType = "Unit process, black box";
                        break;
                    }
                }
                iMethod.dataSetType = ilcdType;
            }
        }
    }

    private void representativeness(ES1Dataset eDataset, ILCDProcess iProcess) {
        ILCDRepresentativeness repri;
        iProcess.representativeness = repri = new ILCDRepresentativeness();
        LangString none = new LangString("None");
        repri.getDeviationsFromCutOffPrinciples().add(none);
        repri.getDeviationsFromDataSelectionPrinciples().add(none);
        repri.getDeviationsFromExtrapolationPrinciples().add(none);
        if (this.isFromEcoinvent(eDataset)) {
            LangString report = new LangString("See the ecoinvent methodology report.");
            repri.getCutOffPrinciples().add(report);
            repri.getDataHandlingPrinciples().add(ReferenceFactory.ECOINVENT_METHODIC.createReference());
            repri.getDataSelectionPrinciples().add(report);
        }
        if (eDataset.representativeness != null) {
            ES1Representativeness eRepresentativeness = eDataset.representativeness;
            if (eRepresentativeness.percent != null) {
                repri.percent = eRepresentativeness.percent;
            }
            if (eRepresentativeness.productionVolume != null) {
                repri.getProductionVolume().add(new LangString(this.langCode, eRepresentativeness.productionVolume));
            }
            if (eRepresentativeness.samplingProcedure != null) {
                repri.getSamplingProcedure().add(new LangString(this.langCode, eRepresentativeness.samplingProcedure));
            }
            if (eRepresentativeness.extrapolations != null) {
                repri.getExtrapolationPrinciples().add(new LangString(this.langCode, eRepresentativeness.extrapolations));
            }
            if (eRepresentativeness.uncertaintyAdjustments != null) {
                repri.getUncertaintyAdjustments().add(new LangString(this.langCode, eRepresentativeness.uncertaintyAdjustments));
            }
        }
        for (DataSetReference ref : this.sourceRefs.values()) {
            repri.getDataSources().add(ref);
        }
        String use = "This data set was automatically converted with the openLCA data converter. Before you use this data set you should check the entries and the compliance with the ILCD conformity. You can edit this data set with the ILCD Editor freely available at http://lct.jrc.ec.europa.eu/assessment/tools.";
        repri.getUseAdviceForDataSet().add(new LangString(use));
    }

    private void validation(ES1Dataset eDataset, ILCDProcess iProcess) {
        if (eDataset.validation != null) {
            DataSetReference ref;
            Integer val;
            ILCDReview review = new ILCDReview();
            iProcess.getReviews().add(review);
            if (this.isFromEcoinvent(eDataset)) {
                review.type = "Independent internal review";
                ILCDReviewScope scope = new ILCDReviewScope();
                scope.name = "Documentation";
                scope.getMethods().add("Expert judgement");
                review.getScopes().add(scope);
                scope = new ILCDReviewScope();
                scope.name = "Life cycle inventory methods";
                scope.getMethods().add("Expert judgement");
                scope.getMethods().add("Sample tests on calculations");
                review.getScopes().add(scope);
                review.getReviewers().add(ReferenceFactory.ECOINVENT_CENTER.createReference());
            }
            if (eDataset.validation.proofReadingDetails != null) {
                review.getDetails().add(new LangString(eDataset.validation.proofReadingDetails));
            }
            if (eDataset.validation.otherDetails != null) {
                review.getOtherDetails().add(new LangString(eDataset.validation.otherDetails));
            }
            if ((val = eDataset.validation.proofReadingValidator) != null && (ref = this.contactRefs.get(val)) != null) {
                review.getReviewers().add(ref);
            }
        }
    }

    private void adminInfo(ES1Dataset eDataset, ILCDProcess iProcess) {
        DataSetReference ref;
        Integer val;
        ILCDProcessEntry iEntry;
        DataSetReference ref2;
        Integer val2;
        if (eDataset.dataGeneratorAndPublication != null && (val2 = eDataset.dataGeneratorAndPublication.person) != null && (ref2 = this.contactRefs.get(val2)) != null) {
            iProcess.getDataGenerators().add(ref2);
        }
        iProcess.entry = iEntry = new ILCDProcessEntry();
        if (eDataset.dataSetInformation != null) {
            iEntry.timeStamp = eDataset.dataSetInformation.timestamp;
        }
        if (eDataset.dataEntryBy != null && (val = eDataset.dataEntryBy.person) != null && (ref = this.contactRefs.get(val)) != null) {
            iEntry.dataSetEntryReference = ref;
        }
        iEntry.getDataFormatReferences().add(ReferenceFactory.ILCD_FORMAT.createReference());
        iEntry.getDataFormatReferences().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
    }

    private void publication(ES1Dataset eDataset, ILCDProcess iProcess) {
        DataSetReference ref;
        Integer val;
        ILCDProcessPublication iPublication;
        iProcess.publication = iPublication = new ILCDProcessPublication();
        if (eDataset.dataSetInformation != null && eDataset.dataSetInformation.version != null) {
            Double vers = eDataset.dataSetInformation.version;
            iPublication.dataSetVersion = new DecimalFormat("00.00", DecimalFormatSymbols.getInstance(Locale.US)).format(vers);
        }
        if (this.isFromEcoinvent(eDataset)) {
            iPublication.permanentDataSetURI = "http://ecoinvent.org";
        }
        iPublication.lastRevision = eDataset.timestamp;
        if (this.isFromEcoinvent(eDataset)) {
            iPublication.ownershipReference = ReferenceFactory.ECOINVENT_CENTER.createReference();
        }
        if (eDataset.dataGeneratorAndPublication != null && (val = eDataset.dataGeneratorAndPublication.referenceToPublishedSource) != null && (ref = this.sourceRefs.get(val)) != null) {
            iPublication.republicationReference = ref;
        }
        if (eDataset.dataGeneratorAndPublication != null) {
            iPublication.copyright = eDataset.dataGeneratorAndPublication.copyright;
        }
        if (this.isFromEcoinvent(eDataset)) {
            iPublication.registrationAuthorityReference = ReferenceFactory.ECOINVENT_CENTER.createReference();
            if (eDataset.number != null) {
                iPublication.registrationNumber = Integer.toString(eDataset.number);
            }
        }
    }

    private void exchanges(ES1Dataset eDataset, ILCDProcess iProcess) {
        for (ES1Exchange eExchange : eDataset.getExchanges()) {
            double factor;
            ILCDExchange iExchange = new ILCDExchange();
            iExchange.id = eExchange.number;
            iExchange.dataDerivationType = "Unknown derivation";
            iExchange.dataSourceType = "Mixed primary / secondary";
            iExchange.direction = eExchange.inputGroup != null ? "Input" : "Output";
            iExchange.location = eExchange.location;
            if (eExchange.generalComment != null) {
                iExchange.getComment().add(new LangString(this.langCode, eExchange.generalComment));
            }
            if ((factor = this.flowDispatch(eExchange, iExchange)) == 0.0) {
                this.logger.severe("No conversion factor: " + eExchange.toString());
            } else {
                this.numericValues(eExchange, iExchange, factor);
            }
            ILCDExchange existing = this.exchangesByFlow.get(iExchange.flowDataSet.getRefObjectId());
            if (existing == null) {
                iProcess.getExchanges().add(iExchange);
                this.exchangesByFlow.put(iExchange.flowDataSet.getRefObjectId(), iExchange);
                continue;
            }
            this.accumulator.accumulate(existing, iExchange);
        }
    }

    private double flowDispatch(ES1Exchange eExchange, ILCDExchange iExchange) {
        ES1ElemFlowRec flowRec;
        ElemFlowMap.Entry flowEntry;
        double factor = 0.0;
        factor = !eExchange.isElementaryFlow() ? this.productFlow(eExchange, iExchange) : ((flowEntry = ElemFlowMap.es1ToILCD(eExchange.name, eExchange.category, eExchange.subCategory, eExchange.unit)) != null ? this.assignedElemFlow(flowEntry, iExchange) : ((flowRec = ES1ElemFlowRec.forAtts(eExchange.name, eExchange.category, eExchange.subCategory, eExchange.unit)) != null ? this.unassignedElemFlow(flowRec, iExchange) : this.unknownElemFlow(eExchange, iExchange)));
        return factor;
    }

    private double assignedElemFlow(ElemFlowMap.Entry mapEntry, ILCDExchange iExchange) {
        DataSetReference ref;
        ILCDElemFlowRec flowRec = ILCDElemFlowRec.forID(mapEntry.getFlowId());
        if (flowRec == null) {
            this.logger.severe("Cannot load ILCD flow for ID: " + mapEntry.getFlowId());
            return 0.0;
        }
        iExchange.flowDataSet = ref = flowRec.toReference();
        if (!this.ilcdFolder.exists(ref)) {
            ILCDHelper.writeFlow(this.ilcdFolder, ref, flowRec.toFlow(), this.createdFiles);
        }
        return mapEntry.getFactor();
    }

    private double unassignedElemFlow(ES1ElemFlowRec flowRec, ILCDExchange iExchange) {
        DataSetReference ref;
        String[] keyArgs = new String[]{flowRec.getName(), flowRec.getCas(), flowRec.getFormula(), Integer.toString(flowRec.getId()), Integer.toString(flowRec.getCompartmentId())};
        String pUUID = KeyGen.getPseodoUUID(keyArgs);
        iExchange.flowDataSet = ref = ILCDHelper.newFlowRef(pUUID, flowRec.getName());
        UnitMap.Entry unitEntry = UnitMap.es1ToILCD(flowRec.getUnit());
        if (unitEntry == null) {
            this.logger.severe("Unknown unit " + flowRec.getUnit());
            return 0.0;
        }
        if (!this.ilcdFolder.exists(ref)) {
            ILCDFlow flow = ILCDHelper.makeFlow(pUUID, flowRec.getName(), flowRec.getCas(), flowRec.getFormula(), "Elementary flow", unitEntry);
            ILCDCompartmentRec rec = CompartmentMap.es1ToILCD(flowRec.getCompartmentId());
            if (rec == null) {
                this.logger.severe("No correspondig ILCD compartment for " + flowRec.getCompartmentId());
            } else {
                flow.description.getElemFlowCategorizations().add(rec.toCategorization());
            }
            ILCDHelper.writeFlow(this.ilcdFolder, ref, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private double unknownElemFlow(ES1Exchange eExchange, ILCDExchange iExchange) {
        DataSetReference ref;
        String[] keyArgs = new String[]{eExchange.name, eExchange.category, eExchange.subCategory, eExchange.unit, eExchange.CASNumber};
        String pUUID = KeyGen.getPseodoUUID(keyArgs);
        iExchange.flowDataSet = ref = ILCDHelper.newFlowRef(pUUID, eExchange.name);
        UnitMap.Entry unitEntry = UnitMap.es1ToILCD(eExchange.unit);
        if (unitEntry == null) {
            this.logger.severe("Unknown unit " + eExchange.unit);
            return 0.0;
        }
        if (!this.ilcdFolder.exists(ref)) {
            ILCDFlow flow = ILCDHelper.makeFlow(pUUID, eExchange.name, eExchange.CASNumber, eExchange.formula, "Elementary flow", unitEntry);
            ES1CompartmentRec eRec = ES1CompartmentRec.forNames(eExchange.category, eExchange.subCategory);
            ILCDCompartmentRec iRec = null;
            if (eRec != null) {
                iRec = CompartmentMap.es1ToILCD(eRec.getId());
            }
            if (iRec == null) {
                this.logger.severe("No correspondig ILCD compartment for " + eExchange.category + "/" + eExchange.subCategory);
            } else {
                flow.description.getElemFlowCategorizations().add(iRec.toCategorization());
            }
            ILCDHelper.writeFlow(this.ilcdFolder, ref, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private double productFlow(ES1Exchange eExchange, ILCDExchange iExchange) {
        DataSetReference ref;
        String[] keyArgs = new String[]{eExchange.name + eExchange.infrastructureProcess, eExchange.category, eExchange.subCategory, eExchange.unit, eExchange.location};
        String pUUID = KeyGen.getPseodoUUID(keyArgs);
        iExchange.flowDataSet = ref = ILCDHelper.newFlowRef(pUUID, eExchange.name);
        UnitMap.Entry unitEntry = UnitMap.es1ToILCD(eExchange.unit);
        if (unitEntry == null) {
            this.logger.severe("Unknown unit " + eExchange.unit);
            return 0.0;
        }
        if (!this.ilcdFolder.exists(ref)) {
            ILCDFlow flow = ILCDHelper.makeFlow(pUUID, eExchange.name, eExchange.CASNumber, eExchange.formula, "Product flow", unitEntry);
            if (eExchange.category != null) {
                ILCDClassification classification = new ILCDClassification();
                flow.description.getClassifications().add(classification);
                ILCDClass clazz = new ILCDClass();
                classification.getClasses().add(clazz);
                clazz.id = UUID.randomUUID().toString();
                clazz.level = 0;
                clazz.name = eExchange.category;
                if (eExchange.subCategory != null) {
                    clazz = new ILCDClass();
                    classification.getClasses().add(clazz);
                    clazz.id = UUID.randomUUID().toString();
                    clazz.level = 1;
                    clazz.name = eExchange.subCategory;
                }
            }
            ILCDHelper.writeFlow(this.ilcdFolder, ref, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private void numericValues(ES1Exchange eExchange, ILCDExchange iExchange, double factor) {
        if (eExchange.uncertaintyType == null || eExchange.uncertaintyType == 0) {
            if (eExchange.meanValue != null) {
                iExchange.resultingAmount = iExchange.meanAmount = Double.valueOf(factor * eExchange.meanValue);
            }
        } else if (eExchange.uncertaintyType == 1) {
            iExchange.uncertaintyDistribution = "log-normal";
            if (eExchange.meanValue != null) {
                iExchange.resultingAmount = iExchange.meanAmount = Double.valueOf(factor * eExchange.meanValue);
            }
            if (eExchange.standardDeviation95 != null) {
                iExchange.relStdDeviation95In = eExchange.standardDeviation95;
            }
        } else if (eExchange.uncertaintyType == 2) {
            iExchange.uncertaintyDistribution = "normal";
            if (eExchange.meanValue != null) {
                iExchange.resultingAmount = iExchange.meanAmount = Double.valueOf(factor * eExchange.meanValue);
            }
            if (eExchange.standardDeviation95 != null) {
                iExchange.relStdDeviation95In = factor * eExchange.standardDeviation95;
            }
        } else if (eExchange.uncertaintyType == 3) {
            iExchange.uncertaintyDistribution = "triangular";
            if (eExchange.meanValue != null) {
                iExchange.resultingAmount = iExchange.meanAmount = Double.valueOf(factor * eExchange.meanValue);
            }
            if (eExchange.maxValue != null) {
                iExchange.maximumAmount = factor * eExchange.maxValue;
            }
            if (eExchange.minValue != null) {
                iExchange.minimumAmount = factor * eExchange.minValue;
            }
        } else if (eExchange.uncertaintyType == 4) {
            iExchange.uncertaintyDistribution = "uniform";
            if (eExchange.meanValue != null) {
                iExchange.resultingAmount = iExchange.meanAmount = Double.valueOf(factor * eExchange.meanValue);
            }
            if (eExchange.maxValue != null) {
                iExchange.maximumAmount = factor * eExchange.maxValue;
            }
            if (eExchange.minValue != null) {
                iExchange.minimumAmount = factor * eExchange.minValue;
            }
        }
    }

    private void pullLanguageCodes(ES1Dataset dataset) {
        this.langCode = "en";
        this.localLangCode = "de";
        ES1DataSetInformation dataSetInfo = dataset.dataSetInformation;
        if (dataSetInfo != null) {
            if (dataSetInfo.languageCode != null) {
                this.langCode = dataSetInfo.languageCode.toLowerCase();
            }
            if (dataSetInfo.localLanguageCode != null) {
                this.localLangCode = dataSetInfo.localLanguageCode.toLowerCase();
            }
        }
    }

    private boolean isFromEcoinvent(ES1Dataset dataset) {
        return dataset != null && dataset.dataEntryBy != null && dataset.dataEntryBy.qualityNetwork != null && dataset.dataEntryBy.qualityNetwork == 1;
    }
}

