/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.ES1SimaProValidConversion;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.datatypes.TypeCheck;
import org.openlca.olcatdb.ecospold1.ES1DataEntryBy;
import org.openlca.olcatdb.ecospold1.ES1DataGeneratorAndPublication;
import org.openlca.olcatdb.ecospold1.ES1DataSetInformation;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Geography;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1ReferenceFunction;
import org.openlca.olcatdb.ecospold1.ES1Representativeness;
import org.openlca.olcatdb.ecospold1.ES1Source;
import org.openlca.olcatdb.ecospold1.ES1Technology;
import org.openlca.olcatdb.ecospold1.ES1TimePeriod;
import org.openlca.olcatdb.ecospold1.ES1Validation;
import org.openlca.olcatdb.ecospold1.resources.ES1Folder;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2Review;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

class ES2ToES1Conversion
extends AbstractConversionImpl {
    private boolean simaProConform = false;
    private ES1SimaProValidConversion simaProConverter;
    private ES1Folder es1Folder = null;
    private HashMap<String, ES1Person> createdPersons = new HashMap();
    private HashMap<String, ES1Source> createdSources = new HashMap();

    public ES2ToES1Conversion() {
    }

    public ES2ToES1Conversion(boolean simaProConform) {
        this.simaProConform = simaProConform;
        if (simaProConform) {
            this.simaProConverter = new ES1SimaProValidConversion();
        }
    }

    @Override
    public void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.es1Folder = new ES1Folder(targetDir);
        this.es1Folder.createContent();
        this.logFile(this.es1Folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.es1Folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES2EcoSpold ecoSpold = parser.getContext(ES2EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference = this.convert(dataset);
                    if (reference == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.simaProConform) {
            try {
                this.simaProConverter.getMappingFile().writeToFile(this.targetDir.getAbsolutePath() + File.separator + "mapping.SPMapping");
            }
            catch (IOException e) {
                this.logger.severe("IO exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
        this.createdPersons.clear();
        this.createdSources.clear();
    }

    private DataSetReference convert(ES2Dataset dataset) {
        this.createdPersons.clear();
        this.createdSources.clear();
        ES1EcoSpold ecoSpold = new ES1EcoSpold();
        ES1Dataset e1Ds = new ES1Dataset();
        ecoSpold.getDatasets().add(e1Ds);
        this.dataSetAtts(dataset, e1Ds);
        this.referenceFunction(dataset, e1Ds);
        this.geography(dataset, e1Ds);
        this.technology(dataset, e1Ds);
        this.timePeriod(dataset, e1Ds);
        this.dataSetInfo(dataset, e1Ds);
        this.representativeness(dataset, e1Ds);
        this.dataEntry(dataset, e1Ds);
        this.publication(dataset, e1Ds);
        this.exchanges(dataset, e1Ds);
        String uuid = null;
        uuid = dataset.description != null && dataset.description.id != null ? dataset.description.id : UUID.randomUUID().toString();
        String name = null;
        name = e1Ds.referenceFunction != null && e1Ds.referenceFunction.name != null ? e1Ds.referenceFunction.name : "no name";
        if (this.simaProConform) {
            for (ES1Dataset es1DataSet : ecoSpold.getDatasets()) {
                this.simaProConverter.validate(es1DataSet);
                this.simaProConverter.processForMappingFile(es1DataSet);
            }
        }
        DataSetReference ref = null;
        File outFile = new File(this.es1Folder.getProcessFolder(), uuid + ".xml");
        if (outFile.exists()) {
            this.logger.severe("The file " + outFile.getAbsolutePath() + " already exists.");
        } else {
            XmlOutputter outputter = new XmlOutputter();
            outputter.output((Object)ecoSpold, TemplateType.EcoSpold01, outFile, true);
            ref = new DataSetReference();
            ref.setName(name);
            ref.setUri(outFile.toURI().toString());
            ref.setRefObjectId(uuid);
            ref.setType(ILCDDataSetType.Process.toString());
            ref.setVersion("01.00.000");
        }
        return ref;
    }

    private void dataSetAtts(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        e1Ds.generator = "openLCA - data converter";
        e1Ds.number = 1;
        e1Ds.timestamp = Time.now();
    }

    private void referenceFunction(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        ES1ReferenceFunction refFunction;
        e1Ds.referenceFunction = refFunction = new ES1ReferenceFunction();
        if (e2Ds.description != null) {
            refFunction.datasetRelatesToProduct = true;
            refFunction.infrastructureProcess = false;
            String val = LangString.getFirstValue(e2Ds.description.getIncludedActivitiesStart());
            String end = LangString.getFirstValue(e2Ds.description.getIncludedActivitiesEnd());
            if (end != null) {
                val = val != null ? val + " | " + end : end;
            }
            refFunction.includedProcesses = val;
        }
    }

    private void referenceFunction(ES2IntermediateExchange e2Exchange, ES1Dataset e1Ds) {
        String name;
        ES1ReferenceFunction refFunction = e1Ds.referenceFunction;
        if (refFunction == null) {
            return;
        }
        if (e2Exchange.getProductClassifications().isEmpty()) {
            refFunction.category = "not available";
            refFunction.subCategory = "not available";
            refFunction.localCategory = "not available";
            refFunction.localSubCategory = "not available";
        } else {
            ES2ClassificationRef classRef = e2Exchange.getProductClassifications().get(0);
            String system = LangString.getFirstValue(classRef.getClassificationSystem());
            refFunction.category = system = system != null ? system : "not available";
            refFunction.localCategory = system;
            String value = LangString.getFirstValue(classRef.getClassificationValue());
            refFunction.subCategory = value = value != null ? value : "not available";
            refFunction.localSubCategory = value;
        }
        refFunction.name = name = TypeCheck.checkLength(LangString.getFirstValue(e2Exchange.getName()), 80);
        refFunction.localName = name;
        refFunction.amount = e2Exchange.amount;
        refFunction.unit = LangString.getFirstValue(e2Exchange.getUnitNames());
        refFunction.generalComment = LangString.getFirstValue(e2Exchange.getComment());
    }

    private void geography(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.geography != null) {
            ES1Geography geography;
            e1Ds.geography = geography = new ES1Geography();
            geography.location = LangString.getFirstValue(e2Ds.geography.getShortNames());
            if (e2Ds.geography.comment != null) {
                geography.text = e2Ds.geography.comment.getFirstText();
            }
        }
    }

    private void technology(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.technology != null) {
            ES1Technology technology;
            e1Ds.technology = technology = new ES1Technology();
            if (e2Ds.technology.comment != null) {
                e1Ds.technology.text = e2Ds.technology.comment.getFirstText();
            }
        }
    }

    private void timePeriod(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.timePeriod != null) {
            ES1TimePeriod time;
            e1Ds.timePeriod = time = new ES1TimePeriod();
            time.startDate = e2Ds.timePeriod.startDate;
            time.endDate = e2Ds.timePeriod.endDate;
            if (e2Ds.timePeriod.comment != null) {
                time.text = e2Ds.timePeriod.comment.getFirstText();
            }
            time.dataValidForEntirePeriod = e2Ds.timePeriod.dataValidForEntirePeriod;
            if (time.dataValidForEntirePeriod == null) {
                time.dataValidForEntirePeriod = true;
            }
        }
    }

    private void dataSetInfo(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        ES1DataSetInformation dInfo;
        e1Ds.dataSetInformation = dInfo = new ES1DataSetInformation();
        dInfo.energyValues = 0;
        dInfo.impactAssessmentResult = false;
        dInfo.languageCode = "en";
        dInfo.localLanguageCode = "de";
        dInfo.timestamp = Time.now();
        dInfo.version = 1.0;
        dInfo.internalVersion = 1.0;
        if (e2Ds.description != null) {
            dInfo.type = e2Ds.description.type;
        }
    }

    private void representativeness(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.representativeness != null) {
            ES1Representativeness repri;
            e1Ds.representativeness = repri = new ES1Representativeness();
            repri.samplingProcedure = LangString.getFirstValue(e2Ds.representativeness.getSamplingProcedure());
            repri.extrapolations = LangString.getFirstValue(e2Ds.representativeness.getExtrapolations());
            repri.percent = e2Ds.representativeness.percent;
        }
    }

    private void validation(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (!e2Ds.getReviews().isEmpty()) {
            ES1Validation validation;
            ES2Review review = e2Ds.getReviews().get(0);
            e1Ds.validation = validation = new ES1Validation();
            ES1Person person = new ES1Person();
            e1Ds.getPersons().add(person);
            int pNo = e1Ds.getPersons().size();
            person.number = pNo;
            person.name = review.reviewerName;
            person.email = review.reviewerEmail;
            validation.proofReadingValidator = pNo;
            if (review.details != null) {
                validation.proofReadingDetails = review.details.getFirstText();
            }
            validation.otherDetails = LangString.getFirstValue(review.getOtherDetails());
        }
    }

    private void dataEntry(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.dataEntryBy != null) {
            ES1DataEntryBy entry;
            e1Ds.dataEntryBy = entry = new ES1DataEntryBy();
            ES1Person person = this.getPerson(e2Ds.dataEntryBy.personEmail, e2Ds.dataEntryBy.personName, e1Ds);
            if (person != null) {
                entry.person = person.number;
            }
        }
    }

    private ES1Source getSource(String author, String year, ES1Dataset e1Ds) {
        String key = "" + author + "-" + year;
        ES1Source source = this.createdSources.get(key);
        if (source == null) {
            source = new ES1Source();
            e1Ds.getSources().add(source);
            this.createdSources.put(key, source);
            int sNo = this.createdSources.size();
            source.number = sNo;
            source.firstAuthor = author;
            if (source.firstAuthor == null) {
                source.firstAuthor = "!NO AUTHOR!";
                this.logger.severe("No author in source.");
            }
            if (year != null) {
                try {
                    source.year = Integer.parseInt(year);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (source.year == null) {
                source.year = 9999;
            }
            source.placeOfPublications = "-";
            source.title = "see master data";
        }
        return source;
    }

    private ES1Person getPerson(String email, String name, ES1Dataset e1Ds) {
        String key = "" + email + "-" + name;
        ES1Person person = this.createdPersons.get(key);
        if (person == null) {
            person = new ES1Person();
            e1Ds.getPersons().add(person);
            this.createdPersons.put(key, person);
            int pNo = this.createdPersons.size();
            person.number = pNo;
            person.email = email;
            person.name = name;
            person.address = "see master data";
            person.companyCode = "-";
            person.countryCode = "CH";
            person.telephone = "see master data";
        }
        return person;
    }

    private void publication(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        if (e2Ds.publication != null) {
            ES1Source source;
            ES1DataGeneratorAndPublication publication;
            e1Ds.dataGeneratorAndPublication = publication = new ES1DataGeneratorAndPublication();
            ES1Person person = this.getPerson(e2Ds.publication.personEmail, e2Ds.publication.personName, e1Ds);
            if (person != null) {
                publication.person = person.number;
            }
            if ((source = this.getSource(e2Ds.publication.publishedSourceFirstAuthor, e2Ds.publication.publishedSourceYear, e1Ds)) != null) {
                publication.referenceToPublishedSource = source.number;
            }
            publication.copyright = e2Ds.publication.isCopyrightProtected;
            if (publication.copyright == null) {
                publication.copyright = false;
            }
            publication.pageNumbers = e2Ds.publication.pageNumbers;
            publication.accessRestrictedTo = e2Ds.publication.accessRestrictedTo;
            publication.companyCode = e2Ds.publication.companyCode;
        }
    }

    private void exchanges(ES2Dataset e2Ds, ES1Dataset e1Ds) {
        ES1Exchange e1Exchange;
        for (ES2IntermediateExchange eS2IntermediateExchange : e2Ds.getIntermediateExchanges()) {
            e1Exchange = new ES1Exchange();
            e1Ds.getExchanges().add(e1Exchange);
            e1Exchange.number = e1Ds.getExchanges().size();
            e1Exchange.infrastructureProcess = false;
            e1Exchange.location = "GLO";
            e1Exchange.name = TypeCheck.checkLength(LangString.getFirstValue(eS2IntermediateExchange.getName()), 80);
            e1Exchange.unit = LangString.getFirstValue(eS2IntermediateExchange.getUnitNames());
            e1Exchange.generalComment = LangString.getFirstValue(eS2IntermediateExchange.getComment());
            e1Exchange.meanValue = eS2IntermediateExchange.amount;
            e1Exchange.CASNumber = eS2IntermediateExchange.casNumber;
            if (!eS2IntermediateExchange.getProductClassifications().isEmpty()) {
                ES2ClassificationRef classRef = eS2IntermediateExchange.getProductClassifications().get(0);
                e1Exchange.category = LangString.getFirstValue(classRef.getClassificationSystem());
                e1Exchange.subCategory = LangString.getFirstValue(classRef.getClassificationValue());
            }
            e1Exchange.uncertaintyType = 0;
            e1Exchange.inputGroup = eS2IntermediateExchange.inputGroup;
            e1Exchange.outputGroup = eS2IntermediateExchange.outputGroup;
            if (eS2IntermediateExchange.outputGroup != null && eS2IntermediateExchange.outputGroup == 0) {
                this.referenceFunction(eS2IntermediateExchange, e1Ds);
            }
            if (e1Ds.geography == null || e1Ds.geography.location == null) continue;
            e1Exchange.location = e1Ds.geography.location;
        }
        for (ES2ElementaryExchange eS2ElementaryExchange : e2Ds.getElementaryExchanges()) {
            e1Exchange = new ES1Exchange();
            e1Ds.getExchanges().add(e1Exchange);
            e1Exchange.number = e1Ds.getExchanges().size();
            e1Exchange.name = TypeCheck.checkLength(LangString.getFirstValue(eS2ElementaryExchange.getName()), 80);
            e1Exchange.unit = LangString.getFirstValue(eS2ElementaryExchange.getUnitNames());
            e1Exchange.generalComment = LangString.getFirstValue(eS2ElementaryExchange.getComment());
            e1Exchange.meanValue = eS2ElementaryExchange.amount;
            e1Exchange.CASNumber = eS2ElementaryExchange.casNumber;
            e1Exchange.category = LangString.getFirstValue(eS2ElementaryExchange.getCompartment());
            e1Exchange.subCategory = LangString.getFirstValue(eS2ElementaryExchange.getSubCompartment());
            e1Exchange.inputGroup = eS2ElementaryExchange.inputGroup;
            e1Exchange.outputGroup = eS2ElementaryExchange.outputGroup;
        }
    }
}

