/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.ILCDExchangeAccumulator;
import org.openlca.olcatdb.conversion.ILCDHelper;
import org.openlca.olcatdb.conversion.ReferenceFactory;
import org.openlca.olcatdb.database.CompartmentMap;
import org.openlca.olcatdb.database.ES2ElemFlowRec;
import org.openlca.olcatdb.database.ElemFlowMap;
import org.openlca.olcatdb.database.ILCDCompartmentRec;
import org.openlca.olcatdb.database.ILCDElemFlowRec;
import org.openlca.olcatdb.database.UnitMap;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2Description;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2GeographyRef;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2Review;
import org.openlca.olcatdb.ecospold2.ES2TimePeriod;
import org.openlca.olcatdb.ilcd.ILCDClass;
import org.openlca.olcatdb.ilcd.ILCDClassification;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDContactDescription;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDEntry;
import org.openlca.olcatdb.ilcd.ILCDExchange;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDGeography;
import org.openlca.olcatdb.ilcd.ILCDProcess;
import org.openlca.olcatdb.ilcd.ILCDProcessDescription;
import org.openlca.olcatdb.ilcd.ILCDProcessEntry;
import org.openlca.olcatdb.ilcd.ILCDProcessMethod;
import org.openlca.olcatdb.ilcd.ILCDProcessPublication;
import org.openlca.olcatdb.ilcd.ILCDProcessTechnology;
import org.openlca.olcatdb.ilcd.ILCDPublication;
import org.openlca.olcatdb.ilcd.ILCDQuantitativeReference;
import org.openlca.olcatdb.ilcd.ILCDRepresentativeness;
import org.openlca.olcatdb.ilcd.ILCDReview;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.ilcd.ILCDSourceDescription;
import org.openlca.olcatdb.ilcd.ILCDTime;
import org.openlca.olcatdb.ilcd.resources.ILCDFolder;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

public class ES2ToILCDConversion
extends AbstractConversionImpl {
    private ILCDExchangeAccumulator accumulator = new ILCDExchangeAccumulator();
    private Map<String, ILCDExchange> exchangesByFlow = new HashMap<String, ILCDExchange>();
    private ILCDFolder ilcdFolder;
    private XmlOutputter outputter;

    @Override
    public void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.ilcdFolder = new ILCDFolder(targetDir);
        this.ilcdFolder.createContent();
        this.logFile(this.ilcdFolder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.ilcdFolder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        this.outputter = new XmlOutputter();
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES2EcoSpold ecoSpold = parser.getContext(ES2EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference = this.convert(dataset);
                    if (reference == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private DataSetReference convert(ES2Dataset dataset) {
        ILCDProcess iProcess = new ILCDProcess();
        this.dataSetInformation(dataset, iProcess);
        this.time(dataset, iProcess);
        this.geography(dataset, iProcess);
        this.technology(dataset, iProcess);
        this.lciMethod(dataset, iProcess);
        this.representativeness(dataset, iProcess);
        this.reviews(dataset, iProcess);
        this.adminInfo(dataset, iProcess);
        this.exchanges(dataset, iProcess);
        String uuid = null;
        uuid = iProcess.description != null && iProcess.description.uuid != null ? iProcess.description.uuid : UUID.randomUUID().toString();
        String name = null;
        name = iProcess.description != null && !iProcess.description.getName().isEmpty() ? iProcess.description.getName().get(0).getValue() : "no name";
        DataSetReference reference = new DataSetReference();
        reference.setRefObjectId(uuid);
        reference.setName(name);
        reference.setType(ILCDDataSetType.Process.toString());
        reference.setVersion("01.00.000");
        File outFile = this.ilcdFolder.file(reference);
        if (outFile.exists()) {
            this.logger.severe("A process file for " + uuid + " already exists.");
            reference = null;
        } else {
            this.outputter.output((Object)iProcess, TemplateType.ILCDProcess, outFile, true);
            String url = outFile.toURI().toString();
            reference.setUri(url);
        }
        return reference;
    }

    private void dataSetInformation(ES2Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessDescription iDescription;
        iProcess.description = iDescription = new ILCDProcessDescription();
        if (eDataset.description != null) {
            ES2Description eDescription = eDataset.description;
            iDescription.uuid = eDescription.id;
            iDescription.getName().addAll(eDescription.getName());
            if (!eDescription.getSynonyms().isEmpty()) {
                String syns = "";
                Iterator<LangString> it = eDescription.getSynonyms().iterator();
                while (it.hasNext()) {
                    LangString langString = it.next();
                    syns = syns + langString.getValue();
                    if (!it.hasNext()) continue;
                    syns = syns + "; ";
                }
                iDescription.getSynonyms().add(new LangString(syns));
            }
            if (eDescription.generalComment != null && eDescription.generalComment.hasText()) {
                iDescription.getComment().add(eDescription.generalComment.getFirstLangString());
            }
        }
        for (ES2ClassificationRef eClassification : eDataset.getClassifications()) {
            ILCDClassification iClassification = new ILCDClassification();
            iDescription.getClassifications().add(iClassification);
            iClassification.fileURI = "../classifications.xml";
            iClassification.name = LangString.getFirstValue(eClassification.getClassificationSystem());
            int level = 0;
            for (LangString langString : eClassification.getClassificationValue()) {
                String[] entries;
                if (langString.getValue() == null) continue;
                for (String e : entries = langString.getValue().split("/")) {
                    if (e.length() <= 0) continue;
                    iClassification.getClasses().add(new ILCDClass(level, e));
                    ++level;
                }
            }
        }
    }

    private void time(ES2Dataset eDataset, ILCDProcess iProcess) {
        if (eDataset.timePeriod != null) {
            String val;
            ILCDTime iTime;
            ES2TimePeriod eTime = eDataset.timePeriod;
            iProcess.time = iTime = new ILCDTime();
            if (eTime.startDate != null && eTime.startDate.length() > 3) {
                try {
                    val = eTime.startDate.substring(0, 4);
                    iTime.referenceYear = Integer.parseInt(val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (eTime.endDate != null && eTime.endDate.length() > 3) {
                try {
                    val = eTime.endDate.substring(0, 4);
                    iTime.validUntil = Integer.parseInt(val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (eTime.comment != null && eTime.comment.hasText()) {
                iTime.getDescription().add(eTime.comment.getFirstLangString());
            }
        }
    }

    private void geography(ES2Dataset eDataset, ILCDProcess iProcess) {
        if (eDataset.geography != null) {
            ILCDGeography iGeography;
            ES2GeographyRef eGeography = eDataset.geography;
            iProcess.geography = iGeography = new ILCDGeography();
            iGeography.location = LangString.getFirstValue(eGeography.getShortNames());
            if (eGeography.comment != null && eGeography.comment.hasText()) {
                iGeography.getDescription().add(eGeography.comment.getFirstLangString());
            }
        }
    }

    private void technology(ES2Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessTechnology iTechnology;
        iProcess.technology = iTechnology = new ILCDProcessTechnology();
        if (eDataset.description != null) {
            ES2Description eDescription = eDataset.description;
            String includedActivities = null;
            if (!eDescription.getIncludedActivitiesStart().isEmpty()) {
                includedActivities = eDescription.getIncludedActivitiesStart().get(0).getValue();
            }
            if (!eDescription.getIncludedActivitiesEnd().isEmpty()) {
                includedActivities = includedActivities != null && includedActivities.length() > 0 ? includedActivities + " // " + eDescription.getIncludedActivitiesEnd().get(0).getValue() : eDescription.getIncludedActivitiesEnd().get(0).getValue();
            }
            if (includedActivities != null) {
                iTechnology.getDescription().add(new LangString(includedActivities));
            }
        }
        if (eDataset.technology != null && eDataset.technology.comment != null && eDataset.technology.comment.hasText()) {
            iTechnology.getApplicability().add(eDataset.technology.comment.getFirstLangString());
        }
    }

    private void lciMethod(ES2Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessMethod iMethod;
        iProcess.method = iMethod = new ILCDProcessMethod();
        if (eDataset.description != null) {
            iMethod.dataSetType = eDataset.description.type == 2 ? "LCI result" : "Unit process, black box";
        }
        iMethod.lciMethodPrinciple = "Other";
        iMethod.getLciMethodApproaches().add("Other");
        LangString stdText = new LangString();
        stdText.setValue("See the methodology report.");
        iMethod.getDeviationsFromLCIMethodApproaches().add(stdText);
        iMethod.getDeviationsFromLCIMethodPrinciple().add(stdText);
        iMethod.getDeviationsFromModellingConstants().add(stdText);
        iMethod.getModellingConstants().add(stdText);
        iMethod.getMethodDetails().add(ReferenceFactory.ECOINVENT_METHODIC.createReference());
    }

    private void representativeness(ES2Dataset eDataset, ILCDProcess iProcess) {
        ILCDRepresentativeness iRepri;
        iProcess.representativeness = iRepri = new ILCDRepresentativeness();
        if (eDataset.representativeness != null) {
            iRepri.getSamplingProcedure().addAll(eDataset.representativeness.getSamplingProcedure());
            iRepri.getExtrapolationPrinciples().addAll(eDataset.representativeness.getExtrapolations());
            iRepri.percent = eDataset.representativeness.percent;
        }
        LangString stdText = new LangString();
        stdText.setValue("See the methodology report.");
        if (iRepri.getCutOffPrinciples().isEmpty()) {
            iRepri.getCutOffPrinciples().add(stdText);
        }
        if (iRepri.getDeviationsFromCutOffPrinciples().isEmpty()) {
            iRepri.getDeviationsFromCutOffPrinciples().add(stdText);
        }
        if (iRepri.getDataSelectionPrinciples().isEmpty()) {
            iRepri.getDataSelectionPrinciples().add(stdText);
        }
        if (iRepri.getDeviationsFromDataSelectionPrinciples().isEmpty()) {
            iRepri.getDeviationsFromDataSelectionPrinciples().add(stdText);
        }
        if (iRepri.getExtrapolationPrinciples().isEmpty()) {
            iRepri.getExtrapolationPrinciples().add(stdText);
        }
        if (iRepri.getDeviationsFromExtrapolationPrinciples().isEmpty()) {
            iRepri.getDeviationsFromExtrapolationPrinciples().add(stdText);
        }
        String use = "This data set was automatically converted with the openLCA data converter. Before you use this data set you should check the entries and the compliance with the ILCD conformity. You can edit this data set with the ILCD Editor freely available at http://lct.jrc.ec.europa.eu/assessment/tools.";
        iRepri.getUseAdviceForDataSet().add(new LangString(use));
    }

    private void reviews(ES2Dataset eDataset, ILCDProcess iProcess) {
        for (ES2Review eReview : eDataset.getReviews()) {
            ILCDReview iReview = new ILCDReview();
            iProcess.getReviews().add(iReview);
            if (eReview.details != null && eReview.details.hasText()) {
                iReview.getDetails().add(eReview.details.getFirstLangString());
            }
            if (eReview.getOtherDetails().isEmpty()) continue;
            iReview.getOtherDetails().add(LangString.getFirst(eReview.getOtherDetails()));
        }
    }

    private void adminInfo(ES2Dataset eDataset, ILCDProcess iProcess) {
        ILCDProcessPublication publication;
        ILCDProcessEntry iEntry;
        if (eDataset.publication != null && eDataset.publication.personId != null && eDataset.publication.personName != null) {
            DataSetReference ref = this.contact(eDataset.publication.personId, eDataset.publication.personName, eDataset.publication.personEmail);
            iProcess.getDataGenerators().add(ref);
        }
        iProcess.entry = iEntry = new ILCDProcessEntry();
        iEntry.getDataFormatReferences().add(ReferenceFactory.ILCD_FORMAT.createReference());
        iEntry.getDataFormatReferences().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
        iEntry.timeStamp = eDataset.fileAttributes != null && eDataset.fileAttributes.creationTimestamp != null ? eDataset.fileAttributes.creationTimestamp : Time.now();
        if (eDataset.dataEntryBy != null && eDataset.dataEntryBy.personId != null && eDataset.dataEntryBy.personName != null) {
            DataSetReference ref;
            iEntry.dataSetEntryReference = ref = this.contact(eDataset.dataEntryBy.personId, eDataset.dataEntryBy.personName, eDataset.dataEntryBy.personEmail);
        }
        iProcess.publication = publication = new ILCDProcessPublication();
        if (eDataset.publication != null) {
            publication.copyright = eDataset.publication.isCopyrightProtected;
            publication.dataSetVersion = "01.00.000";
            String processId = iProcess.description.uuid;
            publication.permanentDataSetURI = "http://ecoinvent.org?processId=" + processId;
            if (eDataset.publication.dataPublishedIn != null) {
                switch (eDataset.publication.dataPublishedIn) {
                    case 0: {
                        publication.workflowStatus = "Working draft";
                        break;
                    }
                    case 1: {
                        publication.workflowStatus = "Data set finalised; subsystems published";
                        break;
                    }
                    case 2: {
                        publication.workflowStatus = "Data set finalised; entirely published";
                        break;
                    }
                }
            }
            if (eDataset.publication.publishedSourceId != null && eDataset.publication.publishedSourceFirstAuthor != null) {
                DataSetReference sourceRef;
                publication.republicationReference = sourceRef = this.source(eDataset.publication.publishedSourceId, eDataset.publication.publishedSourceFirstAuthor, eDataset.publication.publishedSourceYear);
            }
        }
    }

    private void exchanges(ES2Dataset eDataSet, ILCDProcess iProcess) {
        ILCDExchange existing;
        double factor;
        ILCDExchange iExchange;
        ILCDQuantitativeReference qRef = new ILCDQuantitativeReference();
        qRef.type = "Reference flow(s)";
        iProcess.quantitativeReference = qRef;
        for (ES2IntermediateExchange eS2IntermediateExchange : eDataSet.getIntermediateExchanges()) {
            iExchange = new ILCDExchange();
            iExchange.id = iProcess.getExchanges().size() + 1;
            iExchange.variableReference = eS2IntermediateExchange.variableName;
            if (!eS2IntermediateExchange.getComment().isEmpty()) {
                iExchange.getComment().add(LangString.getFirst(eS2IntermediateExchange.getComment()));
            }
            iExchange.direction = eS2IntermediateExchange.outputGroup != null ? "Output" : "Input";
            factor = this.flowDispatch(eS2IntermediateExchange, iExchange);
            this.numericValues(eS2IntermediateExchange, iExchange, factor);
            if (eS2IntermediateExchange.outputGroup != null && eS2IntermediateExchange.outputGroup.equals(0)) {
                qRef.getReferenceFlows().add(iExchange.id);
            }
            if ((existing = this.exchangesByFlow.get(iExchange.flowDataSet.getRefObjectId())) == null) {
                iProcess.getExchanges().add(iExchange);
                this.exchangesByFlow.put(iExchange.flowDataSet.getRefObjectId(), iExchange);
                continue;
            }
            this.accumulator.accumulate(existing, iExchange);
        }
        for (ES2ElementaryExchange eS2ElementaryExchange : eDataSet.getElementaryExchanges()) {
            iExchange = new ILCDExchange();
            iExchange.id = iProcess.getExchanges().size() + 1;
            iExchange.variableReference = eS2ElementaryExchange.variableName;
            if (!eS2ElementaryExchange.getComment().isEmpty()) {
                iExchange.getComment().add(LangString.getFirst(eS2ElementaryExchange.getComment()));
            }
            iExchange.direction = eS2ElementaryExchange.outputGroup != null ? "Output" : "Input";
            factor = this.flowDispatch(eS2ElementaryExchange, iExchange);
            this.numericValues(eS2ElementaryExchange, iExchange, factor);
            existing = this.exchangesByFlow.get(iExchange.flowDataSet.getRefObjectId());
            if (existing == null) {
                iProcess.getExchanges().add(iExchange);
                this.exchangesByFlow.put(iExchange.flowDataSet.getRefObjectId(), iExchange);
                continue;
            }
            this.accumulator.accumulate(existing, iExchange);
        }
    }

    private double flowDispatch(Object eExchange, ILCDExchange iExchange) {
        double factor = 0.0;
        if (eExchange instanceof ES2IntermediateExchange) {
            factor = this.productFlow((ES2IntermediateExchange)eExchange, iExchange);
        } else if (eExchange instanceof ES2ElementaryExchange) {
            ES2ElemFlowRec flowRec;
            ES2ElementaryExchange _eExchange = (ES2ElementaryExchange)eExchange;
            ElemFlowMap.Entry flowEntry = ElemFlowMap.es2ToILCD(_eExchange.elementaryExchangeId);
            factor = flowEntry != null ? this.assignedElemFlow(flowEntry, iExchange) : ((flowRec = ES2ElemFlowRec.forID(_eExchange.elementaryExchangeId)) != null ? this.unassignedElemFlow(flowRec, iExchange) : this.unknownElemFlow(_eExchange, iExchange));
        }
        return factor;
    }

    private double productFlow(ES2IntermediateExchange eExchange, ILCDExchange iExchange) {
        DataSetReference flowRef;
        String uuid = eExchange.intermediateExchangeId;
        String name = LangString.getFirstValue(eExchange.getName());
        iExchange.flowDataSet = flowRef = ILCDHelper.newFlowRef(uuid, name);
        UnitMap.Entry unitEntry = UnitMap.es2ToILCD(eExchange.unitId);
        if (unitEntry == null) {
            this.logger.severe("No unit assignment for: " + eExchange.unitId);
            return 0.0;
        }
        if (!this.ilcdFolder.exists(flowRef)) {
            ILCDFlow flow = ILCDHelper.makeFlow(uuid, name, eExchange.casNumber, null, "Product flow", unitEntry);
            ILCDHelper.writeFlow(this.ilcdFolder, flowRef, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private double assignedElemFlow(ElemFlowMap.Entry mapEntry, ILCDExchange iExchange) {
        DataSetReference ref;
        ILCDElemFlowRec flowRec = ILCDElemFlowRec.forID(mapEntry.getFlowId());
        if (flowRec == null) {
            this.logger.severe("Cannot load ILCD flow for ID: " + mapEntry.getFlowId());
            return 0.0;
        }
        iExchange.flowDataSet = ref = flowRec.toReference();
        if (!this.ilcdFolder.exists(ref)) {
            ILCDHelper.writeFlow(this.ilcdFolder, ref, flowRec.toFlow(), this.createdFiles);
        }
        return mapEntry.getFactor();
    }

    private double unassignedElemFlow(ES2ElemFlowRec flowRec, ILCDExchange iExchange) {
        DataSetReference flowRef;
        String uuid = flowRec.getId();
        String name = flowRec.getName();
        iExchange.flowDataSet = flowRef = ILCDHelper.newFlowRef(uuid, name);
        UnitMap.Entry unitEntry = UnitMap.es2ToILCD(flowRec.getUnitId());
        if (unitEntry == null) {
            this.logger.severe("No unit assignment for: " + flowRec.getUnitId());
            return 0.0;
        }
        if (!this.ilcdFolder.exists(flowRef)) {
            ILCDCompartmentRec rec;
            ILCDFlow flow = ILCDHelper.makeFlow(uuid, name, flowRec.getCas(), flowRec.getFormula(), "Elementary flow", unitEntry);
            String catId = CompartmentMap.es2ToILCD(flowRec.getCompartmentId());
            if (catId != null && (rec = ILCDCompartmentRec.forID(catId)) != null) {
                flow.description.getElemFlowCategorizations().add(rec.toCategorization());
            }
            ILCDHelper.writeFlow(this.ilcdFolder, flowRef, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private double unknownElemFlow(ES2ElementaryExchange eExchange, ILCDExchange iExchange) {
        DataSetReference flowRef;
        String uuid = eExchange.elementaryExchangeId;
        String name = LangString.getFirstValue(eExchange.getName());
        iExchange.flowDataSet = flowRef = ILCDHelper.newFlowRef(uuid, name);
        UnitMap.Entry unitEntry = UnitMap.es2ToILCD(eExchange.unitId);
        if (unitEntry == null) {
            this.logger.severe("No unit assignment for: " + eExchange.unitId);
            return 0.0;
        }
        if (!this.ilcdFolder.exists(flowRef)) {
            ILCDCompartmentRec rec;
            ILCDFlow flow = ILCDHelper.makeFlow(uuid, name, eExchange.casNumber, eExchange.formula, "Elementary flow", unitEntry);
            String catId = CompartmentMap.es2ToILCD(eExchange.compartmentId);
            if (catId != null && (rec = ILCDCompartmentRec.forID(catId)) != null) {
                flow.description.getElemFlowCategorizations().add(rec.toCategorization());
            }
            ILCDHelper.writeFlow(this.ilcdFolder, flowRef, flow, this.createdFiles);
        }
        return unitEntry.getFactor();
    }

    private void numericValues(Object eExchange, ILCDExchange iExchange, double factor) {
        if (factor == 0.0) {
            this.logger.warning("Conversion factor is 0: " + eExchange);
        }
        double amount = 0.0;
        if (eExchange instanceof ES2IntermediateExchange) {
            amount = ((ES2IntermediateExchange)eExchange).amount;
        } else if (eExchange instanceof ES2ElementaryExchange) {
            amount = ((ES2ElementaryExchange)eExchange).amount;
        }
        iExchange.resultingAmount = amount * factor;
        iExchange.meanAmount = amount * factor;
    }

    private DataSetReference contact(String id, String name, String email) {
        DataSetReference ref = new DataSetReference();
        ref.setName(name);
        ref.setRefObjectId(id);
        ref.setType(ILCDDataSetType.Contact.toString());
        ref.setUri("../contacts/" + id + ".xml");
        ref.setVersion("01.00.000");
        ref.getDescription().add(new LangString(name));
        if (!this.ilcdFolder.exists(ref)) {
            ILCDPublication publication;
            ILCDEntry entry;
            ILCDContact contact = new ILCDContact();
            contact.description = new ILCDContactDescription();
            contact.description.email = email;
            contact.description.uuid = id;
            contact.description.getName().add(new LangString(name));
            contact.description.getShortName().add(new LangString(name));
            ILCDClassification classification = new ILCDClassification();
            ILCDClass clazz = new ILCDClass();
            clazz.level = 0;
            clazz.name = "Persons";
            classification.getClasses().add(clazz);
            contact.description.getClassifications().add(classification);
            contact.entry = entry = new ILCDEntry();
            entry.timestamp = Time.now();
            entry.getDataSetFormats().add(ReferenceFactory.ILCD_FORMAT.createReference());
            entry.getDataSetFormats().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
            contact.publication = publication = new ILCDPublication();
            publication.dataSetVersion = "01.00.000";
            publication.permanentDataSetURI = "http://ecoinvent.org?personId=" + id;
            File outFile = this.ilcdFolder.file(ref);
            this.outputter.output((Object)contact, TemplateType.ILCDContact, outFile, false);
            DataSetReference refCopy = ref.copy();
            refCopy.setUri(outFile.toURI().toString());
            this.createdFiles.add(refCopy);
        }
        return ref;
    }

    private DataSetReference source(String id, String author, String year) {
        String cit = year == null ? author : author + " " + year;
        DataSetReference ref = new DataSetReference();
        ref.setName(cit);
        ref.setRefObjectId(id);
        ref.setType(ILCDDataSetType.Source.toString());
        ref.setUri("../sources/" + id + ".xml");
        ref.setVersion("01.00.000");
        ref.getDescription().add(new LangString(cit));
        if (!this.ilcdFolder.exists(ref)) {
            ILCDPublication publication;
            ILCDEntry entry;
            ILCDSourceDescription iDescription;
            ILCDSource source = new ILCDSource();
            source.description = iDescription = new ILCDSourceDescription();
            iDescription.uuid = id;
            iDescription.sourceCitation = cit;
            iDescription.getShortName().add(new LangString(cit));
            ILCDClassification classification = new ILCDClassification();
            iDescription.getClassifications().add(classification);
            ILCDClass clazz = new ILCDClass();
            classification.getClasses().add(clazz);
            clazz.level = 0;
            clazz.name = "Publications and communications";
            source.entry = entry = new ILCDEntry();
            entry.timestamp = Time.now();
            entry.getDataSetFormats().add(ReferenceFactory.ILCD_FORMAT.createReference());
            entry.getDataSetFormats().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
            source.publication = publication = new ILCDPublication();
            publication.dataSetVersion = "01.00.000";
            publication.permanentDataSetURI = "http://ecoinvent.org?sourceId=" + id;
            File outFile = this.ilcdFolder.file(ref);
            this.outputter.output((Object)source, TemplateType.ILCDSource, outFile, false);
            DataSetReference refCopy = ref.copy();
            refCopy.setUri(outFile.toURI().toString());
            this.createdFiles.add(refCopy);
        }
        return ref;
    }
}

