/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.templates.TemplateLoader;
import org.openlca.olcatdb.templates.TemplateType;

public class FileIndex {
    private String title;
    private String log;
    private List<DataSetReference> dataSets = new ArrayList<DataSetReference>();

    public List<DataSetReference> getDataSets() {
        return this.dataSets;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void add(DataSetReference ref) {
        this.getDataSets().add(ref);
    }

    public void toFile(File file) throws IOException {
        Collections.sort(this.dataSets, DataSetReference.comparator());
        Template template = TemplateLoader.getInstance().getTemplate(TemplateType.FileIndex);
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put(TemplateType.FileIndex.getContextName(), this);
        FileWriter writer = new FileWriter(file);
        template.merge(velocityContext, writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }
}

