/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import org.openlca.olcatdb.conversion.FileIndex;
import org.openlca.olcatdb.conversion.ReferenceFactory;
import org.openlca.olcatdb.database.ILCDPropertyRec;
import org.openlca.olcatdb.database.UnitMap;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.ilcd.ILCDCompliance;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDFlowDescription;
import org.openlca.olcatdb.ilcd.ILCDFlowEntry;
import org.openlca.olcatdb.ilcd.ILCDPublication;
import org.openlca.olcatdb.ilcd.resources.ILCDFolder;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

class ILCDHelper {
    ILCDHelper() {
    }

    public static DataSetReference newFlowRef(String uuid, String name) {
        DataSetReference flowRef = new DataSetReference();
        flowRef.setRefObjectId(uuid);
        flowRef.setType(ILCDDataSetType.Flow.toString());
        flowRef.setUri("../flows/" + uuid + ".xml");
        flowRef.setVersion("01.00.000");
        flowRef.getDescription().add(new LangString(name));
        flowRef.setName(name);
        return flowRef;
    }

    public static ILCDFlow makeFlow(String uuid, String name, String cas, String formula, String type, UnitMap.Entry unitEntry) {
        ILCDPublication pub;
        ILCDFlowEntry entry;
        ILCDFlowDescription descr;
        ILCDFlow flow = new ILCDFlow();
        flow.description = descr = new ILCDFlowDescription();
        descr.uuid = uuid;
        descr.getName().add(new LangString(name));
        descr.casNumber = cas;
        descr.sumFormula = formula;
        flow.type = type;
        ILCDCompliance compliance = new ILCDCompliance();
        flow.getComplianceDeclarations().add(compliance);
        compliance.complianceSystem = ReferenceFactory.ILCD_COMPLIANCE.createReference();
        compliance.overallCompliance = "Not defined";
        flow.entry = entry = new ILCDFlowEntry();
        entry.timestamp = Time.now();
        entry.getDataSetFormats().add(ReferenceFactory.ILCD_FORMAT.createReference());
        entry.getDataSetFormats().add(ReferenceFactory.ECOSPOLD_FORMAT.createReference());
        flow.publication = pub = new ILCDPublication();
        pub.dataSetVersion = "01.00.000";
        if (unitEntry != null) {
            flow.referenceFlowProperty = 0;
            ILCDPropertyRec propertyRec = ILCDPropertyRec.forID(unitEntry.getId());
            if (propertyRec != null) {
                flow.getFlowPropertyValues().add(propertyRec.toValue());
            }
        }
        return flow;
    }

    public static void writeFlow(ILCDFolder folder, DataSetReference flowRef, ILCDFlow flow, FileIndex createdFiles) {
        File f = folder.file(flowRef);
        new XmlOutputter().output((Object)flow, TemplateType.ILCDFlow, f, false);
        DataSetReference cRef = flowRef.copy();
        cRef.setUri(f.toURI().toString());
        createdFiles.add(cRef);
    }
}

