/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.ES1SimaProValidConversion;
import org.openlca.olcatdb.database.CompartmentMap;
import org.openlca.olcatdb.database.ES1CompartmentRec;
import org.openlca.olcatdb.database.ES1ElemFlowRec;
import org.openlca.olcatdb.database.ElemFlowMap;
import org.openlca.olcatdb.database.ILCDElemFlowRec;
import org.openlca.olcatdb.database.ILCDPropertyRec;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.datatypes.TypeCheck;
import org.openlca.olcatdb.ecospold1.ES1DataEntryBy;
import org.openlca.olcatdb.ecospold1.ES1DataGeneratorAndPublication;
import org.openlca.olcatdb.ecospold1.ES1DataSetInformation;
import org.openlca.olcatdb.ecospold1.ES1Dataset;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Geography;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1ReferenceFunction;
import org.openlca.olcatdb.ecospold1.ES1Representativeness;
import org.openlca.olcatdb.ecospold1.ES1Source;
import org.openlca.olcatdb.ecospold1.ES1Technology;
import org.openlca.olcatdb.ecospold1.ES1TimePeriod;
import org.openlca.olcatdb.ecospold1.ES1Validation;
import org.openlca.olcatdb.ecospold1.resources.ES1Folder;
import org.openlca.olcatdb.ilcd.ILCDClass;
import org.openlca.olcatdb.ilcd.ILCDClassification;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDExchange;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDProcess;
import org.openlca.olcatdb.ilcd.ILCDReview;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

public class ILCDToES1Conversion
extends AbstractConversionImpl {
    private boolean simaProConform = false;
    private ES1SimaProValidConversion simaProConverter;
    private ES1Folder es1Folder;
    private HashMap<String, Integer> personMap = new HashMap();
    private HashMap<String, Integer> sourceMap = new HashMap();

    public ILCDToES1Conversion() {
    }

    public ILCDToES1Conversion(boolean simaProConform) {
        this.simaProConform = simaProConform;
        if (simaProConform) {
            this.simaProConverter = new ES1SimaProValidConversion();
        }
    }

    @Override
    public void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.es1Folder = new ES1Folder(targetDir);
        this.es1Folder.createContent();
        this.logFile(this.es1Folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.es1Folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                DataSetReference reference;
                ILCDProcess process = parser.getContext(ILCDProcess.class, is);
                is.close();
                if (process == null || (reference = this.convert(process)) == null) continue;
                this.createdFiles.add(reference);
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.simaProConform) {
            try {
                this.simaProConverter.getMappingFile().writeToFile(this.targetDir.getAbsolutePath() + File.separator + "mapping.SPMapping");
            }
            catch (IOException e) {
                this.logger.severe("IO exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private DataSetReference convert(ILCDProcess process) {
        String uuid = process.description != null && process.description.uuid != null ? process.description.uuid : UUID.randomUUID().toString();
        String name = "no name";
        if (process.description != null) {
            String v = LangString.getFirstValue(process.description.getName(), "en");
            if (v != null) {
                name = v;
            }
            if ((v = LangString.getFirstValue(process.description.getTreatmentStandardsRoutes(), "en")) != null) {
                name = name + "; " + v;
            }
            if ((v = LangString.getFirstValue(process.description.getMixAndLocationTypes(), "en")) != null) {
                name = name + "; " + v;
            }
            if ((v = LangString.getFirstValue(process.description.getFunctionalUnitFlowProperties(), "en")) != null) {
                name = name + "; " + v;
            }
        }
        ES1EcoSpold ecoSpold = new ES1EcoSpold();
        ES1Dataset dataset = new ES1Dataset();
        ecoSpold.getDatasets().add(dataset);
        dataset.generator = "openLCA data converter 1.2";
        dataset.number = 1;
        dataset.timestamp = Time.now();
        this.referenceFunction(process, dataset);
        this.geography(process, dataset);
        this.technology(process, dataset);
        this.timePeriod(process, dataset);
        this.datasetInformation(process, dataset);
        this.representativeness(process, dataset);
        this.sources(process, dataset);
        this.validation(process, dataset);
        this.dataEntryBy(process, dataset);
        this.dataGeneratorAndPublication(process, dataset);
        this.exchanges(process, dataset);
        if (this.simaProConform) {
            this.simaProConverter.validate(dataset);
            this.simaProConverter.processForMappingFile(dataset);
        }
        DataSetReference ref = null;
        File outFile = new File(this.es1Folder.getProcessFolder(), uuid + ".xml");
        if (outFile.exists()) {
            this.logger.severe("The file " + outFile.getAbsolutePath() + " already exists.");
        } else {
            XmlOutputter outputter = new XmlOutputter();
            outputter.output((Object)ecoSpold, TemplateType.EcoSpold01, outFile, true);
            ref = new DataSetReference();
            ref.setName(name);
            ref.setUri(outFile.toURI().toString());
            ref.setRefObjectId(uuid);
            ref.setType(ILCDDataSetType.Process.toString());
            ref.setVersion("01.00.000");
        }
        this.personMap.clear();
        this.sourceMap.clear();
        return ref;
    }

    private void sources(ILCDProcess process, ES1Dataset dataset) {
        if (process.representativeness != null) {
            for (DataSetReference ref : process.representativeness.getDataSources()) {
                ES1Source eSource;
                String _uuid = ref.getRefObjectId();
                if (this.sourceMap.keySet().contains(_uuid) || (eSource = this.source(ref)) == null) continue;
                dataset.getSources().add(eSource);
                eSource.number = this.sourceMap.size() + 1;
                this.sourceMap.put(_uuid, eSource.number);
            }
        }
    }

    private void referenceFunction(ILCDProcess process, ES1Dataset dataset) {
        String com;
        ES1ReferenceFunction refFunction;
        dataset.referenceFunction = refFunction = new ES1ReferenceFunction();
        refFunction.datasetRelatesToProduct = true;
        refFunction.infrastructureProcess = false;
        refFunction.infrastructureIncluded = false;
        if (process.description != null && (com = LangString.getFirstValue(process.description.getComment(), "en")) != null) {
            refFunction.generalComment = com;
        }
        if (process.technology != null) {
            refFunction.includedProcesses = LangString.getFirstValue(process.technology.getDescription(), "en");
        }
    }

    private void referenceFunction(ES1Exchange refExchange, ES1Dataset dataset) {
        if (dataset.referenceFunction == null) {
            return;
        }
        ES1ReferenceFunction refFunction = dataset.referenceFunction;
        refFunction.name = refExchange.name;
        refFunction.localName = refExchange.localName;
        refFunction.category = refExchange.category;
        refFunction.subCategory = refExchange.subCategory;
        refFunction.localCategory = refExchange.localCategory;
        refFunction.localSubCategory = refExchange.localSubCategory;
        refFunction.amount = refExchange.meanValue;
        refFunction.unit = refExchange.unit;
        refFunction.CASNumber = refExchange.CASNumber;
        refFunction.formula = refExchange.formula;
        refFunction.datasetRelatesToProduct = true;
        refExchange.location = dataset.geography != null ? dataset.geography.location : "GLO";
        refExchange.inputGroup = null;
        refExchange.outputGroup = 0;
    }

    private void geography(ILCDProcess process, ES1Dataset dataset) {
        ES1Geography eGeography;
        dataset.geography = eGeography = new ES1Geography();
        if (process.geography != null) {
            eGeography.location = process.geography.location;
            eGeography.text = LangString.getFirstValue(process.geography.getDescription(), "en");
        }
    }

    private void technology(ILCDProcess process, ES1Dataset dataset) {
        ES1Technology eTechnology;
        dataset.technology = eTechnology = new ES1Technology();
        if (process.technology != null) {
            eTechnology.text = LangString.getFirstValue(process.technology.getApplicability(), "en");
        }
    }

    private void timePeriod(ILCDProcess process, ES1Dataset dataset) {
        ES1TimePeriod eTime;
        dataset.timePeriod = eTime = new ES1TimePeriod();
        eTime.dataValidForEntirePeriod = true;
        if (process.time != null) {
            eTime.startYear = process.time.referenceYear;
            eTime.endYear = process.time.validUntil;
            eTime.text = LangString.getFirstValue(process.time.getDescription(), "en");
        }
    }

    private void datasetInformation(ILCDProcess process, ES1Dataset dataset) {
        ES1DataSetInformation eDataInfo;
        dataset.dataSetInformation = eDataInfo = new ES1DataSetInformation();
        eDataInfo.energyValues = 0;
        eDataInfo.impactAssessmentResult = false;
        eDataInfo.internalVersion = 1.0;
        eDataInfo.languageCode = "en";
        eDataInfo.localLanguageCode = "de";
        eDataInfo.timestamp = Time.now();
        eDataInfo.version = 1.0;
        if (process.method != null && process.method.dataSetType != null) {
            String type = process.method.dataSetType;
            eDataInfo.type = type.equals("Unit process, single operation") ? Integer.valueOf(1) : (type.equals("Unit process, black box") ? Integer.valueOf(1) : (type.equals("LCI result") ? Integer.valueOf(2) : (type.equals("Partly terminated system") ? Integer.valueOf(0) : Integer.valueOf(1))));
        }
    }

    private void representativeness(ILCDProcess process, ES1Dataset dataset) {
        ES1Representativeness eRepri;
        dataset.representativeness = eRepri = new ES1Representativeness();
        if (process.representativeness != null) {
            eRepri.extrapolations = LangString.getFirstValue(process.representativeness.getExtrapolationPrinciples(), "en");
            eRepri.percent = process.representativeness.percent;
            eRepri.productionVolume = TypeCheck.checkLength(LangString.getFirstValue(process.representativeness.getProductionVolume(), "en"), 80);
            String s1 = LangString.getFirstValue(process.representativeness.getSamplingProcedure(), "en");
            String s2 = LangString.getFirstValue(process.representativeness.getDataSelectionPrinciples(), "en");
            if (s1 == null) {
                eRepri.samplingProcedure = s2;
            } else if (s2 == null) {
                eRepri.samplingProcedure = s1;
            } else if (s1 != null && s2 != null) {
                eRepri.samplingProcedure = s1 + " // " + s2;
            }
            eRepri.uncertaintyAdjustments = LangString.getFirstValue(process.representativeness.getUncertaintyAdjustments(), "en");
        }
    }

    private void validation(ILCDProcess process, ES1Dataset dataset) {
        if (process.getReviews().size() > 0) {
            ES1Validation eValidation;
            dataset.validation = eValidation = new ES1Validation();
            ILCDReview iReview = process.getReviews().get(0);
            eValidation.otherDetails = LangString.getFirstValue(iReview.getOtherDetails(), "en");
            eValidation.proofReadingDetails = LangString.getFirstValue(iReview.getDetails(), "en");
            if (eValidation.proofReadingDetails == null) {
                eValidation.proofReadingDetails = "no details";
            }
            for (DataSetReference ref : iReview.getReviewers()) {
                ES1Person person;
                String _uuid = ref.getRefObjectId();
                if (!this.personMap.keySet().contains(_uuid) && (person = this.person(ref)) != null) {
                    person.number = this.personMap.size() + 1;
                    dataset.getPersons().add(person);
                    this.personMap.put(_uuid, person.number);
                }
                if (eValidation.proofReadingValidator != null) continue;
                eValidation.proofReadingValidator = this.personMap.get(_uuid);
            }
        }
    }

    private void dataEntryBy(ILCDProcess process, ES1Dataset dataset) {
        DataSetReference ref;
        if (process.entry != null && (ref = process.entry.dataSetEntryReference) != null) {
            ES1DataEntryBy entryBy;
            ES1Person person;
            String _uuid = ref.getRefObjectId();
            if (!this.personMap.keySet().contains(_uuid) && (person = this.person(ref)) != null) {
                person.number = this.personMap.size() + 1;
                dataset.getPersons().add(person);
                this.personMap.put(_uuid, person.number);
            }
            dataset.dataEntryBy = entryBy = new ES1DataEntryBy();
            entryBy.person = this.personMap.get(_uuid);
        }
    }

    private void dataGeneratorAndPublication(ILCDProcess process, ES1Dataset dataset) {
        String _uuid;
        ES1DataGeneratorAndPublication ePublication;
        dataset.dataGeneratorAndPublication = ePublication = new ES1DataGeneratorAndPublication();
        if (process.publication != null) {
            String license = process.publication.licenseType;
            if (license != null && license.equals("Free of charge for all users and uses")) {
                ePublication.accessRestrictedTo = 0;
            }
            ePublication.copyright = process.publication.copyright;
            DataSetReference ref = process.publication.republicationReference;
            if (ref != null) {
                ES1Source eSource;
                _uuid = ref.getRefObjectId();
                if (!this.sourceMap.keySet().contains(_uuid) && (eSource = this.source(ref)) != null) {
                    dataset.getSources().add(eSource);
                    eSource.number = this.sourceMap.size() + 1;
                    this.sourceMap.put(_uuid, eSource.number);
                }
                ePublication.referenceToPublishedSource = this.sourceMap.get(_uuid);
            }
            ePublication.dataPublishedIn = ePublication.referenceToPublishedSource != null ? Integer.valueOf(2) : Integer.valueOf(0);
        }
        for (DataSetReference ref : process.getDataGenerators()) {
            ES1Person person;
            _uuid = ref.getRefObjectId();
            if (!this.personMap.keySet().contains(_uuid) && (person = this.person(ref)) != null) {
                person.number = this.personMap.size() + 1;
                dataset.getPersons().add(person);
                this.personMap.put(_uuid, person.number);
            }
            if (ePublication.person != null) continue;
            ePublication.person = this.personMap.get(_uuid);
        }
    }

    private ES1Source source(DataSetReference ref) {
        ES1Source eSource = null;
        Object o = this.fetch(ref);
        if (!(o instanceof ILCDSource)) {
            this.logger.severe("Cannot load source from reference: " + ref.getUri());
        } else {
            ILCDSource iSource = (ILCDSource)o;
            eSource = new ES1Source();
            eSource.placeOfPublications = "see title";
            eSource.year = 9999;
            if (iSource.description != null) {
                eSource.title = iSource.description.sourceCitation;
                eSource.firstAuthor = iSource.description.sourceCitation;
                if (iSource.description.publicationType != null) {
                    String pubType = iSource.description.publicationType;
                    eSource.sourceType = pubType.equals("Undefined") ? Integer.valueOf(0) : (pubType.equals("Article in periodical") ? Integer.valueOf(1) : (pubType.equals("Chapter in anthology") ? Integer.valueOf(2) : (pubType.equals("Monograph") ? Integer.valueOf(3) : (pubType.equals("Direct measurement") ? Integer.valueOf(4) : (pubType.equals("Oral communication") ? Integer.valueOf(5) : (pubType.equals("Personal written communication") ? Integer.valueOf(6) : (pubType.equals("Questionnaire") ? Integer.valueOf(7) : Integer.valueOf(0))))))));
                }
                eSource.text = LangString.getFirstValue(iSource.description.getComment(), "en");
            }
            eSource.makeValid();
        }
        return eSource;
    }

    private ES1Person person(DataSetReference ref) {
        ES1Person person = null;
        Object o = this.fetch(ref);
        if (!(o instanceof ILCDContact)) {
            this.logger.severe("Cannot load contact from reference: " + ref.getUri());
        } else {
            ILCDContact contact = (ILCDContact)o;
            person = new ES1Person();
            person.companyCode = "-";
            person.countryCode = "CH";
            if (contact.description != null) {
                person.address = TypeCheck.checkLength(LangString.getFirstValue(contact.description.getContactAddress(), "en"), 255);
                if (person.address == null) {
                    person.address = "no address";
                }
                person.email = TypeCheck.checkLength(contact.description.email, 80);
                person.name = TypeCheck.checkLength(LangString.getFirstValue(contact.description.getName(), "en"), 40);
                person.telefax = TypeCheck.checkLength(contact.description.telefax, 40);
                person.telephone = TypeCheck.checkLength(contact.description.telephone, 40);
            }
        }
        return person;
    }

    @Override
    protected boolean matchEntry(String entryName) {
        boolean match = super.matchEntry(entryName);
        if (match) {
            match = entryName.contains("processes");
        }
        return match;
    }

    private void exchanges(ILCDProcess iProcess, ES1Dataset eDataset) {
        int refFlow = -1;
        if (iProcess.quantitativeReference != null && !iProcess.quantitativeReference.getReferenceFlows().isEmpty()) {
            refFlow = iProcess.quantitativeReference.getReferenceFlows().get(0);
        }
        int nr = 200000;
        for (ILCDExchange iExchange : iProcess.getExchanges()) {
            ES1Exchange eExchange = new ES1Exchange();
            eDataset.getExchanges().add(eExchange);
            eExchange.number = nr++;
            eExchange.location = iExchange.location;
            eExchange.generalComment = LangString.getFirstValue(iExchange.getComment(), "en");
            double factor = this.flowDispatch(iExchange, eExchange);
            if (factor == 0.0) {
                this.logger.severe("No conversion factor: " + iExchange.toString());
            } else {
                this.numericValues(iExchange, eExchange, factor);
            }
            if (iExchange.id == null || iExchange.id != refFlow) continue;
            this.referenceFunction(eExchange, eDataset);
        }
    }

    private double flowDispatch(ILCDExchange iExchange, ES1Exchange eExchange) {
        double factor = 0.0;
        String flowId = null;
        DataSetReference flowRef = iExchange.flowDataSet;
        if (flowRef != null) {
            flowId = flowRef.getRefObjectId();
        }
        if (flowId == null) {
            this.logger.severe("No valid flow reference in ILCD exchange: " + flowRef);
            return 0.0;
        }
        boolean isProduct = false;
        ElemFlowMap.Entry mapEntry = ElemFlowMap.ilcdToES1(flowId);
        if (mapEntry != null) {
            factor = this.assignedElemFlow(mapEntry, eExchange);
        } else {
            ILCDElemFlowRec flowRec = ILCDElemFlowRec.forID(flowId);
            if (flowRec != null) {
                factor = this.unassignedElemFlow(flowRec, eExchange);
            } else {
                Object obj = this.fetch(flowRef);
                if (!(obj instanceof ILCDFlow)) {
                    this.logger.severe("Cannot load ILCD flow data set for reference: " + flowRef);
                } else {
                    ILCDFlow flow = (ILCDFlow)obj;
                    if (flow.isElementary()) {
                        factor = this.unknownElemFlow(flow, eExchange);
                    } else {
                        factor = this.productFlow(flow, eExchange);
                        isProduct = true;
                    }
                }
            }
        }
        if (isProduct) {
            if (iExchange.isInput()) {
                eExchange.inputGroup = 5;
            } else {
                eExchange.outputGroup = 3;
            }
        } else if (iExchange.isInput()) {
            eExchange.inputGroup = 4;
        } else {
            eExchange.outputGroup = 4;
        }
        return factor;
    }

    private double assignedElemFlow(ElemFlowMap.Entry mapEntry, ES1Exchange eExchange) {
        ES1ElemFlowRec rec = ES1ElemFlowRec.forID(mapEntry.getFlowId());
        if (rec == null) {
            this.logger.severe("Cannot load EcoSpold 01 flow for ID: " + mapEntry.getFlowId());
            return 0.0;
        }
        eExchange.number = rec.getId();
        eExchange.CASNumber = this.formatCAS(rec.getCas());
        eExchange.formula = rec.getFormula();
        eExchange.name = rec.getName();
        eExchange.localName = rec.getName();
        eExchange.unit = rec.getUnit();
        ES1CompartmentRec compartment = ES1CompartmentRec.forID(rec.getCompartmentId());
        if (compartment != null) {
            eExchange.category = compartment.getCompartment();
            eExchange.localCategory = compartment.getCompartment();
            eExchange.subCategory = compartment.getSubCompartment();
            eExchange.localSubCategory = compartment.getSubCompartment();
        }
        return mapEntry.getFactor();
    }

    private double unassignedElemFlow(ILCDElemFlowRec flowRec, ES1Exchange eExchange) {
        eExchange.name = TypeCheck.checkLength(flowRec.getName(), 80);
        eExchange.localName = TypeCheck.checkLength(flowRec.getName(), 80);
        eExchange.CASNumber = this.formatCAS(flowRec.getCas());
        eExchange.formula = flowRec.getFormula();
        int compId = CompartmentMap.ilcdToES1(flowRec.getCompartmentId());
        if (compId == -1) {
            this.logger.severe("No corresponding compartment for ILCD elementary flow category " + flowRec.getCompartmentId());
        } else {
            ES1CompartmentRec compRec = ES1CompartmentRec.forID(compId);
            if (compRec != null) {
                eExchange.category = compRec.getCompartment();
                eExchange.localCategory = compRec.getCompartment();
                eExchange.subCategory = compRec.getSubCompartment();
                eExchange.localSubCategory = compRec.getSubCompartment();
            }
        }
        String unit = ILCDPropertyRec.unit(flowRec.getPropertyId());
        if (unit == null) {
            this.logger.severe("Cannot load unit for ILCD flow property: " + flowRec.getPropertyId());
            return 0.0;
        }
        eExchange.unit = unit;
        return 1.0;
    }

    private double unknownElemFlow(ILCDFlow flow, ES1Exchange eExchange) {
        if (flow.description != null) {
            eExchange.localName = eExchange.name = TypeCheck.checkLength(LangString.getFirstValue(flow.description.getName(), "en"), 80);
            eExchange.CASNumber = this.formatCAS(flow.description.casNumber);
            eExchange.formula = flow.description.sumFormula;
        }
        String unit = null;
        DataSetReference ref = flow.getReferenceProperty();
        if (ref != null) {
            unit = ILCDPropertyRec.unit(ref.getRefObjectId());
        }
        if (unit == null) {
            this.logger.severe("Cannot load flow property for " + ref);
            return 0.0;
        }
        eExchange.unit = unit;
        return 1.0;
    }

    private double productFlow(ILCDFlow flow, ES1Exchange eExchange) {
        if (flow.description != null) {
            eExchange.localName = eExchange.name = TypeCheck.checkLength(LangString.getFirstValue(flow.description.getName(), "en"), 80);
            eExchange.CASNumber = this.formatCAS(flow.description.casNumber);
            eExchange.formula = flow.description.sumFormula;
            eExchange.infrastructureProcess = false;
            eExchange.location = "GLO";
            if (!flow.description.getClassifications().isEmpty()) {
                ILCDClassification clasf = flow.description.getClassifications().get(0);
                for (ILCDClass clazz : clasf.getClasses()) {
                    if (clazz.level == 0) {
                        eExchange.localCategory = eExchange.category = clazz.name;
                    }
                    if (clazz.level != 1) continue;
                    eExchange.localSubCategory = eExchange.subCategory = clazz.name;
                }
            }
        }
        String unit = null;
        DataSetReference ref = flow.getReferenceProperty();
        if (ref != null) {
            unit = ILCDPropertyRec.unit(ref.getRefObjectId());
        }
        if (unit == null) {
            this.logger.severe("Cannot load flow property for " + ref);
            return 0.0;
        }
        eExchange.unit = unit;
        return 1.0;
    }

    private void numericValues(ILCDExchange iExchange, ES1Exchange eExchange, double factor) {
        if (iExchange.uncertaintyDistribution == null || iExchange.uncertaintyDistribution.equals("undefined")) {
            eExchange.uncertaintyType = 0;
            if (iExchange.resultingAmount != null) {
                eExchange.meanValue = factor * iExchange.resultingAmount;
            }
        } else if (iExchange.uncertaintyDistribution.equals("log-normal")) {
            eExchange.uncertaintyType = 1;
            if (iExchange.meanAmount != null) {
                eExchange.meanValue = factor * iExchange.meanAmount;
            }
            if (iExchange.relStdDeviation95In != null) {
                eExchange.standardDeviation95 = iExchange.relStdDeviation95In;
            }
        } else if (iExchange.uncertaintyDistribution.equals("normal")) {
            eExchange.uncertaintyType = 2;
            if (iExchange.meanAmount != null) {
                eExchange.meanValue = factor * iExchange.meanAmount;
            }
            if (iExchange.relStdDeviation95In != null) {
                eExchange.standardDeviation95 = factor * iExchange.relStdDeviation95In;
            }
        } else if (iExchange.uncertaintyDistribution.equals("triangular")) {
            eExchange.uncertaintyType = 3;
            if (iExchange.meanAmount != null) {
                eExchange.meanValue = factor * iExchange.meanAmount;
            }
            if (iExchange.minimumAmount != null) {
                eExchange.minValue = factor * iExchange.minimumAmount;
            }
            if (iExchange.maximumAmount != null) {
                eExchange.maxValue = factor * iExchange.maximumAmount;
            }
        } else if (iExchange.uncertaintyDistribution.equals("uniform")) {
            eExchange.uncertaintyType = 4;
            if (iExchange.meanAmount != null) {
                eExchange.meanValue = factor * iExchange.meanAmount;
            }
            if (iExchange.minimumAmount != null) {
                eExchange.minValue = factor * iExchange.minimumAmount;
            }
            if (iExchange.maximumAmount != null) {
                eExchange.maxValue = factor * iExchange.maximumAmount;
            }
        }
    }

    private String formatCAS(String ilcdCAS) {
        String cas = ilcdCAS;
        if (cas != null) {
            while (cas.length() < 11) {
                cas = "0" + cas;
            }
        }
        return cas;
    }
}

