/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.database.CompartmentMap;
import org.openlca.olcatdb.database.ES2CompartmentRec;
import org.openlca.olcatdb.database.ES2ElemFlowRec;
import org.openlca.olcatdb.database.ES2GeographyRec;
import org.openlca.olcatdb.database.ES2UnitRec;
import org.openlca.olcatdb.database.ElemFlowMap;
import org.openlca.olcatdb.database.ILCDElemFlowRec;
import org.openlca.olcatdb.database.UnitMap;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.TextAndImage;
import org.openlca.olcatdb.datatypes.Time;
import org.openlca.olcatdb.datatypes.TypeCheck;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2Description;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2Entry;
import org.openlca.olcatdb.ecospold2.ES2FileAttributes;
import org.openlca.olcatdb.ecospold2.ES2GeographyRef;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2MacroEconomicScenario;
import org.openlca.olcatdb.ecospold2.ES2Parameter;
import org.openlca.olcatdb.ecospold2.ES2Publication;
import org.openlca.olcatdb.ecospold2.ES2Representativeness;
import org.openlca.olcatdb.ecospold2.ES2Technology;
import org.openlca.olcatdb.ecospold2.ES2TimePeriod;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityEntry;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityName;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityNameList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Classification;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ClassificationSystem;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ClassificationSystemList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ElemFlow;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ElemFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Person;
import org.openlca.olcatdb.ecospold2.masterdata.ES2PersonList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ProductFlow;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ProductFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Source;
import org.openlca.olcatdb.ecospold2.masterdata.ES2SourceList;
import org.openlca.olcatdb.ecospold2.resources.ES2Folder;
import org.openlca.olcatdb.ilcd.ILCDClass;
import org.openlca.olcatdb.ilcd.ILCDClassification;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDContactDescription;
import org.openlca.olcatdb.ilcd.ILCDExchange;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDGeography;
import org.openlca.olcatdb.ilcd.ILCDMathSection;
import org.openlca.olcatdb.ilcd.ILCDParameter;
import org.openlca.olcatdb.ilcd.ILCDProcess;
import org.openlca.olcatdb.ilcd.ILCDProcessDescription;
import org.openlca.olcatdb.ilcd.ILCDProcessEntry;
import org.openlca.olcatdb.ilcd.ILCDProcessMethod;
import org.openlca.olcatdb.ilcd.ILCDProcessPublication;
import org.openlca.olcatdb.ilcd.ILCDProcessTechnology;
import org.openlca.olcatdb.ilcd.ILCDRepresentativeness;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.ilcd.ILCDSourceDescription;
import org.openlca.olcatdb.ilcd.ILCDTime;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlOutputter;

class ILCDToES2Conversion
extends AbstractConversionImpl {
    private ES2Folder ecoSpoldFolder;
    private ES2ActivityNameList activityNameList = null;
    private ES2ActivityList activityList = null;
    private ES2ClassificationSystemList classificationSystems = null;
    private ES2SourceList sourceList = null;
    private ES2PersonList personList = null;
    private ES2ElemFlowList elemFlows = null;
    private ES2ProductFlowList productFlows = null;
    private static final String CONTEXT_ID = "DE659012-50C4-4e96-B54A-FC781BF987AB";
    private static final LangString CONTEXT_NAME = new LangString("ecoinvent");

    ILCDToES2Conversion() {
    }

    @Override
    public void createFolder(File targetDir) {
        super.createFolder(targetDir);
        this.ecoSpoldFolder = new ES2Folder(targetDir);
        this.ecoSpoldFolder.createContent();
        this.logFile(this.ecoSpoldFolder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.ecoSpoldFolder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        this.initMasterData();
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            try {
                DataSetReference ref;
                InputStream is = this.next();
                if (is == null) continue;
                ILCDProcess process = parser.getContext(ILCDProcess.class, is);
                is.close();
                if (process == null || (ref = this.convert(process)) == null) continue;
                this.createdFiles.add(ref);
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.flushMasterData();
        this.flush();
    }

    private void initMasterData() {
        this.activityList = new ES2ActivityList();
        this.activityList.contextId = CONTEXT_ID;
        this.activityList.getContextNames().add(CONTEXT_NAME);
        this.activityNameList = new ES2ActivityNameList();
        this.activityNameList.contextId = CONTEXT_ID;
        this.activityNameList.getContextNames().add(CONTEXT_NAME);
        this.classificationSystems = new ES2ClassificationSystemList();
        this.classificationSystems.contextId = CONTEXT_ID;
        this.classificationSystems.getContextNames().add(CONTEXT_NAME);
        ES2ClassificationSystem ilcdSystem = new ES2ClassificationSystem();
        this.classificationSystems.getSystems().add(ilcdSystem);
        ilcdSystem.id = "10d9abd2-7366-4996-a0d7-549baef3c773";
        ilcdSystem.type = 1;
        ilcdSystem.getName().add(new LangString("ILCD Classification"));
        this.elemFlows = new ES2ElemFlowList();
        this.elemFlows.contextId = CONTEXT_ID;
        this.elemFlows.getContextName().add(CONTEXT_NAME);
        this.productFlows = new ES2ProductFlowList();
        this.productFlows.contextId = CONTEXT_ID;
        this.productFlows.getContextName().add(CONTEXT_NAME);
        this.sourceList = new ES2SourceList();
        this.sourceList.contextId = CONTEXT_ID;
        this.sourceList.getContextNames().add(CONTEXT_NAME);
        this.personList = new ES2PersonList();
        this.personList.contextId = CONTEXT_ID;
        this.personList.getContextNames().add(CONTEXT_NAME);
    }

    private void flushMasterData() {
        this.flushMasterData("ActivityIndex.xml", this.activityList, TemplateType.ES2ActivityList);
        this.activityList = null;
        this.flushMasterData("ActivityNames.xml", this.activityNameList, TemplateType.ES2ActivityNameList);
        this.activityNameList = null;
        this.flushMasterData("Classifications.xml", this.classificationSystems, TemplateType.ES2Classifications);
        this.classificationSystems = null;
        this.flushMasterData("ElementaryExchanges.xml", this.elemFlows, TemplateType.ES2ElemFlowList);
        this.elemFlows = null;
        this.flushMasterData("IntermediateExchanges.xml", this.productFlows, TemplateType.ES2ProductFlowList);
        this.productFlows = null;
        this.flushMasterData("Sources.xml", this.sourceList, TemplateType.ES2SourceList);
        this.sourceList = null;
        this.flushMasterData("Persons.xml", this.personList, TemplateType.ES2PersonList);
        this.personList = null;
    }

    private void flushMasterData(String file, Object content, TemplateType template) {
        File mdDir = this.ecoSpoldFolder.getMasterDataFolder();
        File outFile = new File(mdDir, file);
        if (outFile.exists()) {
            this.logger.severe("Cannot create master data file '" + file + "' because it already exists.");
        } else {
            XmlOutputter outputter = new XmlOutputter();
            outputter.output(content, template, outFile, true);
        }
    }

    private DataSetReference convert(ILCDProcess process) {
        ILCDMathSection iMathSection;
        ILCDProcessTechnology iTechnology;
        ILCDGeography iGeography;
        ILCDTime iTime;
        ILCDProcessMethod iMethod;
        ES2EcoSpold ecoSpold = new ES2EcoSpold();
        ES2Dataset eDataset = ecoSpold.makeDataset();
        ILCDProcessDescription iDescription = process.description;
        if (iDescription != null) {
            this.map(iDescription, eDataset);
        }
        if ((iMethod = process.method) != null && eDataset.description != null) {
            int type = 1;
            if (iMethod.dataSetType != null && iMethod.dataSetType.equals("LCI result")) {
                type = 2;
            }
            eDataset.description.type = type;
            if (!iMethod.getDeviationsFromLCIMethodApproaches().isEmpty()) {
                int idx = 1;
                TextAndImage commment = eDataset.description.allocationComment = new TextAndImage();
                for (LangString lString : iMethod.getDeviationsFromLCIMethodApproaches()) {
                    commment.getText().add(lString.setIndex(idx));
                }
            }
        }
        if ((iTime = process.time) != null) {
            this.map(iTime, eDataset);
        }
        if ((iGeography = process.geography) != null) {
            this.geography(iGeography, eDataset);
        }
        if ((iTechnology = process.technology) != null) {
            this.map(iTechnology, eDataset);
        }
        if ((iMathSection = process.mathSection) != null) {
            this.map(iMathSection, eDataset);
        }
        this.exchanges(process, eDataset);
        if (process.representativeness != null) {
            this.map(process.representativeness, eDataset);
        }
        ES2MacroEconomicScenario eScenario = new ES2MacroEconomicScenario();
        eScenario.scenarioId = "d9f57f0a-a01f-42eb-a57b-8f18d6635801";
        eScenario.getName().add(new LangString("Business-as-Usual"));
        eDataset.macroEconomicScenario = eScenario;
        this.dataEntryBy(process, eDataset);
        this.generatorAndPublication(process, eDataset);
        this.fileAttributes(eDataset);
        this.activityEntry(eDataset);
        File outFile = new File(this.ecoSpoldFolder.getActivityFolder(), UUID.randomUUID().toString() + ".spold");
        XmlOutputter outputter = new XmlOutputter();
        outputter.output((Object)ecoSpold, TemplateType.EcoSpold02, outFile, true);
        DataSetReference reference = new DataSetReference();
        reference.setRefObjectId(process.description.uuid);
        reference.setType("process data set");
        try {
            String uri = outFile.toURI().toString();
            reference.setUri(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (eDataset.description != null && !eDataset.description.getName().isEmpty()) {
            reference.setName(eDataset.description.getName().get(0).getValue());
        }
        return reference;
    }

    private void activityEntry(ES2Dataset eDataset) {
        ES2ActivityEntry indexEntry = new ES2ActivityEntry();
        this.activityList.getEntries().add(indexEntry);
        indexEntry.specialActivityType = 0;
        ES2ActivityName nameEntry = new ES2ActivityName();
        this.activityNameList.getActivityNames().add(nameEntry);
        if (eDataset.description != null) {
            indexEntry.activityNameId = eDataset.description.activityNameId;
            indexEntry.id = eDataset.description.id;
            indexEntry.getName().addAll(eDataset.description.getName());
            nameEntry.id = eDataset.description.activityNameId;
            nameEntry.getNames().addAll(eDataset.description.getName());
        }
        if (eDataset.geography != null) {
            indexEntry.geographyId = eDataset.geography.geographyId;
            indexEntry.getLocation().addAll(eDataset.geography.getShortNames());
        }
        if (eDataset.timePeriod != null) {
            indexEntry.startDate = eDataset.timePeriod.startDate;
            indexEntry.endDate = eDataset.timePeriod.endDate;
        }
    }

    private void map(ILCDRepresentativeness iRepresentativeness, ES2Dataset eDataset) {
        ES2Representativeness eRepresentativeness = eDataset.representativeness;
        if (eRepresentativeness == null) {
            eDataset.representativeness = eRepresentativeness = new ES2Representativeness();
        }
        eRepresentativeness.systemModelId = "8b738ea0-f89e-4627-8679-433616064e82";
        eRepresentativeness.getSystemModelName().add(new LangString("undefined"));
        eRepresentativeness.percent = iRepresentativeness.percent;
        for (LangString langString : iRepresentativeness.getExtrapolationPrinciples()) {
            eRepresentativeness.getExtrapolations().add(langString);
        }
        LangString.concat(iRepresentativeness.getDeviationsFromExtrapolationPrinciples(), eRepresentativeness.getExtrapolations(), " // ");
        for (LangString langString : iRepresentativeness.getSamplingProcedure()) {
            eRepresentativeness.getSamplingProcedure().add(langString);
        }
        LangString.concat(iRepresentativeness.getDataSelectionPrinciples(), eRepresentativeness.getSamplingProcedure(), " // ");
    }

    private void exchanges(ILCDProcess iProcess, ES2Dataset eDataset) {
        int refFlow = -1;
        if (iProcess.quantitativeReference != null && !iProcess.quantitativeReference.getReferenceFlows().isEmpty()) {
            refFlow = iProcess.quantitativeReference.getReferenceFlows().get(0);
        }
        for (ILCDExchange iExchange : iProcess.getExchanges()) {
            if (iExchange.flowDataSet == null || iExchange.flowDataSet.getRefObjectId() == null) {
                this.logger.severe("No valid flow data set referenced in exchange: " + iExchange.id);
                continue;
            }
            String flowId = iExchange.flowDataSet.getRefObjectId();
            String es2Id = ElemFlowMap.ilcdToES2(flowId);
            if (es2Id != null) {
                ES2ElemFlowRec elemFlowRec = ES2ElemFlowRec.forID(es2Id);
                ES2ElementaryExchange eExchange = elemFlowRec.toExchange();
                eDataset.getElementaryExchanges().add(eExchange);
                eExchange.amount = iExchange.resultingAmount;
                if (iExchange.isInput()) {
                    eExchange.inputGroup = 4;
                } else {
                    eExchange.outputGroup = 4;
                }
                eExchange.isCalculatedAmount = iExchange.variableReference != null;
                continue;
            }
            ILCDElemFlowRec iElemFlowRec = ILCDElemFlowRec.forID(flowId);
            if (iElemFlowRec != null) {
                this.elementaryExchange(iExchange, iElemFlowRec, eDataset);
                continue;
            }
            this.intermediateExchange(iExchange, refFlow, flowId, eDataset);
        }
    }

    private void elementaryExchange(ILCDExchange iExchange, ILCDElemFlowRec iElemFlowRec, ES2Dataset eDataset) {
        String compId;
        ES2ElementaryExchange eExchange = new ES2ElementaryExchange();
        eDataset.getElementaryExchanges().add(eExchange);
        eExchange.amount = iExchange.resultingAmount;
        eExchange.casNumber = iElemFlowRec.getCas();
        eExchange.elementaryExchangeId = iElemFlowRec.getId();
        eExchange.formula = iElemFlowRec.getFormula();
        eExchange.id = UUID.randomUUID().toString();
        if (iExchange.isInput()) {
            eExchange.inputGroup = 4;
        } else {
            eExchange.outputGroup = 4;
        }
        eExchange.isCalculatedAmount = iExchange.variableReference != null;
        eExchange.getName().add(new LangString(iElemFlowRec.getName()));
        UnitMap.Entry entry = UnitMap.ildcToES2(iElemFlowRec.getPropertyId());
        if (entry != null) {
            eExchange.amount = entry.getFactor() * iExchange.resultingAmount;
            eExchange.unitId = entry.getId();
            ES2UnitRec uRec = ES2UnitRec.forID(entry.getId());
            if (uRec != null) {
                eExchange.getUnitNames().add(new LangString(uRec.getName()));
            }
        }
        if ((compId = CompartmentMap.ilcdToES2(iElemFlowRec.getCompartmentId())) != null) {
            eExchange.compartmentId = compId;
            ES2CompartmentRec cRec = ES2CompartmentRec.forID(compId);
            if (cRec != null) {
                eExchange.getCompartment().add(new LangString(cRec.getCompartment()));
                if (cRec.getSubCompartment() != null) {
                    eExchange.getSubCompartment().add(new LangString(cRec.getSubCompartment()));
                }
            }
        }
        if (!this.elemFlows.contains(eExchange.elementaryExchangeId)) {
            ES2ElemFlow eFlow = new ES2ElemFlow();
            this.elemFlows.getElemFlows().add(eFlow);
            eFlow.casNumber = eExchange.casNumber;
            eFlow.formula = eExchange.formula;
            eFlow.id = eExchange.elementaryExchangeId;
            eFlow.subCompartmentId = eExchange.compartmentId;
            eFlow.unitId = eExchange.unitId;
            eFlow.getName().addAll(eExchange.getName());
            eFlow.getCompartment().addAll(eExchange.getCompartment());
            eFlow.getSubCompartment().addAll(eExchange.getSubCompartment());
            eFlow.getSynonyms().addAll(eExchange.getSynonym());
            eFlow.getUnitName().addAll(eExchange.getUnitNames());
        }
    }

    private void intermediateExchange(ILCDExchange iExchange, int refFlow, String flowId, ES2Dataset eDataset) {
        Object _flow = this.fetch(iExchange.flowDataSet);
        if (!(_flow instanceof ILCDFlow)) {
            this.logger.severe("Cannot load flow for reference: " + iExchange.flowDataSet.getUri());
        } else {
            UnitMap.Entry entry;
            String propertyId;
            ILCDFlow iFlow = (ILCDFlow)_flow;
            ES2IntermediateExchange eExchange = new ES2IntermediateExchange();
            eDataset.getIntermediateExchanges().add(eExchange);
            eExchange.amount = iExchange.resultingAmount;
            eExchange.id = UUID.randomUUID().toString();
            eExchange.intermediateExchangeId = flowId;
            if (iFlow.description != null) {
                eExchange.getName().addAll(iFlow.description.getName());
                eExchange.casNumber = iFlow.description.casNumber;
            }
            if (iExchange.isInput()) {
                eExchange.inputGroup = 5;
            } else {
                eExchange.outputGroup = iExchange.id != null && iExchange.id == refFlow ? Integer.valueOf(0) : (iFlow.isWaste() ? Integer.valueOf(3) : (iFlow.isProduct() ? Integer.valueOf(2) : Integer.valueOf(5)));
            }
            List<ES2ClassificationRef> eClassifications = this.fetchClassifications(iFlow.description.getClassifications());
            if (eClassifications != null) {
                for (ES2ClassificationRef eClassification : eClassifications) {
                    eExchange.getProductClassifications().add(eClassification);
                }
            }
            String string = propertyId = iFlow.getReferenceProperty() == null ? null : iFlow.getReferenceProperty().getRefObjectId();
            if (propertyId != null && (entry = UnitMap.ildcToES2(propertyId)) != null) {
                eExchange.amount = entry.getFactor() * iExchange.resultingAmount;
                eExchange.unitId = entry.getId();
                ES2UnitRec uRec = ES2UnitRec.forID(entry.getId());
                if (uRec != null) {
                    eExchange.getUnitNames().add(new LangString(uRec.getName()));
                }
            }
            if (!this.productFlows.contains(eExchange.intermediateExchangeId)) {
                ES2ProductFlow eFlow = new ES2ProductFlow();
                this.productFlows.getProductFlows().add(eFlow);
                eFlow.casNumber = eExchange.casNumber;
                eFlow.id = eExchange.intermediateExchangeId;
                eFlow.unitId = eExchange.unitId;
                eFlow.getName().addAll(eExchange.getName());
                eFlow.getProductClassifications().addAll(eExchange.getProductClassifications());
                eFlow.getSynonyms().addAll(eExchange.getSynonym());
                eFlow.getUnitName().addAll(eExchange.getUnitNames());
            }
        }
    }

    private void map(ILCDProcessDescription iDescription, ES2Dataset eDataset) {
        ES2Description eDescription = eDataset.description;
        if (eDescription == null) {
            eDataset.description = eDescription = new ES2Description(true);
        }
        eDescription.id = UUID.randomUUID().toString();
        eDescription.activityNameId = iDescription.uuid != null ? iDescription.uuid : UUID.randomUUID().toString();
        for (LangString langString : iDescription.getName()) {
            String langCode = langString.getLangCode();
            String name = langString.getValue();
            Object toAdd = LangString.getFirst(iDescription.getTreatmentStandardsRoutes(), langCode);
            if (toAdd != null) {
                name = name + ", " + ((LangString)toAdd).getValue();
            }
            if ((toAdd = LangString.getFirst(iDescription.getMixAndLocationTypes(), langCode)) != null) {
                name = name + ", " + ((LangString)toAdd).getValue();
            }
            if ((toAdd = LangString.getFirst(iDescription.getFunctionalUnitFlowProperties(), langCode)) != null) {
                name = name + ", " + ((LangString)toAdd).getValue();
            }
            name = TypeCheck.checkLength(name, 120);
            LangString nameString = new LangString(langCode, name);
            eDescription.getName().add(nameString);
        }
        for (LangString langString : iDescription.getSynonyms()) {
            String synString = langString.getValue();
            if (synString == null) continue;
            String[] syns = synString.split(";");
            if (syns.length == 1) {
                eDescription.getSynonyms().add(TypeCheck.checkLength(langString, 80));
                continue;
            }
            for (String syn : syns) {
                String synonym = TypeCheck.checkLength(syn.trim(), 80);
                eDescription.getSynonyms().add(new LangString(langString.getLangCode(), synonym));
            }
        }
        List<ES2ClassificationRef> eClassifications = this.fetchClassifications(iDescription.getClassifications());
        for (ES2ClassificationRef eClassification : eClassifications) {
            eDataset.getClassifications().add(eClassification);
        }
        if (!iDescription.getComment().isEmpty()) {
            TextAndImage textAndImage;
            eDescription.generalComment = textAndImage = new TextAndImage();
            int idx = 1;
            for (LangString langString : iDescription.getComment()) {
                LangString mls = new LangString(langString.getLangCode(), langString.getValue());
                mls.setIndex(idx);
                textAndImage.getText().add(mls);
                ++idx;
            }
        }
    }

    private List<ES2ClassificationRef> fetchClassifications(List<ILCDClassification> iClassifications) {
        ArrayList<ES2ClassificationRef> eClassifications = new ArrayList<ES2ClassificationRef>();
        for (ILCDClassification iClassification : iClassifications) {
            if (this.classificationSystems.first() == null) continue;
            ES2ClassificationRef eClassifiaction = new ES2ClassificationRef();
            eClassifications.add(eClassifiaction);
            eClassifiaction.classificationId = this.classificationSystems.first().id;
            eClassifiaction.getClassificationSystem().addAll(this.classificationSystems.first().getName());
            String val = iClassification.getPath("/");
            ES2Classification clazz = this.classificationSystems.first().forName(val);
            if (clazz == null) {
                clazz = new ES2Classification();
                this.classificationSystems.first().getClassifications().add(clazz);
                clazz.id = UUID.randomUUID().toString();
                clazz.getName().add(new LangString(val));
            }
            eClassifiaction.getClassificationValue().addAll(clazz.getName());
            eClassifiaction.classificationId = clazz.id;
        }
        return eClassifications;
    }

    private void map(ILCDTime iTime, ES2Dataset eDataset) {
        Integer refYear;
        ES2TimePeriod eTime = eDataset.timePeriod;
        if (eTime == null) {
            eDataset.timePeriod = eTime = new ES2TimePeriod();
        }
        eTime.startDate = (refYear = iTime.referenceYear) != null ? refYear.toString() + "-01-01" : "9999-01-01";
        Integer validUntil = iTime.validUntil;
        eTime.endDate = validUntil != null ? validUntil.toString() + "-12-31" : "9999-12-31";
        eTime.dataValidForEntirePeriod = true;
        if (!iTime.getDescription().isEmpty()) {
            TextAndImage comment = eTime.comment;
            if (comment == null) {
                eTime.comment = comment = new TextAndImage();
            }
            int i = 1;
            for (LangString langString : iTime.getDescription()) {
                LangString commentText = new LangString(langString.getLangCode(), langString.getValue());
                commentText.setIndex(i++);
                comment.getText().add(commentText);
            }
        }
    }

    private void geography(ILCDGeography iGeography, ES2Dataset eDataset) {
        ES2GeographyRef eGeography;
        eDataset.geography = eGeography = new ES2GeographyRef();
        if (iGeography.location != null) {
            ES2GeographyRec geoRec = ES2GeographyRec.forShortName(iGeography.location);
            if (geoRec != null) {
                eGeography.geographyId = geoRec.getId();
                eGeography.getShortNames().add(new LangString(geoRec.getShortName()));
            } else {
                this.logger.severe("No EcoSpold location '" + iGeography.location + "' found.");
                eGeography.geographyId = "34dbbff8-88ce-11de-ad60-0019e336be3a";
                eGeography.getShortNames().add(new LangString("GLO"));
            }
        }
        if (!iGeography.getDescription().isEmpty()) {
            TextAndImage comment = eGeography.comment;
            if (comment == null) {
                eGeography.comment = comment = new TextAndImage();
            }
            int i = 1;
            for (LangString langString : iGeography.getDescription()) {
                LangString text = new LangString(langString.getLangCode(), langString.getValue());
                text.setIndex(i++);
                comment.getText().add(text);
            }
        }
    }

    private void map(ILCDProcessTechnology iTechnology, ES2Dataset eDataset) {
        LangString text;
        TextAndImage comment;
        ES2Technology eTechnology = eDataset.technology;
        if (eTechnology == null) {
            eDataset.technology = eTechnology = new ES2Technology();
        }
        int index = 1;
        if (!iTechnology.getDescription().isEmpty()) {
            comment = eTechnology.comment;
            if (comment == null) {
                eTechnology.comment = comment = new TextAndImage();
            }
            for (LangString langString : iTechnology.getDescription()) {
                text = new LangString(langString.getLangCode(), langString.getValue());
                text.setIndex(index++);
                comment.getText().add(text);
            }
        }
        if (!iTechnology.getApplicability().isEmpty()) {
            comment = eTechnology.comment;
            if (comment == null) {
                eTechnology.comment = comment = new TextAndImage();
            }
            for (LangString langString : iTechnology.getApplicability()) {
                text = new LangString(langString.getLangCode(), langString.getValue());
                text.setIndex(index++);
                comment.getText().add(text);
            }
        }
        eTechnology.technologyLevel = 0;
    }

    private void map(ILCDMathSection iMathSection, ES2Dataset eDataset) {
        for (ILCDParameter iParameter : iMathSection.getParameters()) {
            ES2Parameter eParameter = new ES2Parameter();
            eParameter.id = UUID.randomUUID().toString();
            if (iParameter.name != null) {
                eParameter.variableName = iParameter.name;
                eParameter.getName().add(new LangString(iParameter.name));
            }
            if (iParameter.meanValue != null) {
                eParameter.amount = iParameter.meanValue;
            }
            eParameter.mathematicalRelation = iParameter.formula;
            for (LangString comment : iParameter.getComment()) {
                eParameter.getComment().add(comment);
            }
            eDataset.getParameters().add(eParameter);
        }
    }

    private ES2Source source(ILCDSource iSource) {
        ES2Source eSource = new ES2Source();
        ILCDSourceDescription iDescription = iSource.description;
        if (iDescription != null) {
            eSource.id = iDescription.uuid;
            if (!iDescription.getShortName().isEmpty()) {
                LangString langString = iDescription.getShortName().get(0);
                eSource.shortName = langString.getValue();
                if (eSource.shortName != null && eSource.shortName.length() > 80) {
                    eSource.shortName = eSource.shortName.substring(0, 80);
                }
            }
            eSource.title = iDescription.sourceCitation;
            if (iDescription.sourceCitation != null) {
                eSource.firstAuthor = iDescription.sourceCitation.length() > 40 ? iDescription.sourceCitation.substring(0, 38) + "#" : iDescription.sourceCitation;
            }
            if (iDescription.publicationType != null) {
                String pubType = iDescription.publicationType;
                int ePubType = -1;
                if (pubType.equals("Undefined")) {
                    ePubType = 0;
                } else if (pubType.equals("Article in periodical")) {
                    ePubType = 1;
                } else if (pubType.equals("Chapter in anthology")) {
                    ePubType = 2;
                } else if (pubType.equals("Monograph")) {
                    ePubType = 3;
                } else if (pubType.equals("Direct measurement")) {
                    ePubType = 4;
                } else if (pubType.equals("Oral communication")) {
                    ePubType = 5;
                } else if (pubType.equals("Personal written communication")) {
                    ePubType = 6;
                } else if (pubType.equals("Questionnaire")) {
                    ePubType = 7;
                }
                eSource.sourceType = ePubType == -1 ? Integer.valueOf(0) : Integer.valueOf(ePubType);
            }
            for (LangString langString : iDescription.getComment()) {
                eSource.getComment().add(langString);
            }
        }
        return eSource;
    }

    private void generatorAndPublication(ILCDProcess iProcess, ES2Dataset eDataset) {
        ES2Publication ePublication;
        ILCDProcessPublication iPublication = iProcess.publication;
        eDataset.publication = ePublication = new ES2Publication();
        if (iPublication != null && iPublication.workflowStatus != null) {
            ePublication.dataPublishedIn = iPublication.workflowStatus.equals("Data set finalised; entirely published") ? Integer.valueOf(2) : (iPublication.workflowStatus.equals("Data set finalised; subsystems published") ? Integer.valueOf(1) : Integer.valueOf(0));
        }
        if (iPublication != null && iPublication.republicationReference != null) {
            Object iSource;
            String sourceId;
            ePublication.publishedSourceId = sourceId = iPublication.republicationReference.getRefObjectId();
            ePublication.publishedSourceContextId = CONTEXT_ID;
            ES2Source source = this.sourceList.getSource(sourceId);
            if (source == null && (iSource = this.fetch(iPublication.republicationReference)) instanceof ILCDSource && (source = this.source((ILCDSource)iSource)) != null) {
                this.sourceList.getSources().add(source);
            }
            if (source != null) {
                ePublication.publishedSourceFirstAuthor = source.firstAuthor;
                String string = ePublication.publishedSourceYear = source.year != null ? source.year.toString() : null;
            }
        }
        if (!iProcess.getDataGenerators().isEmpty()) {
            Object iContact;
            DataSetReference generatorRef = iProcess.getDataGenerators().get(0);
            ePublication.personId = generatorRef.getRefObjectId();
            ePublication.personContextId = CONTEXT_ID;
            ES2Person person = this.personList.getPerson(ePublication.personId);
            if (person == null && (iContact = this.fetch(generatorRef)) instanceof ILCDContact && (person = this.person((ILCDContact)iContact)) != null) {
                this.personList.getPersons().add(person);
            }
            if (person != null) {
                ePublication.personEmail = person.email;
                ePublication.personName = person.name;
            }
        }
        if (iPublication.copyright != null) {
            ePublication.isCopyrightProtected = iPublication.copyright;
        }
    }

    private ES2Person person(ILCDContact iContact) {
        ES2Person ePerson = new ES2Person();
        ILCDContactDescription iDescription = iContact.description;
        if (iDescription != null) {
            boolean isOrganisation = false;
            block0: for (ILCDClassification classification : iDescription.getClassifications()) {
                for (ILCDClass clazz : classification.getClasses()) {
                    if (clazz.name == null || !clazz.name.equals("Organisations")) continue;
                    isOrganisation = true;
                    continue block0;
                }
            }
            ePerson.id = iDescription.uuid;
            String string = ePerson.name = iDescription.getShortName().isEmpty() ? "no name" : iDescription.getShortName().get(0).getValue();
            if (isOrganisation) {
                ePerson.organisationName = ePerson.name;
            }
            ePerson.address = iDescription.getContactAddress().isEmpty() ? null : iDescription.getContactAddress().get(0).getValue();
            ePerson.telephone = iDescription.telephone;
            ePerson.telefax = iDescription.telefax;
            ePerson.email = iDescription.email != null ? iDescription.email : "no email";
            ePerson.organisationWebsite = iDescription.webAddress;
        }
        return ePerson;
    }

    private void dataEntryBy(ILCDProcess iProcess, ES2Dataset eDataSet) {
        ES2Entry entryBy;
        eDataSet.dataEntryBy = entryBy = new ES2Entry();
        ILCDProcessEntry iEntry = iProcess.entry;
        if (iEntry == null || iEntry.dataSetEntryReference == null) {
            this.logger.severe("No contact information for 'data entry by'.");
            return;
        }
        entryBy.personContextId = CONTEXT_ID;
        entryBy.personId = iEntry.dataSetEntryReference.getRefObjectId();
        ES2Person person = this.personList.getPerson(entryBy.personId);
        if (person == null) {
            Object iContact = this.fetch(iEntry.dataSetEntryReference);
            if (!(iContact instanceof ILCDContact)) {
                this.logger.severe("Cannot load the contact for the 'data entry by' reference.");
            } else {
                person = this.person((ILCDContact)iContact);
                if (person != null) {
                    this.personList.getPersons().add(person);
                }
            }
        }
        if (person != null) {
            entryBy.personEmail = person.email;
            entryBy.personName = person.name;
        }
    }

    private void fileAttributes(ES2Dataset eDataSet) {
        ES2FileAttributes fileAtts;
        eDataSet.fileAttributes = fileAtts = new ES2FileAttributes(true);
        fileAtts.creationTimestamp = Time.now();
        fileAtts.fileTimestamp = Time.now();
        fileAtts.fileGenerator = "openLCA data converter";
        fileAtts.contextId = CONTEXT_ID;
        fileAtts.getContextNames().add(CONTEXT_NAME);
    }

    @Override
    protected boolean matchEntry(String entryName) {
        boolean match = super.matchEntry(entryName);
        if (match) {
            match = entryName.contains("processes");
        }
        return match;
    }
}

