/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

public class KeyGen {
    public static String getKey(String value, int length) {
        String key = KeyGen.getKey(value);
        if (key.length() > length) {
            key = key.substring(key.length() - length);
        } else if (key.length() < length) {
            for (int diff = length - key.length(); diff > 0; --diff) {
                key = "0".concat(key);
            }
        }
        return key;
    }

    public static String getKey(String value) {
        int k = Math.abs(value.hashCode());
        StringBuffer keyBuffer = new StringBuffer();
        do {
            int mod = k % 16;
            switch (mod) {
                case 10: {
                    keyBuffer.insert(0, 'a');
                    break;
                }
                case 11: {
                    keyBuffer.insert(0, 'b');
                    break;
                }
                case 12: {
                    keyBuffer.insert(0, 'c');
                    break;
                }
                case 13: {
                    keyBuffer.insert(0, 'd');
                    break;
                }
                case 14: {
                    keyBuffer.insert(0, 'e');
                    break;
                }
                case 15: {
                    keyBuffer.insert(0, 'f');
                    break;
                }
                default: {
                    keyBuffer.insert(0, Integer.toString(mod));
                }
            }
        } while ((k /= 16) != 0);
        return keyBuffer.toString();
    }

    public static String getPseodoUUID(String ... args) {
        StringBuilder feed = new StringBuilder();
        StringBuilder key = new StringBuilder();
        if (args.length > 0 && args[0] != null) {
            feed.append(args[0]);
        }
        feed.reverse();
        key.append(KeyGen.getKey(feed.toString(), 8)).append("-");
        if (args.length > 1 && args[1] != null) {
            feed.append(args[1]);
        } else {
            feed.append(feed.toString());
        }
        feed.reverse();
        key.append(KeyGen.getKey(feed.toString(), 4)).append("-");
        if (args.length > 2 && args[2] != null) {
            feed.append(args[2]);
        } else {
            feed.append(feed.toString());
        }
        feed.reverse();
        key.append(KeyGen.getKey(feed.toString(), 4)).append("-");
        if (args.length > 3 && args[3] != null) {
            feed.append(args[3]);
        } else {
            feed.append(feed.toString());
        }
        feed.reverse();
        key.append(KeyGen.getKey(feed.toString(), 4)).append("-");
        if (args.length > 4 && args[4] != null) {
            feed.append(args[4]);
        } else {
            feed.append(feed.toString());
        }
        feed.reverse();
        key.append(KeyGen.getKey(feed.toString(), 12));
        return key.toString();
    }
}

