/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openlca.olcatdb.conversion.SPCategory;

public class SPMappingFile {
    private List<SPCategory> categories = new ArrayList<SPCategory>();

    public void add(SPCategory category) {
        if (!this.categories.contains(category)) {
            this.categories.add(category);
        }
    }

    private void write(BufferedWriter writer, String toWrite) throws IOException {
        writer.write(toWrite);
        writer.newLine();
    }

    public void writeToFile(String fileName) throws IOException {
        Collections.sort(this.categories);
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        this.write(writer, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.write(writer, "<root>");
        this.write(writer, "  <categories>");
        String lastCategory = null;
        for (SPCategory category : this.categories) {
            if (!category.getCategory().equals(lastCategory)) {
                if (lastCategory != null) {
                    this.write(writer, "    </category>");
                }
                this.write(writer, "    <category name=\"" + category.getCategory() + "\" type=\"process\" internalName=\"" + category.getCategory() + "\">");
                lastCategory = category.getCategory();
            }
            this.write(writer, "      <subCategory name=\"" + category.getSubCategory() + "\" processType=\"" + category.getProcessType() + "\"/>");
        }
        if (this.categories.size() > 0) {
            this.write(writer, "    </category>");
        }
        this.write(writer, "  </categories>");
        this.write(writer, "  <processes/>");
        this.write(writer, "  <mappings>");
        this.write(writer, "    <categories/>");
        this.write(writer, "    <units/>");
        this.write(writer, "    <quantities/>");
        this.write(writer, "    <substances/>");
        this.write(writer, "    <processes/>");
        this.write(writer, "    <sources/>");
        this.write(writer, "    <dummyProcesses/>");
        this.write(writer, "    <locations/>");
        this.write(writer, "  </mappings>");
        this.write(writer, "</root>");
        writer.flush();
        writer.close();
    }
}

