/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.LogHtmlFormatter;
import org.openlca.olcatdb.conversion.Monitor;
import org.openlca.olcatdb.conversion.Task;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Validation
implements Task {
    private ResourceFolder folder;
    private Monitor monitor;
    private boolean canceled = false;

    public Validation(ResourceFolder folder) {
        this.folder = folder;
    }

    @Override
    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void run() {
        List<File> files = this.folder.listFiles();
        if (this.monitor != null) {
            this.monitor.begin(files.size());
        }
        Logger logger = Logger.getLogger("org.openlca.olcatdb.conversion");
        FileHandler handler = null;
        try {
            handler = new FileHandler(this.folder.getValidationLog().getAbsolutePath());
            handler.setFormatter(new LogHtmlFormatter());
            logger.addHandler(handler);
        }
        catch (Exception e) {
            logger.severe("Cannot add file handler " + e.getMessage());
        }
        DocumentBuilder builder = this.docBuilder();
        if (builder == null) {
            logger.severe("Cannot set up document builder.");
        } else {
            ValidationHandler errorHandler = new ValidationHandler();
            builder.setErrorHandler(errorHandler);
            errorHandler.logger = logger;
            int worked = 0;
            for (File file : files) {
                if (this.canceled) break;
                errorHandler.file = file;
                if (this.monitor != null) {
                    this.monitor.progress("Validate " + file.getName(), ++worked);
                }
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".xml") && !file.getName().toLowerCase().endsWith(".spold")) continue;
                logger.info("Validate file " + file.getName());
                try {
                    builder.parse(file);
                }
                catch (Exception e) {
                    logger.severe("Cannot parse file " + file.getName() + ": " + e.getMessage());
                }
            }
        }
        if (handler != null) {
            handler.flush();
            handler.close();
            logger.removeHandler(handler);
        }
        if (this.monitor != null) {
            this.monitor.finished(this);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public ResourceFolder getResult() {
        return this.folder;
    }

    private DocumentBuilder docBuilder() {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            docBuilder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return docBuilder;
    }

    private class ValidationHandler
    implements ErrorHandler {
        private File file;
        private Logger logger;

        private ValidationHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            if (this.file != null && this.logger != null) {
                this.logger.severe("Validation of file " + this.file.getName() + ": " + ex.getMessage());
            }
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            if (this.file != null && this.logger != null) {
                this.logger.severe("Validation of file " + this.file.getName() + ": " + ex.getMessage());
            }
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            if (this.file != null && this.logger != null) {
                this.logger.warning("Validation of file " + this.file.getName() + ": " + ex.getMessage());
            }
        }
    }
}

