/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public enum XMLProcessFormat {
    EcoSpold1("EcoSpold 1", "ecoSpold", "http://www.EcoInvent.org/EcoSpold01"),
    EcoSpold1_Sima_Pro("EcoSpold 1 (SimaPro)", "ecoSpold", "http://www.EcoInvent.org/EcoSpold01"),
    EcoSpold2("EcoSpold 2", "ecoSpold", "http://www.EcoInvent.org/EcoSpold02"),
    ILCD("ILCD", "processDataSet", "http://lca.jrc.it/ILCD/Process"),
    CSV("CSV (SimaPro)", "", "");

    private final String name;
    private final String rootElement;
    private final String namespace;

    private XMLProcessFormat(String name, String rootElement, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.rootElement = rootElement;
    }

    public String toString() {
        return this.name;
    }

    public static XMLProcessFormat fromFile(String path) {
        return XMLProcessFormat.fromFile(new File(path));
    }

    public static XMLProcessFormat fromFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        XMLProcessFormat format = null;
        String name = file.getName().toLowerCase();
        if (name.endsWith(".xml") || name.endsWith(".spold")) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build(file);
                format = XMLProcessFormat.fromDocument(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (name.endsWith(".zip")) {
            try {
                ZipFile zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                SAXBuilder builder = new SAXBuilder();
                while (entries.hasMoreElements() && format == null) {
                    ZipEntry zipEntry = entries.nextElement();
                    if (!XMLProcessFormat.matches(zipEntry)) continue;
                    Document doc = builder.build(zipFile.getInputStream(zipEntry));
                    format = XMLProcessFormat.fromDocument(doc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (name.endsWith(".csv")) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                if (line.startsWith("{SimaPro")) {
                    format = CSV;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return format;
    }

    private static boolean matches(ZipEntry zipEntry) {
        String name = zipEntry.getName().toLowerCase();
        return !zipEntry.isDirectory() && (name.endsWith(".xml") || name.endsWith(".spold")) && !name.contains("flows") && !name.contains("flowproperties") && !name.contains("unitgroups") && !name.contains("contacts") && !name.contains("sources") && !name.contains("external_docs");
    }

    private static XMLProcessFormat fromDocument(Document doc) {
        XMLProcessFormat format = null;
        Element element = doc.getRootElement();
        if (element != null) {
            String rootName = element.getName();
            String namespace = element.getNamespaceURI();
            for (XMLProcessFormat f : XMLProcessFormat.values()) {
                if (!f.rootElement.equals(rootName) || !f.namespace.equals(namespace)) continue;
                format = f;
                break;
            }
        }
        return format;
    }
}

