/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathSearch
implements Runnable {
    private File xmlFile;
    private ZipFile zipFile;
    private XPathExpression expression;
    private QName resultType;
    private HashMap<String, String> result;
    private String filter;

    public XPathSearch(File file, String query) {
        if (file == null) {
            throw new IllegalArgumentException("The given file is NULL");
        }
        String fileName = file.getName();
        if (!this.isXml(fileName) && !this.isZip(fileName)) {
            throw new IllegalArgumentException("Unsupported file format.");
        }
        if (query == null || query.length() == 0) {
            throw new IllegalArgumentException("There is no XPath query given.");
        }
        String xQuery = query;
        if (query.contains("#")) {
            try {
                int pos = query.indexOf("#");
                xQuery = query.substring(pos + 1);
                this.filter = query.substring(0, pos).trim();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The XPath expression is not valid.");
            }
        }
        XPathFactory xpfactory = XPathFactory.newInstance();
        XPath xpath = xpfactory.newXPath();
        try {
            this.expression = xpath.compile(xQuery);
            this.resultType = this.resultType(xQuery);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The XPath expression is not valid.");
        }
        if (this.isXml(fileName)) {
            this.xmlFile = file;
        } else {
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The given file is not a valid ZIP file");
            }
        }
        this.result = new HashMap();
    }

    private boolean isXml(String fileName) {
        return fileName.endsWith(".xml") || fileName.endsWith(".XML");
    }

    private boolean isZip(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".ZIP");
    }

    @Override
    public void run() {
        this.result.clear();
        if (this.xmlFile != null) {
            this.singleSearch();
        } else if (this.zipFile != null) {
            this.bulkSearch();
        }
    }

    private void singleSearch() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.xmlFile);
            Object queryRes = this.expression.evaluate(doc, this.resultType);
            if (queryRes instanceof NodeList) {
                NodeList nodes = (NodeList)queryRes;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String key = nodes.item(i).getNodeName() + "_" + Integer.toString(i);
                    this.result.put(key, nodes.item(i).getNodeValue());
                }
            } else if (queryRes != null) {
                this.result.put("result", queryRes.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bulkSearch() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Enumeration<? extends ZipEntry> en = this.zipFile.entries();
            while (en.hasMoreElements()) {
                boolean matchEntry;
                ZipEntry zipEntry = en.nextElement();
                String name = zipEntry.getName();
                boolean bl = matchEntry = this.filter == null ? true : name.contains(this.filter);
                if (zipEntry.isDirectory() || !matchEntry || !name.endsWith(".xml") && !name.endsWith(".XML")) continue;
                Document doc = builder.parse(this.zipFile.getInputStream(zipEntry));
                Object queryRes = this.expression.evaluate(doc, this.resultType);
                if (queryRes instanceof NodeList) {
                    NodeList nodes = (NodeList)queryRes;
                    String resultStr = "";
                    if (nodes.getLength() > 1) {
                        resultStr = resultStr + "[";
                    }
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        if (nodes.item(i).getNodeValue() != null) {
                            resultStr = resultStr + nodes.item(i).getNodeValue();
                        }
                        if (i >= nodes.getLength() - 1) continue;
                        resultStr = resultStr + ", ";
                    }
                    if (nodes.getLength() > 1) {
                        resultStr = resultStr + "]";
                    }
                    this.result.put(name, resultStr);
                    continue;
                }
                if (queryRes == null) continue;
                this.result.put(name, queryRes.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, String> getResult() {
        return this.result;
    }

    private QName resultType(String query) {
        ArrayList<String> numberFuns = new ArrayList<String>();
        Collections.addAll(numberFuns, "sum(", "count(", "last(", "position(", "string-length(", "ceiling(", "floor(", "number(", "round(");
        ArrayList<String> boolFuns = new ArrayList<String>();
        Collections.addAll(boolFuns, "contains(", "starts-with(", "boolean(", "false(", "lang(", "not(", "true(");
        ArrayList<String> stringFuns = new ArrayList<String>();
        Collections.addAll(stringFuns, "concat(", "local-name(", "name(", "namespace-uri(", "normalize-space(", "string(", "substring(", "substring-after(", "substring-before(", "translate(", "format-number(", "generate-id(");
        if (this.match(query.trim(), numberFuns)) {
            return XPathConstants.NUMBER;
        }
        if (this.match(query.trim(), boolFuns)) {
            return XPathConstants.BOOLEAN;
        }
        if (this.match(query.trim(), stringFuns)) {
            return XPathConstants.STRING;
        }
        return XPathConstants.NODESET;
    }

    private boolean match(String query, List<String> functions) {
        for (String fn : functions) {
            if (!query.startsWith(fn)) continue;
            return true;
        }
        return false;
    }
}

