/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion.es2tocsv;

import com.greendeltatc.simapro.csv.model.SPDataEntry;
import com.greendeltatc.simapro.csv.model.SPDocumentation;
import com.greendeltatc.simapro.csv.model.SPLiteratureReference;
import com.greendeltatc.simapro.csv.model.SPLiteratureReferenceEntry;
import org.openlca.olcatdb.conversion.es2tocsv.ConversionUtils;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2FileAttributes;
import org.openlca.olcatdb.ecospold2.ES2RequiredContext;
import org.openlca.olcatdb.ecospold2.ES2Review;

public final class ConversionComment {
    static void literatureReference(SPDataEntry dataEntry, ES2Dataset dataset) {
        SPLiteratureReference literatureReference = new SPLiteratureReference("EcoSpold 2 data generator and publication", "", "EcoSpold");
        SPLiteratureReferenceEntry entry = new SPLiteratureReferenceEntry(literatureReference);
        dataEntry.getDocumentation().add(entry);
        StringBuilder builder = new StringBuilder();
        builder.append("#### Data generator and publication ###\n");
        if (dataset.publication.dataPublishedIn != null) {
            builder.append("data published in: " + dataset.publication.dataPublishedIn + "\n");
        }
        if (dataset.publication.publishedSourceYear != null) {
            builder.append("published source year:  " + dataset.publication.publishedSourceYear + "\n");
        }
        if (dataset.publication.publishedSourceFirstAuthor != null) {
            builder.append("published source first author: " + dataset.publication.publishedSourceFirstAuthor + "\n");
        }
        if (dataset.publication.pageNumbers != null) {
            builder.append("page numbers: " + dataset.publication.pageNumbers + "\n");
        }
        if (dataset.publication.isCopyrightProtected) {
            builder.append("is copyright protected: " + dataset.publication.isCopyrightProtected + "\n");
        }
        if (dataset.publication.accessRestrictedTo != null) {
            builder.append("access restricted to: " + dataset.publication.accessRestrictedTo + "\n");
        }
        if (dataset.publication.companyCode != null) {
            builder.append("company code: " + dataset.publication.companyCode);
        }
        entry.setComment(builder.toString());
    }

    static void record(SPDataEntry dataEntry, ES2Dataset dataset) {
        StringBuilder record = new StringBuilder();
        if (dataset.dataEntryBy != null || dataset.dataEntryBy.isActiveAuthor || dataset.dataEntryBy.personName != null || dataset.dataEntryBy.personEmail != null) {
            record.append("### Administrative information ###\n");
        }
        if (dataset.dataEntryBy.personName != null) {
            record.append("person name: " + dataset.dataEntryBy.personName + "\n");
        }
        if (dataset.dataEntryBy.isActiveAuthor) {
            record.append("is active author: " + dataset.dataEntryBy.isActiveAuthor + "\n");
        }
        if (dataset.dataEntryBy.personEmail != null) {
            record.append("person email: " + dataset.dataEntryBy.personEmail + "\n");
        }
        for (ES2RequiredContext context : dataset.fileAttributes.getRequiredContexts()) {
            String requiredContextName;
            record.append("\n### Context Reference ###\n");
            record.append("major release: " + context.majorRelease + "\n");
            record.append("minor release: " + context.minorRelease + "\n");
            record.append("major revision: " + context.majorRevision + "\n");
            record.append("minor revision: " + context.minorRevision + "\n");
            if (context.requiredContextFileLocation != null) {
                record.append("required context file location: " + context.requiredContextFileLocation + "\n");
            }
            if ((requiredContextName = ConversionUtils.getLangEntry(context.getRequiredContextName())) == null) continue;
            record.append("required context name: " + requiredContextName + "\n");
        }
        if (record.length() != 0) {
            dataEntry.getDocumentation().setRecord(record.toString());
        }
    }

    static void generator(SPDataEntry dataEntry, ES2Dataset dataset) {
        StringBuilder generator = new StringBuilder();
        if (dataset.publication.personName != null || dataset.publication.personEmail != null) {
            generator.append("#### Data generator and publication ###\n");
            if (dataset.publication.personName != null) {
                generator.append("person name: " + dataset.publication.personName + "\n");
            }
            if (dataset.publication.personEmail != null) {
                generator.append("person email: " + dataset.publication.personEmail);
            }
        }
        if (generator.length() != 0) {
            dataEntry.getDocumentation().setGenerator(generator.toString());
        }
    }

    static void collectionMethodANDDataTreatment(SPDataEntry dataEntry, ES2Dataset dataset) {
        String extrapolations;
        String samplingProcedure = ConversionUtils.getLangEntry(dataset.representativeness.getSamplingProcedure());
        if (samplingProcedure != null) {
            dataEntry.getDocumentation().setCollectionMethod("### Sampling Procedure ###\n" + samplingProcedure);
        }
        if ((extrapolations = ConversionUtils.getLangEntry(dataset.representativeness.getExtrapolations())) != null) {
            dataEntry.getDocumentation().setDataTreatment("### Extrapolations ###\n" + extrapolations);
        }
    }

    static void allocationRules(SPDataEntry dataEntry, ES2Dataset dataset) {
        String alloc;
        if (dataset.description != null && dataset.description.allocationComment != null && (alloc = ConversionUtils.getLangEntry(dataset.description.allocationComment.getText())) != null) {
            dataEntry.getDocumentation().setAllocationRules("### Allocation comment ###\n" + alloc);
        }
        if (dataEntry.getDocumentation().getAllocationRules() == null) {
            dataEntry.getDocumentation().setAllocationRules("");
        }
    }

    static void verification(SPDataEntry dataEntry, ES2Dataset dataset) {
        StringBuilder verification = new StringBuilder();
        for (ES2Review review : dataset.getReviews()) {
            String otherDetails;
            if (!verification.toString().equals("")) {
                verification.append("\n\n");
            }
            verification.append("### Review ###\n");
            if (review.reviewerName != null) {
                verification.append("reviewer name: " + review.reviewerName + "\n");
            }
            if (review.reviewerEmail != null) {
                verification.append("reviewer email: " + review.reviewerEmail + "\n");
            }
            if (review.reviewDate != null) {
                verification.append("reviewer date: " + review.reviewDate + "\n");
            }
            verification.append("reviewed major release:" + review.reviewedMajorRelease + "\n");
            verification.append("reviewed Minor Release: " + review.reviewedMinorRelease + "\n");
            verification.append("reviewed major revision: " + review.reviewedMajorRevision + "\n");
            verification.append("reviewed minor revision: " + review.reviewedMinorRevision + "\n");
            String details = ConversionUtils.getLangEntry(review.details.getText());
            if (details != null) {
                verification.append("details: " + details + "\n");
            }
            if ((otherDetails = ConversionUtils.getLangEntry(review.getOtherDetails())) == null) continue;
            verification.append("other details: " + otherDetails);
        }
        dataEntry.getDocumentation().setVerification(verification.toString());
    }

    static void documentationComment(SPDataEntry dataEntry, ES2Dataset dataset) {
        String contextName;
        String macroComment;
        String timePeriod;
        String technology;
        String includedActivitiesEnd;
        SPDocumentation doc = dataEntry.getDocumentation();
        StringBuilder comment = new StringBuilder();
        comment.append("\n### Activity Description ###\n");
        if (dataset.description.generalComment != null) {
            comment.append(ConversionUtils.getLangEntry(dataset.description.generalComment.getText()) + "\n");
        }
        if (dataset.description.inheritanceDepth != null) {
            comment.append("Inheritance depth: " + dataset.description.inheritanceDepth + "\n");
        }
        for (String tag : dataset.description.getTags()) {
            comment.append("tag: " + tag + "\n");
        }
        String synonym = ConversionUtils.getLangEntry(dataset.description.getSynonyms());
        if (synonym != null) {
            comment.append("synonym: " + synonym + "\n");
        }
        comment.append("special activity type: " + dataset.description.specialActivityType + "\n");
        String includedActivitiesStart = ConversionUtils.getLangEntry(dataset.description.getIncludedActivitiesStart());
        if (includedActivitiesStart != null) {
            comment.append("included activitie start: " + includedActivitiesStart + "\n");
        }
        if ((includedActivitiesEnd = ConversionUtils.getLangEntry(dataset.description.getIncludedActivitiesEnd())) != null) {
            comment.append("included activitie end: " + includedActivitiesEnd + "\n");
        }
        comment.append("energy value: " + dataset.description.energyValues + "\n");
        if (dataset.description.datasetIcon != null) {
            comment.append("dataset icon: " + dataset.description.datasetIcon + "\n");
        }
        for (ES2ClassificationRef classification : dataset.getClassifications()) {
            String classificationValue;
            String classificationSystem = ConversionUtils.getLangEntry(classification.getClassificationSystem());
            if (classificationSystem != null) {
                comment.append("classification system: " + classificationSystem + "\n");
            }
            if ((classificationValue = ConversionUtils.getLangEntry(classification.getClassificationValue())) == null) continue;
            comment.append("classification value: " + classificationValue + "\n");
        }
        String geoComment = ConversionUtils.getLangEntry(dataset.geography.comment.getText());
        if (geoComment != null) {
            comment.append("geography: " + geoComment + "\n");
        }
        if ((technology = ConversionUtils.getLangEntry(dataset.technology.comment.getText())) != null) {
            comment.append("technology: " + technology + "\n");
        }
        if ((timePeriod = ConversionUtils.getLangEntry(dataset.timePeriod.comment.getText())) != null) {
            comment.append("time period: " + timePeriod + "\n");
        }
        comment.append("data valid for entire period: " + dataset.timePeriod.dataValidForEntirePeriod + "\n");
        String macroName = ConversionUtils.getLangEntry(dataset.macroEconomicScenario.getName());
        if (macroName != null) {
            comment.append("macro-economic Scenario name: " + macroName + "\n");
        }
        if ((macroComment = ConversionUtils.getLangEntry(dataset.macroEconomicScenario.getComment())) != null) {
            comment.append("macro-economic Scenario comment: " + macroComment + "\n");
        }
        comment.append("\n### File attrubutes ###\n");
        ES2FileAttributes fileAttributes = dataset.fileAttributes;
        comment.append("major release: " + fileAttributes.majorRelease + "\n");
        comment.append("minor release: " + fileAttributes.minorRelease + "\n");
        comment.append("major revision: " + fileAttributes.majorRevision + "\n");
        comment.append("minor revision: " + fileAttributes.minorRevision + "\n");
        if (fileAttributes.defaultLanguage != null) {
            comment.append("default language: " + fileAttributes.defaultLanguage + "\n");
        }
        if (fileAttributes.creationTimestamp != null) {
            comment.append("creation timestamp: " + fileAttributes.creationTimestamp + "\n");
        }
        if (fileAttributes.lastEditTimestamp != null) {
            comment.append("last edit timestamp: " + fileAttributes.lastEditTimestamp + "\n");
        }
        if (fileAttributes.internalSchemaVersion != null) {
            comment.append("internal schema version: " + fileAttributes.internalSchemaVersion + "\n");
        }
        if (fileAttributes.fileGenerator != null) {
            comment.append("file generator: " + fileAttributes.fileGenerator + "\n");
        }
        if (fileAttributes.fileTimestamp != null) {
            comment.append("file timestamp: " + fileAttributes.fileTimestamp + "\n");
        }
        if ((contextName = ConversionUtils.getLangEntry(fileAttributes.getContextNames())) != null) {
            comment.append("context name: " + contextName + "\n");
        }
        comment.append("\n### Representativeness ###\n");
        String systemModelName = ConversionUtils.getLangEntry(dataset.representativeness.getSystemModelName());
        if (systemModelName != null) {
            comment.append("system model name: " + systemModelName + "\n");
        }
        comment.append("percent: " + dataset.representativeness.percent + "\n");
        doc.setComment(comment.toString());
    }
}

