/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion.es2tocsv;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.beanutils.PropertyUtils;
import org.openlca.olcatdb.conversion.es2tocsv.ActivityEntry;
import org.openlca.olcatdb.conversion.es2tocsv.ConversionUtils;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2Uncertainty;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.XmlContextParser;

public class DataSetMerger {
    void mergeChildAndParentDataset(ES2Dataset childDataset, Map<String, ActivityEntry> activityIndex, File sourceXml, ZipFile sourceZip, Logger logger) {
        try {
            ActivityEntry entry = activityIndex.get(childDataset.description.parentActivityId);
            if (entry == null) {
                logger.severe("For the child data set \"" + ConversionUtils.getLangEntry(childDataset.description.getName()) + "\" is the parent data set missing.");
            }
            ES2Dataset parentDataset = this.getParentDataset(entry.fileName, entry.id, sourceXml, sourceZip);
            this.merge(childDataset, parentDataset);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    private ES2Dataset getParentDataset(String fileName, String parentId, File sourceXml, ZipFile sourceZip) throws IOException {
        ES2Dataset dataset;
        block4: {
            ZipFile zf;
            ZipEntry entry;
            InputStream stream;
            ES2EcoSpold ecoSpold;
            XmlContextParser parser;
            block3: {
                dataset = null;
                parser = new XmlContextParser();
                if (sourceXml == null) break block3;
                FileInputStream stream2 = new FileInputStream(sourceXml);
                ES2EcoSpold ecoSpold2 = parser.getContext(ES2EcoSpold.class, stream2);
                if (ecoSpold2 == null) break block4;
                for (ES2Dataset d : ecoSpold2.getDatasets()) {
                    if (!d.description.id.equals(parentId)) continue;
                    dataset = d;
                }
                break block4;
            }
            if (sourceZip != null && (ecoSpold = parser.getContext(ES2EcoSpold.class, stream = sourceZip.getInputStream(entry = (zf = sourceZip).getEntry(fileName)))) != null) {
                for (ES2Dataset d : ecoSpold.getDatasets()) {
                    if (!d.description.id.equals(parentId)) continue;
                    dataset = d;
                }
            }
        }
        return dataset;
    }

    private void merge(Object child, Object parent) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (child == null) {
            throw new IllegalArgumentException("Object 'child' can not be null!");
        }
        if (parent != null) {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(child)) {
                if (!propertyDescriptor.getPropertyType().equals(List.class)) continue;
                List childList = (List)PropertyUtils.getSimpleProperty(child, propertyDescriptor.getName());
                List list = (List)PropertyUtils.getSimpleProperty(parent, propertyDescriptor.getName());
                if (list.size() <= 0) continue;
                this.compareList(childList, list);
            }
            Field[] fields = child.getClass().getDeclaredFields();
            HashSet groupSet = new HashSet();
            for (Field field : fields) {
                ContextField cf = this.getContextField(field);
                if (cf == null || cf.classGroup().equals(Object.class)) continue;
                groupSet.add(cf.classGroup());
            }
            for (Class clazz : groupSet) {
                ArrayList<Field> groupFields = new ArrayList<Field>();
                for (Field f : fields) {
                    ContextField cf = this.getContextField(f);
                    if (cf == null || !cf.classGroup().equals(clazz)) continue;
                    groupFields.add(f);
                }
                if (groupFields.size() <= 0) continue;
                this.mergeGroup(groupFields, child, parent);
            }
            fields = child.getClass().getFields();
            for (Field field : fields) {
                Object c = field.get(child);
                Object p = field.get(parent);
                if (field.getType().getSuperclass() != null && field.getType().getSuperclass().equals(ContextObject.class)) {
                    if (c == null && p != null) {
                        field.set(child, p);
                        continue;
                    }
                    if (c == null || p == null) continue;
                    this.merge(c, p);
                    continue;
                }
                if (field.getType() != null && field.getType().equals(ES2Uncertainty.class)) {
                    this.mergeUncertainty(c, p);
                    continue;
                }
                ContextField cf = this.getContextField(field);
                if (!cf.classGroup().equals(Object.class)) continue;
                boolean isOverwrittenByChild = this.isOverwrittenByChild(cf, child);
                if (cf.isMaster()) {
                    if (isOverwrittenByChild || p == null || !p.getClass().equals(String.class) || ((String)String.class.cast(p)).equals("")) continue;
                    field.set(child, p);
                    continue;
                }
                if (c != null || p == null) continue;
                field.set(child, p);
            }
        }
    }

    private void mergeGroup(List<Field> groupFields, Object child, Object parent) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field masterField = null;
        for (Field f : groupFields) {
            ContextField cf = this.getContextField(f);
            if (!cf.isMaster()) continue;
            masterField = f;
        }
        if (masterField == null) {
            throw new IllegalArgumentException("Master field is null.");
        }
        boolean isOverwritten = this.isOverwrittenByChild(this.getContextField(masterField), child);
        Object mC = masterField.get(child);
        Object mP = masterField.get(parent);
        boolean isParentMasterNull = mP == null;
        boolean isMasterEqual = false;
        if (mC != null && mP != null && mC.equals(mP)) {
            isMasterEqual = true;
        }
        if (!isOverwritten && !isParentMasterNull) {
            for (Field f : groupFields) {
                f.setAccessible(true);
                Object c = f.get(child);
                Object p = f.get(parent);
                if (isMasterEqual) {
                    if (f.getType().equals(List.class)) {
                        if (((List)p).size() <= 0) continue;
                        this.compareList((List)c, (List)p);
                        continue;
                    }
                    if (p == null) continue;
                    f.set(child, p);
                    continue;
                }
                f.set(child, p);
            }
        }
    }

    private void compareList(List child, List parent) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList temp = new ArrayList();
        for (Object p : parent) {
            boolean add = true;
            for (int i = 0; i < child.size() && add; ++i) {
                if (!child.get(i).equals(p)) continue;
                if (p.getClass().getSuperclass().equals(ContextObject.class)) {
                    this.merge(child.get(i), p);
                }
                add = false;
            }
            if (!add) continue;
            temp.add(p);
        }
        child.addAll(temp);
    }

    private ContextField getContextField(Field field) {
        ContextField cf = null;
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof ContextField)) continue;
            cf = (ContextField)annotation;
        }
        return cf;
    }

    private boolean isOverwrittenByChild(ContextField cf, Object child) throws IllegalArgumentException, IllegalAccessException {
        boolean result = false;
        if (cf != null && !cf.overwrittenByChild().equals("")) {
            for (Field f : child.getClass().getFields()) {
                if (!f.getName().equals(cf.overwrittenByChild())) continue;
                result = (Boolean)Boolean.class.cast(f.get(child));
            }
        }
        return result;
    }

    private void mergeUncertainty(Object child, Object parent) {
    }
}

